//==============================================================================
//
// $Copyright (C) 1999 - LEGO Company. All rights reserved.             $
//
// $Workfile:: ScoutDef.h                                               $
// 
// $Date:: 17/11/99 20:41                                               $
//                     
// $Revision:: 3                                                        $
//
//------------------------------------------------------------------------------
//
// Contains constant declarations for Scout related resources 
//
//==============================================================================


#ifndef SCOUTDEF__H
#define SCOUTDEF__H 1


//==============================================================================
// Task names 0-5
// Command use: start, stop, delt
//==============================================================================

#define TASK_MY_TASKNAME      0


//==============================================================================
// Subroutine names
// RAM subroutines: 0-2
// ROM subroutines: 3-32
// Command use: calls, dels
//==============================================================================

// Subroutines in RAM

#define SUB_MY_SUBNAME        0

// Subroutines in ROM

#define SUB_MOTOR_DRIVE       3
#define SUB_BASIC_MOTION      4
#define SUB_AVOID             5
#define SUB_MOVEMENTS         6
#define SUB_GET_AVERAGE_LIGHT 7
#define SUB_AUTO_ADJUST_LIGHT 8
#define SUB_SEEK              9
#define SUB_FIND_BRIGHT       10
#define SUB_GET_MOTOR_STATUS  11
#define SUB_MOTOR_2_SOUND     12
#define SUB_LIGHT_GEIGER      13
#define SUB_FWD               14
#define SUB_RWD               15
#define SUB_SPIN_RIGHT        16
#define SUB_SPIN_LEFT         17
#define SUB_FWD_TURN_RIGHT    18
#define SUB_RWD_TURN_LEFT     19
#define SUB_FWD_TURN_LEFT     20
#define SUB_RWD_TURN_RIGHT    21
#define SUB_ZIGZAG            22
#define SUB_CIRCLE_RIGHT      23
#define SUB_CIRCLE_LEFT       24
#define SUB_AVOID_RIGHT       25
#define SUB_AVOID_LEFT        26
#define SUB_BUGSHAKE          27
#define SUB_LOOP_AB           28
#define SUB_GET_SEMA0         29
#define SUB_GET_SEMA1         30
#define SUB_GET_SEMA2         31
#define SUB_INIT_SYS          32


//==============================================================================
// Scout modes
// Command use: scout
//==============================================================================

#define MODE_SA               0
#define MODE_POWER            1


//==============================================================================
// Scout sounds
// Command use: plays
//==============================================================================

// System sounds

#define SND_CLICK             0
#define SND_BEEP              1
#define SND_SWEEP_DOWN        2
#define SND_SWEEP_UP          3
#define SND_ERROR             4
#define SND_SWEEP_FAST        5
#define SND_REMOTE            6
#define SND_ENTER_SA          7
#define SND_KEY_ERROR         8
#define SND_NONE              9 /* Used to terminate another sound */

// Sound set contained sounds

#define SND_TOUCH1_PRES       10
#define SND_TOUCH1_REL        11
#define SND_TOUCH2_PRES       12
#define SND_TOUCH2_REL        13
#define SND_ENTER_BRIGHT      14
#define SND_ENTER_NORMAL      15
#define SND_ENTER_DARK        16
#define SND_1_BLINK           17
#define SND_2_BLINK           18
#define SND_COUNTER1          19
#define SND_COUNTER2          20
#define SND_TIMER1            21
#define SND_TIMER2            22
#define SND_TIMER3            23
#define SND_MAIL_RECEIVED     24
#define SND_SPECIAL1          25
#define SND_SPECIAL2          26
#define SND_SPECIAL3          27


//==============================================================================
// Sound command selection
// Command use: sound (1. parameter)
//==============================================================================

#define SOUND_SEL_SOUNDSET    0
#define SOUND_SEL_ONOFF       1

//==============================================================================
// Sound mute/unmute
// Command use: sound (2. parameter)
//==============================================================================

#define SNDCTRL_SOUND_ON      0
#define SNDCTRL_SOUND_OFF     1

//==============================================================================
// Sound sets
// Command use: sound (3. parameter)
//==============================================================================

#define SNDSET_NONE           0
#define SNDSET_BASIC          1
#define SNDSET_BUG            2
#define SNDSET_ALARM          3
#define SNDSET_RANDOM         4
#define SNDSET_SCIENCE        5

//==============================================================================
// Shorthand versions for sound control
//==============================================================================

#define mute                  sound SOUND_SEL_ONOFF, SOUND_SOUND_OFF, 0
#define speak                 sound SOUND_SEL_ONOFF, SOUND_SOUND_ON, 0
#define sndset                sound SOUND_SEL_SOUNDSET, 0,


//==============================================================================
// Sound feedback bitmasks
// Command use: setfb
//==============================================================================

#define FBMASK_NO_FB          0x0000
#define FBMASK_TOUCH          0x000F  /* 0000 0000 0000 1111 */
#define FBMASK_LIGHT          0x0050  /* 0000 0000 0111 0000 */
#define FBMASK_HEART          0x0800  /* 0000 1000 0000 0000 */
#define FBMASK_SA             0x085F  /* 0000 1000 0111 1111 */


//==============================================================================
// Source names
// Command use: Multiple
//==============================================================================
                
#define SRC_VAR               0 
#define SRC_TIMER             1 
#define SRC_CON               2 
#define SRC_MOTSTA            3 
#define SRC_RAN               4 
#define SRC_SENVAL            9 
#define SRC_SENTYPE           10  
#define SRC_SENRAW            12  
#define SRC_MESSAGE           15  
#define SRC_MOTSET            17  
#define SRC_SASET             18  
#define SRC_LIGHTPAR          19  
#define SRC_TIMERLIM          20  
#define SRC_COUNTER           21  
#define SRC_COUNTERLIM        22  
#define SRC_EVENT             23  
#define SRC_SOUND             24  


//==============================================================================
// Variable names
// Global variables: 0-9
// Local variables : 10-17
// Command use: Together with SRC_VAR
//==============================================================================

// Global variables

#define GV_MY_VARIABLE        0

// Local variables

#define LV_MY_VARIABLE        10


//==============================================================================
// Timer names
// Command use: tmrs, tmrz
//              Together with SRC_TIMER and SRC_TIMERLIM
//==============================================================================

#define TIMER_1               0
#define TIMER_2               1
#define TIMER_3               2


//==============================================================================
// Constant names
// Command use: Together with SRC_CON
//==============================================================================

#define K_MY_CONSTANT         0


//==============================================================================
// Output names
// Command use: Together with SRC_MOTSTA and SRC_MOTSET
//==============================================================================

#define OUTPUT_A              0
#define OUTPUT_B              1
#define OUTPUT_C              2


//==============================================================================
// Sensor names
// Command use: Together with SRC_SENVAL, SRC_SENTYPE and SRC_SENRAW
//==============================================================================

#define SEN_TOUCH1            0
#define SEN_TOUCH2            1
#define SEN_LIGHT             2


//==============================================================================
// Touch sensor states
// Setting of touch sensor value
//==============================================================================

#define TVAL_RELEASED         0
#define TVAL_PRESSED          1


//==============================================================================
// Touch sensor ID
// Setting of touch sensor type
//==============================================================================

#define TOUCH_ID_RED          5
#define TOUCH_ID_YELLOW       6
#define TOUCH_ID_WHITE        7


//==============================================================================
// Light sensor states
// Setting of light sensor value
//==============================================================================

#define LVAL_DARK             0
#define LVAL_NORMAL           1
#define LVAL_BRIGHT           2
#define LVAL_UNDEFINED        255


//==============================================================================
// Mailbox name
// Command use: Together with SRC_MESSAGE
//==============================================================================

#define MAILBOX_SCOUT         0

//==============================================================================

// Stand Alone setup groups
// Command use: Together with SRC_SASET
//==============================================================================

#define SA_MOTION             0
#define SA_TOUCH              1
#define SA_LIGHT              2
#define SA_TIME               3
#define SA_FX                 4


//==============================================================================
// Stand Alone Scout setup
// Command use: rules
//==============================================================================

// Motion rules

#define MR_NO_MOTION          0
#define MR_FORWARD            1
#define MR_ZIGZAG             2
#define MR_CIRCLE_RIGHT       3
#define MR_CIRCLE_LEFT        4
#define MR_LOOP_A             5
#define MR_LOOP_B             6
#define MR_LOOP_AB            7

// Touch rules

#define TR_IGNORE             0
#define TR_REVERSE            1
#define TR_AVOID              2
#define TR_WAIT_FOR           3
#define TR_OFF_WHEN           4

// Light rules

#define LR_IGNORE             0
#define LR_SEEK_LIGHT         1
#define LR_SEEK_DARK          2
#define LR_AVOID              3
#define LR_WAIT_FOR           4
#define LR_OFF_WHEN           5

// Time group settings

#define TGS_SHORT             0
#define TGS_MEDIUM            1
#define TGS_LONG              2

// FX rules

#define FXR_NONE              0
#define FXR_BUG               1
#define FXR_ALARM             2
#define FXR_RANDOM            3
#define FXR_SCIENCE           4


//==============================================================================
// Counter names
// Command use: cntd, cnti, cnts, cntz
//              Together with SRC_COUNTER and SRC_COUNTERLIM
//==============================================================================

#define COUNTER_1             0
#define COUNTER_2             1


//==============================================================================
// Task event register
// Command use: Together with SRC_EVENT
//==============================================================================

#define REG_TASKEVENT         0


//==============================================================================
// Sound feedback register
// Command use: Together with SRC_SOUND
//==============================================================================

#define REG_SOUNDFBK          0


//==============================================================================
// Output direction actions
// Command use: dir, gdir
//==============================================================================

#define DIR_BACKWARD          0
#define DIR_CHGDIR            1
#define DIR_FORWARD           2

//==============================================================================
// Shorthand versions for motor direction settings
//==============================================================================

#define rwd     dir     DIR_BACKWARD, 
#define fwd     dir     DIR_FORWARD, 
#define alt     dir     DIR_CHGDIR, 

#define grwd    gdir    DIR_BACKWARD, 
#define gfwd    gdir    DIR_FORWARD, 
#define galt    gdir    DIR_CHGDIR, 


//==============================================================================
// Output switch actions
// Command use: out, gout
//==============================================================================

#define OUT_FLOAT             0
#define OUT_OFF               1
#define OUT_ON                2

//==============================================================================
// Shorthand versions for motor control
//==============================================================================

#define on      out     OUT_ON, 
#define off     out     OUT_OFF,
#define float   out     OUT_FLOAT, 

#define gon     gout    OUT_ON,
#define goff    gout    OUT_OFF,
#define gfloat  gout    OUT_FLOAT, 


//==============================================================================
// Output lists
// Command use: dir, gdir, out, gout, pwr and gpwr 
//==============================================================================

#define OUTLIST_A             1 
#define OUTLIST_B             2
#define OUTLIST_AB            3
#define OUTLIST_C             4
#define OUTLIST_AC            5
#define OUTLIST_BC            6
#define OUTLIST_ABC           7


//==============================================================================
// Resources
// Motor A: A
// Motor B: B
// Sound  : S
// VLL    : V
// Command use: monal
//==============================================================================

#define RES_A                 1
#define RES_B                 2
#define RES_AB                3
#define RES_S                 4
#define RES_AS                5
#define RES_BS                6
#define RES_ABS               7
#define RES_V                 8
#define RES_AV                9
#define RES_BV                10
#define RES_ABV               11
#define RES_SV                12
#define RES_ASV               13
#define RES_BSV               14
#define RES_ABSV              15


//==============================================================================
// Priority levels
// Command use: setp
//==============================================================================

#define PRT0                  0
#define PRT1                  1
#define PRT2                  2
#define PRT3                  3
#define PRT4                  4
#define PRT5                  5
#define PRT6                  6
#define PRT7                  7


//==============================================================================
// Micro Scout VLL codes
// _D_ are direct commands
// _S_ are script commands
// Command use: vll
//==============================================================================

#define MSVLL_D_FWD           0
#define MSVLL_D_RWD           1

#define MSVLL_D_BEEP1         4
#define MSVLL_D_BEEP2         5
#define MSVLL_D_BEEP3         6
#define MSVLL_D_BEEP4         7
#define MSVLL_D_BEEP5         8

#define MSVLL_S_FWD05         16
#define MSVLL_S_FWD1          17
#define MSVLL_S_FWD2          18
#define MSVLL_S_FWD5          19

#define MSVLL_S_RWD05         20
#define MSVLL_S_RWD1          21
#define MSVLL_S_RWD2          22
#define MSVLL_S_RWD5          23

#define MSVLL_S_BEEP1         24
#define MSVLL_S_BEEP2         25
#define MSVLL_S_BEEP3         26
#define MSVLL_S_BEEP4         27
#define MSVLL_S_BEEP5         28

#define MSVLL_S_WAIT4_LIGHT   29
#define MSVLL_S_SEEK_LIGHT    30
#define MSVLL_S_CODE          31
#define MSVLL_S_KEEP_ALIVE    32

#define MSVLL_D_RUN           33
#define MSVLL_D_DEL_SCRIPT    34


//==============================================================================
// Fine resolution time constants
// Command use: wait, playt and playv
//==============================================================================

#define FR_MS_10              1
#define FR_MS_20              2
#define FR_MS_30              3
#define FR_MS_40              4
#define FR_MS_50              5
#define FR_MS_60              6
#define FR_MS_70              7
#define FR_MS_80              8
#define FR_MS_90              9
#define FR_MS_100             10
#define FR_MS_150             15
#define FR_MS_200             20
#define FR_MS_250             25
#define FR_MS_300             30
#define FR_MS_350             35
#define FR_MS_400             40
#define FR_MS_450             45
#define FR_MS_500             50
#define FR_MS_600             60
#define FR_MS_700             70
#define FR_MS_800             80
#define FR_MS_900             90
#define FR_SEC_1              100
#define FR_SEC_2              200       
#define FR_SEC_3              300
#define FR_SEC_4              400
#define FR_SEC_5              500
#define FR_SEC_6              600
#define FR_SEC_7              700
#define FR_SEC_8              800
#define FR_SEC_9              900
#define FR_SEC_10             1000
#define FR_SEC_15             1500
#define FR_SEC_20             2000
#define FR_SEC_30             3000
#define FR_MIN_1              6000


//==============================================================================
// Coarse resolution time constants
// Command use: Together with timers
//==============================================================================

#define CR_MS_100             1
#define CR_MS_200             2
#define CR_MS_300             3
#define CR_MS_400             4
#define CR_MS_500             5
#define CR_MS_600             6
#define CR_MS_700             7
#define CR_MS_800             8
#define CR_MS_900             9
#define CR_SEC_1              10
#define CR_SEC_2              20
#define CR_SEC_3              30
#define CR_SEC_4              40
#define CR_SEC_5              50
#define CR_SEC_6              60
#define CR_SEC_7              70
#define CR_SEC_8              80
#define CR_SEC_9              90
#define CR_SEC_10             100
#define CR_SEC_15             150
#define CR_SEC_20             200
#define CR_SEC_30             300
#define CR_MIN_1              600
#define CR_MIN_2              1200
#define CR_MIN_3              1800
#define CR_MIN_4              2400
#define CR_MIN_5              3000
#define CR_MIN_10             6000


//==============================================================================
// Tones
// Command use: playt
//==============================================================================

#define TONE_A4               220
#define TONE_AS               247
#define TONE_C4               262
#define TONE_CS4              277        
#define TONE_D4               294
#define TONE_DS4              311
#define TONE_E4               330
#define TONE_F4               349
#define TONE_FS4              370
#define TONE_G4               392
#define TONE_GS4              415

#define TONE_A5               440
#define TONE_AS5              466
#define TONE_B5               494
#define TONE_C5               523        
#define TONE_CS5              554
#define TONE_D5               587
#define TONE_DS5              622
#define TONE_E5               659
#define TONE_F5               698
#define TONE_FS5              740
#define TONE_G5               784
#define TONE_GS5              831

#define TONE_A6               880
#define TONE_AS6              932
#define TONE_B6               988
#define TONE_C6               1047
#define TONE_CS6              1109
#define TONE_D6               1175
#define TONE_DS6              1245
#define TONE_E6               1319
#define TONE_F6               1397
#define TONE_FS6              1480
#define TONE_G6               1568
#define TONE_GS6              1661

#define TONE_A7               1760
#define TONE_AS7              1865
#define TONE_B7               1976
#define TONE_C7               2093
#define TONE_CS7              2217
#define TONE_D7               2349
#define TONE_DS7              2489
#define TONE_E7               2637
#define TONE_F7               2794
#define TONE_FS7              2960
#define TONE_G7               3136
#define TONE_GS7              3322


//==============================================================================
// IR range settings
// Command use: txs
//==============================================================================

#define IRRANGE_SHORT         0
#define IRRANGE_LONG          1


//==============================================================================
// Eventlist bitmasks
// Command use: event, mone
//==============================================================================

#define EVENT_NONE            0x0000  /* 0000 0000 0000 0000 */

#define EVENT_T1PR            0x0001  /* 0000 0000 0000 0001 */
#define EVENT_T1RE            0x0002  /* 0000 0000 0000 0010 */
#define EVENT_T1              0x0003  /* 0000 0000 0000 0011 */

#define EVENT_T2PR            0x0004  /* 0000 0000 0000 0100 */
#define EVENT_T2RE            0x0008  /* 0000 0000 0000 1000 */
#define EVENT_T2              0x000C  /* 0000 0000 0000 1100 */

#define EVENT_TPR             0x0005  /* 0000 0000 0000 0101 */
#define EVENT_TRE             0x000A  /* 0000 0000 0000 1010 */

#define EVENT_TOUCH           0x000F  /* 0000 0000 0000 1111 */

#define EVENT_LGT             0x0010  /* 0000 0000 0001 0000 */
#define EVENT_NOR             0x0020  /* 0000 0000 0010 0000 */
#define EVENT_LGT_NOR         0x0030  /* 0000 0000 0011 0000 */
#define EVENT_DAR             0x0040  /* 0000 0000 0100 0000 */
#define EVENT_LGT_DAR         0x0050  /* 0000 0000 0101 0000 */
#define EVENT_NOR_DAR         0x0060  /* 0000 0000 0110 0000 */
#define EVENT_LGT_NOR_DAR     0x0070  /* 0000 0000 0111 0000 */

#define EVENT_1BLINK          0x0080  /* 0000 0000 1000 0000 */
#define EVENT_2BLINKS         0x0100  /* 0000 0001 0000 0000 */

#define EVENT_CTR1            0x0200  /* 0000 0010 0000 0000 */
#define EVENT_CTR2            0x0400  /* 0000 0100 0000 0000 */
#define EVENT_CTR             0x0600  /* 0000 0110 0000 0000 */

#define EVENT_TMR1            0x0800  /* 0000 1000 0000 0000  */
#define EVENT_TMR2            0x1000  /* 0001 0000 0000 0000  */
#define EVENT_TMR3            0x2000  /* 0010 0000 0000 0000  */

#define EVENT_PBM             0x4000  /* 0100 0000 0000 0000  */


//==============================================================================
// Boolean values
//==============================================================================

#define K_FALSE               0
#define K_TRUE                1

#define K_OFF                 0
#define K_ON                  1


//==============================================================================
// Logical comparison operators
// Command use: chk, chkl
//==============================================================================

#define GT                    0 /* Greater than */
#define LT                    1 /* Less than */
#define EQ                    2 /* Equal to */
#define NE                    3 /* Not equal to */


//==============================================================================
// Remote control bitmasks
// Command use: remote
//==============================================================================

#define REMOTE_RELEASE        0x0000  /* 0000 0000 0000 0000 */

#define REMOTE_MES1           0x0100  /* 0000 0001 0000 0000 */
#define REMOTE_MES2           0x0200  /* 0000 0010 0000 0000 */
#define REMOTE_MES3           0x0400  /* 0000 0100 0000 0000 */

#define REMOTE_A_FWD          0x0800  /* 0000 1000 0000 0000 */
#define REMOTE_B_FWD          0x1000  /* 0001 0000 0000 0000 */
#define REMOTE_C_FWD          0x2000  /* 0010 0000 0000 0000 */
#define REMOTE_A_RWD          0x4000  /* 0100 0000 0000 0000 */
#define REMOTE_B_RWD          0x8000  /* 1000 0000 0000 0000 */
#define REMOTE_C_RWD          0x0001  /* 0000 0000 0000 0001 */

#define REMOTE_P1             0x0002  /* 0000 0000 0000 0010 */
#define REMOTE_P2             0x0004  /* 0000 0000 0000 0100 */
#define REMOTE_P3             0x0008  /* 0000 0000 0000 1000 */
#define REMOTE_P4             0x0010  /* 0000 0000 0001 0000 */
#define REMOTE_P5             0x0020  /* 0000 0000 0010 0000 */

#define REMOTE_STOP           0x0040  /* 0000 0000 0100 0000 */

#define REMOTE_SOUND          0x0080  /* 0000 0000 1000 0000 */


//==============================================================================
// pollp magic numbers
// Command use: pollp
//==============================================================================

#define POLLP_N1              1
#define POLLP_N2              3
#define POLLP_N3              5
#define POLLP_N4              7
#define POLLP_N5              11


//==============================================================================
// Memory addresses
// Command use: pollm
//==============================================================================

// PB message register

#define ADD_MESSAGE           0x00000096

//------------------------------------------------------------------------------
//      Input/output
//------------------------------------------------------------------------------

#define ADD_IO                0x00000100

// Input states

#define     ADD_T1_STATE      ADD_IO + 46
#define     ADD_T2_STATE      ADD_IO + 47
#define     ADD_L_STATE       ADD_IO + 48

// Input types

#define     ADD_T1_TYPE       ADD_IO + 49
#define     ADD_T2_TYPE       ADD_IO + 50

// Input (raw) value

#define     ADD_T1_VAL_LO     ADD_IO + 52
#define     ADD_T1_VAL_HI     ADD_IO + 53
#define     ADD_T2_VAL_LO     ADD_IO + 54
#define     ADD_T2_VAL_HI     ADD_IO + 55
#define     ADD_L_VAL_LO      ADD_IO + 56
#define     ADD_L_VAL_HI      ADD_IO + 57

// Battery voltage
// The relation between the value BV read in BatteryVoltage and the actual
// voltage Vbat on the battery is: Vbat = 0.109*BV

#define     ADD_BATTERY       ADD_IO + 58

// Output State Registers

#define     ADD_OUTA_STATE    ADD_IO + 68
#define     ADD_OUTB_STATE    ADD_IO + 69
#define     ADD_OUTC_STATE    ADD_IO + 70

//------------------------------------------------------------------------------
//      Global variables
//------------------------------------------------------------------------------

#define ADD_GV                0x000001B7

#define     ADD_VAR0_LO       ADD_GV
#define     ADD_VAR0_HI       ADD_GV + 1
#define     ADD_VAR1_LO       ADD_GV + 2
#define     ADD_VAR1_HI       ADD_GV + 3
#define     ADD_VAR2_LO       ADD_GV + 4
#define     ADD_VAR2_HI       ADD_GV + 5
#define     ADD_VAR3_LO       ADD_GV + 6
#define     ADD_VAR3_HI       ADD_GV + 7
#define     ADD_VAR4_LO       ADD_GV + 8
#define     ADD_VAR4_HI       ADD_GV + 9
#define     ADD_VAR5_LO       ADD_GV + 10
#define     ADD_VAR5_HI       ADD_GV + 11
#define     ADD_VAR6_LO       ADD_GV + 12
#define     ADD_VAR6_HI       ADD_GV + 13
#define     ADD_VAR7_LO       ADD_GV + 14
#define     ADD_VAR7_HI       ADD_GV + 15
#define     ADD_VAR8_LO       ADD_GV + 16
#define     ADD_VAR8_HI       ADD_GV + 17
#define     ADD_VAR9_LO       ADD_GV + 18
#define     ADD_VAR9_HI       ADD_GV + 19

//------------------------------------------------------------------------------
//      Counters
//------------------------------------------------------------------------------

#define ADD_CTR               0x0000022B

#define     ADD_CTR1_LO       ADD_CTR
#define     ADD_CTR1_HI       ADD_CTR + 1
#define     ADD_CTR2_LO       ADD_CTR + 2
#define     ADD_CTR2_HI       ADD_CTR + 3


#endif // SCOUTDEF__H
