//RCX2MLT.h - RCX2 macro lookup table
//////////////////////////////////////////
//Last edit: 10/04/00
//
//////////////////////////////////////////
//Global initialisation

macro bbs_GlobalReset(nMotors) {
	off nMotors
	dir nMotors [ ]
	power nMotors 8

	global on nMotors
	global dir nMotors [ ]
	global power nMotors 8

	sound on  //not a small block
	clear message
	randomize  //not a small block
}

//////////////////////////////////////////
//Two motor macros

macro bb_Forward(nLeft, nRight, nTime) {
	dir [nLeft nRight] [ ]
	on [nLeft nRight]
	wait nTime
	float [nLeft nRight]
}


macro bb_Backward(nLeft, nRight, nTime) {
	dir [ ] [nLeft nRight]
	on [nLeft nRight]
	wait nTime
	float [nLeft nRight]
}


macro bb_SpinLeft(nLeft, nRight, nTime) {
	dir nRight nLeft
	on [nLeft nRight]
	wait nTime
	float [nLeft nRight]
}


macro bb_SpinRight(nLeft, nRight, nTime) {
	dir nLeft nRight
	on [nLeft nRight]
	wait nTime
	float [nLeft nRight]
}


macro bb_Dance(nLeft, nRight, nRepeat, nTime) {
	repeat nRepeat {
		dir [nLeft nRight] [ ]
		on [nLeft nRight]
		wait nTime
		dir [] [nLeft nRight]
		wait nTime
		wait nTime
		dir [nLeft nRight] [ ]
		wait nTime
		wait nTime
		dir [ ] [nLeft nRight]
		wait nTime

		dir [nLeft] [nRight]
		wait nTime
		dir [nRight] [nLeft]
		wait nTime
		wait nTime
		dir [nLeft] [nRight]
		wait nTime
		wait nTime
		dir [nRight] [nLeft]
		wait nTime
		off [nLeft nRight]
	}
}
