/***************************************************************************
 Das Programm liest die Funkwettervorhersage von hamsql.com und gibt diese 
 an Analoge Anzeigen aus. 
 Das Programm ist geschrieben für einen ESP8266, dieser gibt PWM in 1024
 Schritten als 3v Signal aus, ideal sind als 3v Instrumente.
 Wenn nciht schon geschehen in der Boardverwaltung ESP8266 boards ergänzen
 zuvor unter DATEI > Voreinstellungen den Pfad 
 http://arduino.esp8266.com/stable/package_esp8266com_indes.json ergänzen.
 Sollen 5v Instrumente verwendet werden muss ein Universaltransistor als
 Treiber vorgesehen werden, bei 3v Instrumenten ggf die max. PW beschränken.
 (Siehe Zeile 216). Danke an 'kolarisk' für die Inspiration
 ************************************************73 de DO1ATM - Tom -*******/

#include <ESP8266WiFi.h>
#include <WiFiClientSecure.h>
WiFiClientSecure client;

char ssid[] = "NAME ";                          // Name des WLAN Netzwerkes
char password[] = "PASS";                       // WLan Passwort
// char ssid[] = "your network SSID (name)";    // Name des WLAN Netzwerkes
//char password[] = "your network Password";    // WLan Passwort
int SFIPin  = 14;                               //Anzeige Solarer Flux an ESP8622 Pin D5    
int SNPin   = 12;                               //Anzeige Sonnenflecken Anzeige an ESP8622 Pin D6 
int XRAYPin = 13;                               //Anzeige Röntgenstrahlung an ESP8622 Pin D7
int MUFPin  = 15;                               //Anzeige für MUF an ESP8622 Pin D8
int ERRORPin= 16;                               //Anzeige für reboot an ESP8622 Pin D0SN
unsigned long requestDue = 0;                   //Variable für die Wartezeit zwischen den abrufen
#define HOST "hamqsl.com"                       //da werde die Daten geholt

void setup() {                                  //an den Pins soll was ausgegeben werden
pinMode (SFIPin, OUTPUT);
pinMode (SNPin, OUTPUT);
pinMode (XRAYPin, OUTPUT);
pinMode (MUFPin, OUTPUT);
pinMode (ERRORPin, OUTPUT);
Serial.begin(115200);                           //Debugginginfos gehen an die seriellle console

/*  Startup Needle Wipe  
    Funktionstest der Anzeigen, in fünferschritten wird die Pulsweite der Ausgangspins erhöht, somit wandern dei Zeiger langsam 
    Richtung Vollausschlag und anschliesend wieder zurück. Der ESP kann 1024 Werte unterscheiden. */
                         
   for (int fadeValue = 0 ; fadeValue <= 1023; fadeValue += 5) {
       analogWrite(SFIPin, fadeValue);
       analogWrite(SNPin, fadeValue);
       analogWrite(XRAYPin, fadeValue);
       analogWrite(MUFPin, fadeValue);  
       analogWrite(ERRORPin, fadeValue);
       delay(15);
       }
   for (int fadeValue = 1023 ; fadeValue >= 0; fadeValue -= 5) {
        analogWrite(SFIPin, fadeValue);
        analogWrite(SNPin, fadeValue);
        analogWrite(XRAYPin, fadeValue);
        analogWrite(MUFPin, fadeValue);
        analogWrite(ERRORPin, fadeValue);
        delay(10);
        }
          
/*  Attempt to connect to Wifi network:
    Jetzt wird versucht sich mit dem WLan zu verbinden, die einzelenne schritte werden über die Serielle ausgabe protokolliert. */
   
   WiFi.mode(WIFI_STA);
   WiFi.disconnect();
   delay(100);
   Serial.print("Connecting Wifi: ");
   Serial.println(ssid);
   WiFi.begin(ssid, password);
   while (WiFi.status() != WL_CONNECTED) {
        Serial.print(".");
        delay(500);
        }
        Serial.println("");
        Serial.println("WiFi connected");
        Serial.println("IP address: ");
        IPAddress ip = WiFi.localIP();
        Serial.println(ip);
        client.setInsecure();
       
/*  Open Server Connection
    Jetzt wird sich mit der, in der Variable HOST gespeicherten, Internetseite verbunden. */
  if (!client.connect(HOST, 443)){
         Serial.println(F("Connection failed"));
          return;
        }
        yield();
        }

/*  Subroutins for reading needet Data
    Auf hamsql.com werden die Daten auch via PHP zur Verfügung gestellt */
      
void readweb(){
  client.print(F("GET "));                          // sende eine Anfrage an den HTTP Client 
  client.print("/solarxml.php");                    // Navigiere zur benötigten Seite (wir sind jetzt bei www.hamsql.com/solarxml.php)
  client.println(F(" HTTP/1.1"));
  client.print(F("Host: "));
  client.println(HOST);
  client.println(F("Cache-Control: no-cache"));     //OBACHT, nicht alte Daten aus dem Cache lesen
  if (client.println() == 0)
  {
    Serial.println(F("Fehler bei der Abfrage"));
    return;
  }
  delay(100);

    char endOfHeaders[] = "\r\n\r\n";                //Den HTTP Header überspringen
  if (!client.find(endOfHeaders))
  {
    Serial.println(F("unerwartete Antwort vom Server"));
    return;
  }
}

/*  Unterroutinen zur Abfrage der verschiedenen Werte
    Nachdem die Seite Solarxml nun gelesen wurde müssen die von uns benötigten Werte ermittelt werden.
    Wenn man sich die Seite im Explorer ansieht, so ist jeder Wert gut markiert
    Die Werte werden also in jeder Unterroutine ermittelt um für die Rückgabe in der Variable DATARet gespeichert.
    Wird später z.b. die die Routine 'SFIRequest' gerufen, so sucht diese zunächst nach dem Eintrag <solarflux> 
    und liest den Wert dahinter bis zum ersten Leerzeichen ('\<') als TEXT.
    Mit der Funktion atoi wird der TEXT (char) in eine ZAHL (int) umgewandelt, und als Returnwert gespeichert.
    Das Ergebins des Aufrufs ist also der so ermittelte Wert als Ganzzahl.
    Bei XRay ist es etwas komplizierter, hier ist das erste Zeichen (substring 0,1) immer ein Buchstabe
    Jedem möglichen Buchstaben wird im folgenden ein Zahlenwert zugeordnet. A;B;C;M;X bekommen die Werte 10;20;30;40
    der darauffolgende Zahlenwert (substring 1,5) wird dann addiert und das Ergebnis gerundet.
    Die Routine Reboot, setzt den ERRORPin 3sec auf High, die ggf dort angeschlossene LED leuchtet, danach erfolgt ein Neustart. */

int SFIRequest() {
  char DATA[32] = {0};   //DATA 
  if (!client.find("<solarflux>")){
              Serial.println(F("No DATA SFI"));
              Reboot();
            } else {
              client.readBytesUntil('\<', DATA, sizeof(DATA));
              int DATARet = atoi(DATA);
              return DATARet;
            }
}

int XRayRequest() {
  char DATA[32] = {0};   //DATA            
  int DATARet = 0;
  if (!client.find("<xray>")){
              Serial.println(F("No DATA XRay"));
              Reboot();
            } else {
              client.readBytesUntil('\<', DATA, sizeof(DATA));
              String xraydata =String(DATA);
              String xrayletter = xraydata.substring (0,1);
              String xrayvalue = xraydata.substring (1,3);
               if (xrayletter == "A") {
                  DATARet = 0;}
                  else
                  if (xrayletter == "B") {
                    DATARet = 10;}
                    else
                    if (xrayletter == "C") {
                      DATARet = 20;}
                      else
                      if (xrayletter == "M") {
                        DATARet = 30;}
                        else
                        if (xrayletter == "X") {
                          DATARet = 40;}
                          else
                          {DATARet = 0;
                        }
         
                float xrayfloat = xrayvalue.toFloat();
                DATARet = DATARet + xrayfloat;
                round(DATARet);
                return DATARet;
            }           
}

int SNRequest() {
  char DATA[32] = {0};   //DATA   
  if (!client.find("<sunspots>")){
              Serial.println(F("No DATA SN"));
              Reboot();
            } else {
              client.readBytesUntil('\<', DATA, sizeof(DATA));
              int DATARet = atoi(DATA);
              return DATARet;
            }
}  

int MUFRequest() {
  char DATA[32] = {0};   //DATA 
  if (!client.find("<muf>")){
              Serial.println(F("No DATA MUF"));
              Reboot(); 
            } else {
              client.readBytesUntil('\<', DATA, sizeof(DATA));
              int DATARet = atoi(DATA);
              return DATARet;
            }
}

int Reboot() {
             
              Serial.println("Reboot in 3 sec.");
              analogWrite(ERRORPin, 1024);
              delay(3000);
              ESP.restart();
               
}

/* Das 'eigentliche' Programm
   Alle 2 Minuten wird mit dem Aufruf der Unterroutine 'readweb' die Internetseite neu gelesen.
   Im Anschluss werden die Veriablen SFIVal; SNval; XRayval; MUFval mit den Returnwerten der oben definierten Unterprogramme versorgt.
   Die so gelesenen Werte werden zunächst an über die serielle Konsole ausgegeben.
   Im Anschluss an die Möglichen 1024 Schritte der PWM Funktion skalliert und über die definierten Pins ausgegeben.
   Der höchste Wert 1023 entspricht dabei 3.3v, sollen hier 3v Anzeigen verwendet werden so kann das programmseitig entsprechend Berücksichtigt werden.
   Ermittlung über einfachen 3Satz.
   0-1023 = 0-3.3v
   1023/3.3 = 310
   310*3V = 930 Schritte bis bei einem 3V Instrument Vollausschlag erreicht wird, Anstelle von 1023 ist dann 930 einzusetzen.
 
   Eine Besonderheit ist die Anzeig für den Solaren Flux. Da dieser laut Wikipedia *g* nie unter 62 sinkt, beginnt die Anzeige erst bei 62.
   Es stehen also nur 300-62 = 238 Teilschritte zur Verfügung, wobei ein SFI Wert von 62 dem Wert 0 = (kein Zeigerausschlag) entspricht.  */


void loop() {
  unsigned long now = millis();
  if(requestDue < now)         
  {
              //Werte lesen
              readweb();                             
              int SFIval  = SFIRequest();
              int XRayval = XRayRequest();
              int SNval   = SNRequest();  
              int MUFval  = MUFRequest();
             
              //Werte über die Serielle Konsole ausgeben
              Serial.print("SFI:");
              Serial.println(SFIval);
              Serial.print("XRAY:");
              Serial.println(XRayval);
              Serial.print("SN:");
              Serial.println(SNval);
              Serial.print("MUF:");
              Serial.println(MUFval);
              Serial.println("------------");

              //werte für den Endausschlag dedr Anzeige skallieren       
              int SFI  = (1023/238) * (SFIval-62);  
              int SN   = (1023/300) * SNval; 
              int XRay = (1023/50) * XRayval; 
              int MUF  = (1023/50) * MUFval;  
             
              
              //zu guter Letzt, Ausgabe der Werte 
              analogWrite(SFIPin, SFI);
              analogWrite(SNPin, SN);
              analogWrite(XRAYPin, XRay);
              analogWrite(MUFPin, MUF);
          
    requestDue = now + 120000;          //wiederhole alle 2 Min (60000ms = 1Min)
  }
}

// Viel Spass beim gemeinsamen Hobby de DO1ATM
