/*
 * IOT Compass FUNKAMATEUR 09/2021
 * Autor Michael, DL6MHW dl6mhw@darc.de
 * Nutzung Beispiel von Fabian Kainka, Franzis Verlag
*/
#include <Wire.h>
#include <Arduino.h>

//Anpassung von SSID und Password
#define SSID "6mhw"
#define PASSWORD "123zitrone"

#define LED 9
#define LED_WLAN 13

#define DEBUG true
#include <avr/pgmspace.h>

//die Konstanten enthält den HTML-Text
const char s1[] PROGMEM = {
"<html>\n<body>\n<canvas id=\"mC\"width=\"400\"height=\"400\"></canvas>\n<script>\nvar xh = new XMLHttpRequest();\nvar g=90;\nfunction getG() {\nxh.open('GET','grad.php');\nxh.onload = function(){if (xh.status === 200){g=xh.responseText;d(g);}};\nxh.send();}function d(g) {\nvar c=document.getElementById('mC').getContext('2d');\nvar s=150;\nc.clearRect(0,0,400,400);\nc.fillStyle='#dfac20';\nc.strokeStyle = '#3983ab';\n\0"};
const char s2[] PROGMEM = {"for (var i=0;i<=360;i=i+30){\nc.beginPath();\np=Math.PI/180;\nx=s*Math.sin(i*p);\ny=s*Math.cos(i*p);\nc.arc(200+x,200-y,10,0,7,false);\nc.fill();\nc.lineWidth=2;\nc.stroke();\n}\nc.font=\"20px Arial\";\nc.fillStyle='#222222';\nc.fillText(\"Grad:\"+g,5,20);\nx=s*Math.sin(g*p);\ny=s*Math.cos(g*p);\nc.fillStyle='#dfac20';\nc.lineWidth=3;\nc.beginPath();\nc.moveTo(200-x/5,200+y/5);\nc.lineTo(200-y/5,200-x/5);\nc.lineTo(200+x,200-y);\nc.lineTo(200+y/5,200+x/5);\nc.closePath();\nc.lineJoin='round';\nc.fill();\nc.stroke();\n}\ng=33;\nfunction timeOut() {getG(g);setTimeout(timeOut,500);}\nsetTimeout(timeOut,1000);\n</script>\n</body>\n</html>\n\0"};

#include <avr/pgmspace.h>
//Achtung: aupfassen ob man HMC5883L oder QMC5883L hat 
const int hmc5883Adresse = 0x1E; //0011110b, I2C 7-Bit Addresse des HMC5883L
//const int hmc5883Adresse = 0x0D; //0011110b, I2C 7-Bit Addresse des QMC5883L
const byte hmc5883ModeRegister      = 0x02;
const byte hmcContinuousMode        = 0x00;
const byte hmcDataOutputXMSBAdresse = 0x03;

int tick=0;

#include <SoftwareSerial.h>
SoftwareSerial esp8266(11, 12); // RX, TX

void setup() {
  Serial.begin(19200);
  esp8266.begin(19200);
  pinMode(LED, OUTPUT);

  Serial.println("Start compass1(V 13-Aug-2021)");

  Wire.begin();
  Wire.beginTransmission(hmc5883Adresse); // Verbindung öffnen mit dem HMC5883
  Wire.write(hmc5883ModeRegister); // Mode Register
  Wire.write(hmcContinuousMode);   // Kontinuierliche Messung
  Wire.endTransmission();

  if (!espConfig()) serialDebug();
  else digitalWrite(LED_WLAN, HIGH);

  if (configTCPServer())  debug("Server Aktiv"); else debug("Server Error");
}


void loop() {
  String xBuffer;
  if (esp8266.available()) // check if the esp is sending a message
  {
    if (esp8266.find("+IPD,"))
    {
      debug("Incomming Request"+String(tick));
      int connectionId = esp8266.parseInt();
      tick++;
      if (esp8266.findUntil("grad", "\n")) {
        debug("Incomming Request - Abfrage Compass");
        //Serial.println("GET..");
        //digitalWrite(LED, esp8266.parseInt());
        digitalWrite(LED_WLAN, !digitalRead(LED_WLAN));
        int g=compass();
        debug("Compass"+String(g));
        if (sendWebsite(connectionId, String(g))) debug("Website send Grad OK"); 
        else debug("Website send Grad Error");      
      } else {
        if (sendWebsiteLong(connectionId))debug("Website send Basic OK");
          else debug("Website send Basic Error");
      }
    }
  }
}

//Auslesen der Compass-Werte, Debug-Ausgabe über serielle Schnittstelle, Berechnung der Richtung
int compass(){
  int x,y,z; // 3 Achsen
  Wire.beginTransmission(hmc5883Adresse);
  Wire.write(hmcDataOutputXMSBAdresse); // Register 3, X MSB Register
  Wire.endTransmission();
  Wire.requestFrom(hmc5883Adresse, 6);
  if(6<=Wire.available()){
    x = Wire.read()<<8; //X msb
    x |= Wire.read(); //X lsb
    z = Wire.read()<<8; //Z msb
    z |= Wire.read(); //Z lsb
    y = Wire.read()<<8; //Y msb
    y |= Wire.read(); //Y lsb
  }

  Serial.print("x: "); // Ausgabe der 3 Achsen
  Serial.print(x);
  Serial.print("  y: ");
  Serial.print(y);
  Serial.print("  z: ");
  Serial.print(z);

  float w = atan2(-y , x) / M_PI * 180.0; // Winkel berechnen
  if(w < 0)
     w = w + 360.0; // 0 bis 359 Grad, statt +-180 Grad
  Serial.print(" Richtung A = ");
  Serial.println(w,1);
  debug("Ende Compass");
  return w;
}

//Ausliefung eines Strings ueber HTTP
boolean sendWebsite(int connectionId, String webpage)
{
  boolean success = true;
  if (sendCom("AT+CIPSEND=" + String(connectionId) +"," +String(webpage.length()), ">"))
  {
    esp8266.print(webpage);
    esp8266.find("SEND OK");
    success &= sendCom("AT+CIPCLOSE=" + String(connectionId), "OK");
  }
  else
  {
    success = false;
  }
  return success;
}

//Ausliefung der Basis-HTML-Seite
boolean sendWebsiteLong(int connectionId)
{
  String xBuffer;
  for (int i = 0; i <= sizeof(s1)-3; i++) { char myChar = pgm_read_byte_near(s1 + i);xBuffer += myChar; }
  boolean success = true;
  if (sendCom("AT+CIPSEND=" + String(connectionId) +"," + String(xBuffer.length()), ">"))
  {
    esp8266.print(xBuffer);
    esp8266.find("SEND OK");
  }
  xBuffer.remove(0,xBuffer.length());
  for (int i = 0; i <= sizeof(s2)-3; i++) { char myChar = pgm_read_byte_near(s2 + i);xBuffer += myChar; }
  if (sendCom("AT+CIPSEND=" + String(connectionId) +"," + String(xBuffer.length()), ">"))
  {
    esp8266.print(xBuffer);
    esp8266.find("SEND OK");
    success &= sendCom("AT+CIPCLOSE=" + String(connectionId), "OK");
  }
  else
  {
    success = false;
  }
  return success;
}


//-----------------------------------------Config ESP8266------------------------------------

boolean espConfig()
{
  boolean success = true;
  esp8266.setTimeout(5000);
  success &= sendCom("AT+RST", "ready");
  esp8266.setTimeout(1000);
  if (configStation(SSID, PASSWORD)) {
    success &= true;
    debug("WLAN Connected");
    debug("My IP is:");
    debug(sendCom("AT+CIFSR"));
  }
  else
  {
    success &= false;
  }
  //shorter Timeout for faster wrong UPD-Comands handling
  success &= sendCom("AT+CIPMODE=0", "OK");  //So rum scheit wichtig!
  success &= sendCom("AT+CIPMUX=0", "OK");

  return success;
}

boolean configTCPServer()
{
  boolean success = true;

  success &= (sendCom("AT+CIPMUX=1", "OK"));
  success &= (sendCom("AT+CIPSERVER=1,80", "OK"));

  return success;

}

boolean configTCPClient()
{
  boolean success = true;

  success &= (sendCom("AT+CIPMUX=0", "OK"));
  //success &= (sendCom("AT+CIPSERVER=1,80", "OK"));

  return success;

}


boolean configStation(String vSSID, String vPASSWORT)
{
  boolean success = true;
  success &= (sendCom("AT+CWMODE=1", "OK"));
  esp8266.setTimeout(20000);
  success &= (sendCom("AT+CWJAP=\"" + String(vSSID) + "\",\"" +String(vPASSWORT) + "\"", "OK"));
  esp8266.setTimeout(1000);
  return success;
}

boolean configAP()
{
  boolean success = true;

  success &= (sendCom("AT+CWMODE=2", "OK"));
  success &= (sendCom("AT+CWSAP=\"NanoESP\",\"\",5,0", "OK"));

  return success;
}

boolean configUDP()
{
  boolean success = true;

  success &= (sendCom("AT+CIPMODE=0", "OK"));
  success &= (sendCom("AT+CIPMUX=0", "OK"));
  success &= sendCom("AT+CIPSTART=\"UDP\",\"192.168.255.255\",90,91,2",
"OK"); //Importand Boradcast...Reconnect IP
  return success;
}

//-----------------------------------------------Controll ESP-----------------------------------------------------

boolean sendUDP(String Msg)
{
  boolean success = true;

  success &= sendCom("AT+CIPSEND=" + String(Msg.length() + 2), ">");   
//+",\"192.168.4.2\",90", ">");
  if (success)
  {
    success &= sendCom(Msg, "OK");
  }
  return success;
}


boolean sendCom(String command, char respond[])
{
  esp8266.println(command);
  if (esp8266.findUntil(respond, "ERROR"))
  {
    return true;
  }
  else
  {
    debug("ESP SEND ERROR: " + command);
    return false;
  }
}

String sendCom(String command)
{
  esp8266.println(command);
  return esp8266.readString();
}



//-------------------------------------------------Debug Functions------------------------------------------------------
void serialDebug() {
  while (true)
  {
    if (esp8266.available())
      Serial.write(esp8266.read());
    if (Serial.available())
      esp8266.write(Serial.read());
  }
}

void debug(String Msg)
{
  if (DEBUG)
  {
    Serial.println(Msg);
  }
}
