/*
 * Batterieprüfgerät
 * Frank G. Sommer, DC8FG
 * Februar 2021
 * Version: 1.1a
 * Mit PowerMosFET zum Schalten eines Belastungswiderstandes
 * 
 */

int Voltage_raw; // evtl. als float deklarieren
float Voltage_R2;
float Uref = 5.0;
float Voltage_in;
int  UBatt_Pin = 0; //PC0
float Ri_Good = 0.2; //Innenwiderstand Grenze GUT
float Ri_Mid = 0.6; // Innenwiderstand Grenze MITTEL
int powermosfet = 4; //Zum Schalten des Belastungswiderstandes
int led_good = 5; 
int led_mid = 6;
int led_fail = 7;
int sound = 8;
int freq = 2000;
float Udiff_Batt;
float Umess_Batt;
float ULeer;
float ULast;
float Ri_Batt;
float Iges_Batt;
float R_mess = 1.2; // Wert des Lastwiderstands

void setup() {
 Serial.begin(9600);
 pinMode(powermosfet,OUTPUT);
 pinMode(led_good,OUTPUT);
 pinMode(led_mid,OUTPUT);
 pinMode(led_fail,OUTPUT);
 pinMode(sound,OUTPUT);
}

void loop() {

digitalWrite(led_good, LOW);
digitalWrite(led_mid, LOW);
digitalWrite(led_fail, LOW);

read_voltage_level(); 
if(Umess_Batt >= 1) { //Nur messen, wenn die Leerlaufspannung > 1 V ist

  read_voltage_level(); //Leerlaufspannung messen
  delay(200);
  ULeer = Umess_Batt;
  delay(1000);
  digitalWrite(powermosfet, HIGH);
  delay(500);
  read_voltage_level(); //Leerlausspannung messen
  //delay(1000);
  ULast = Umess_Batt;
  //delay(1000);
  digitalWrite(powermosfet, LOW);
  delay(100);

  calc_Ri(); // Innenwiderstand berechnen
  
  if(Umess_Batt >= 0.2) {

  //calc_Ri();
  //if(Ri_Batt <= Ri_Good) {
    //digitalWrite(led_good, HIGH);
    
  //}
  
  //if(Ri_Batt >= Ri_Good && Ri_Batt <= Ri_Mid) {
    //digitalWrite(led_mid, HIGH);
    //;
 // }
      
  //if(Ri_Batt >= Ri_Mid) {
    //digitalWrite(led_fail, HIGH);
    
  //}

  Serial.println("");
  Serial.println("*** Batterieprüfung ***");
  Serial.println("");
  Serial.print("Spannung Leerlauf : ");
  Serial.print(ULeer,2);
  Serial.println(" Volt");
  
  Serial.print("Spannung unter Last : ");
  Serial.print(ULast,2);
  Serial.println(" Volt");

  Serial.print("Spannungsdifferenz  : ");
  Serial.print(Udiff_Batt,2);
  Serial.println(" Volt");
  
  Serial.print("Laststrom : ");
  Serial.print(Iges_Batt,3);
  Serial.println(" A");
  Serial.print("Innenwiderstand der Batterie: ");
  Serial.print(Ri_Batt,3 );
  Serial.println(" Ohm");
  

  if(Ri_Batt <= Ri_Good) {
    Serial.println("Batteriestatus: Gut");
    digitalWrite(led_good, HIGH);
    soundgood();
    soundstop();
    messende();
    }
    
  
  if(Ri_Batt >= Ri_Good && Ri_Batt <= Ri_Mid) {
    Serial.println("Batteriestatus: ca. 50%");
    digitalWrite(led_mid, HIGH);
    messende();
    }

      
  if(Ri_Batt >= Ri_Mid) {
    Serial.println("Batteriestatus: Schlecht");
    digitalWrite(led_fail, HIGH);
    if(Voltage_raw > 0) {
    soundbad();
    }
    soundstop();
    messende();
     }
  }  

  } //Ende der Schleife Prüfung ob zu messende Batteriespannung <= 1,0 V ist
delay(2000);

}

void read_voltage_level() {
  Voltage_raw = analogRead(UBatt_Pin);
  Voltage_R2 = ((Voltage_raw * Uref)/1024); 
  Voltage_in = Voltage_R2*6; //Teilverhaeltnis des Spannungsteiler: 10k + 49,9k = 59,9k / R2 (10k) = 6
  Umess_Batt = Voltage_in;


}

//Berechnung des Innenwiderstandes
void calc_Ri() {
  Udiff_Batt = ULeer - ULast;
  Iges_Batt = ULast / R_mess;
  Ri_Batt = Udiff_Batt / Iges_Batt;
}

//Tonausgabe Batterie schlecht

void soundbad() {
  for(freq=6000; freq >=1; freq--) 
  tone(sound, freq);
}


//Tonausgabe Batterie gut

void soundgood() {
    tone(sound, freq=2440);
    delay(300);
    noTone(sound);
    delay(100);
    tone(sound, freq=2440);
    delay(300);
    noTone(sound);
    delay(100);
    tone(sound, freq=2440);
    delay(300);
    noTone(sound);

    delay(300);
    
    tone(sound, freq=2440);
    delay(300);
    noTone(sound);
    delay(100);
    tone(sound, freq=2440);
    delay(100);
    noTone(sound);
    delay(100);
    tone(sound, freq=2440);
    delay(300);
    noTone(sound);

}

//Tonausgabe beenden

void soundstop() {
  noTone(sound);
}

void messende() {
  Serial.println("");
  Serial.println("**** Ende der Batterieprüfung ****");
  Serial.println("");
}
