/* DF7TS Sequencer Ver4 5 Ports: 1 LNA and 4 Transmit, 2 Alarmports: Temp and Input-Power
 * 02/2021
 * tnx Volker(DJ8JA)for first sketch sequencer https://www.youtube.com/watch?v=NYdzuLO4BNA
 * tnx Wolfgang for info ADS1115 
 * Example sketch for the ADS1115_WE library 
 * Further information can be found on:
 * https://wolles-elektronikkiste.de/ads1115 (German)
 * https://wolles-elektronikkiste.de/en/ads1115-a-d-converter-with-amplifier (English)
 * 
 * Further information about the sequencer can be found on:
 * https://www.qrz.com/  Call: DF7TS
 
 * The circuit:
 * pushbutton (PTT key) attached from pin 8 to GND
 * pushbutton (PTT from PC) attached from pin 9 to GND  
 * Output:  Pin 3,4,5,6 PTT, 
 *          Pin 7 LNA
 * Board Output via ULN2803
 * Alarm 1 Temp pin 11 to GND
 * Alarm 2 Power pin 12 to GND
 * Alarm-LED pin 10 
 
***************************************************************************/

#include<ADS1115_WE.h> 
#include<Wire.h>
#define I2C_ADDRESS 0x48
volatile int interruptPin = 2;
int ledPinAlert = 10;
volatile bool outOfLimit = false;

ADS1115_WE adc(I2C_ADDRESS);
// ADS1115_WE adc = ADS1115_WE(); // Alternative: uses default address 0x48


//sequencer
// constants won't change. They're used here to
// set pin numbers:
const int buttonPin = 8;    // pushbutton pin PTT
const int pcbuttonPin = 9;  // second pushbutton  PTT PC
const int ledPin = 13;     // the number of the LED pin
const int lna=7;           // Low Noise Preamplifier
const int pa=3;            // Relay PA
const int bias=4;           // Bias PA
const int trv=5;           // Transverter Transmit
const int trx=6;         //  Transceiver Transmit

const int alarminputTemp=11;  // Alarm Input Temperatur Pin Digital 11
const int alarminputPower=12;  // Alarm Input Power Pin Digital 12

// Variables will change:
int ledState = LOW;         // the current state of the output pin
int buttonState;             // the current reading from the input pin
int lastButtonState = LOW;   // the previous reading from the input pin
                              // start with receiving
int debouncedLastButtonState=LOW;
int relaisDelay=50;  //50 ms

int alarmled=10; // Alarm LED Pin Digital 10
int alarminputstate = 0;

// the following variables are long's because the time, measured in miliseconds,
// will quickly become a bigger number than can be stored in an int.
unsigned long lastDebounceTime = 0;  // the last time the output pin was toggled
unsigned long debounceDelay = 60;    // the debounce time; increase if the output flickers


void setup() {
  Wire.begin();
  Serial.begin(9600);
  
  pinMode(interruptPin, INPUT_PULLUP);
  pinMode(ledPinAlert, OUTPUT);
  digitalWrite(ledPinAlert, LOW);
  
  if(!adc.init()){
    Serial.println("ADS1115 not connected!");
  }

  /* Set the voltage range of the ADC to adjust the gain
   * Please note that you must not apply more than VDD + 0.3V to the input pins!
   * 
   * ADS1115_RANGE_6144  ->  +/- 6144 mV
   * ADS1115_RANGE_4096  ->  +/- 4096 mV
   * ADS1115_RANGE_2048  ->  +/- 2048 mV (default)
   * ADS1115_RANGE_1024  ->  +/- 1024 mV
   * ADS1115_RANGE_0512  ->  +/- 512 mV
   * ADS1115_RANGE_0256  ->  +/- 256 mV
   */
  adc.setVoltageRange_mV(ADS1115_RANGE_4096); //comment line/change parameter to change range

  /* Set the inputs to be compared
   *  
   *  ADS1115_COMP_0_1    ->  compares 0 with 1 (default)
   *  ADS1115_COMP_0_3    ->  compares 0 with 3
   *  ADS1115_COMP_1_3    ->  compares 1 with 3
   *  ADS1115_COMP_2_3    ->  compares 2 with 3
   *  ADS1115_COMP_0_GND  ->  compares 0 with GND
   *  ADS1115_COMP_1_GND  ->  compares 1 with GND
   *  ADS1115_COMP_2_GND  ->  compares 2 with GND
   *  ADS1115_COMP_3_GND  ->  compares 3 with GND
   */
  adc.setCompareChannels(ADS1115_COMP_0_GND); //uncomment if you want to change the default

  /* Set number of conversions out of limit after which the alert pin will assert
   * - or you can disable the alert (including conversion ready alert)
   *  
   *  ADS1115_ASSERT_AFTER_1  -> after 1 conversion
   *  ADS1115_ASSERT_AFTER_2  -> after 2 conversions
   *  ADS1115_ASSERT_AFTER_4  -> after 4 conversions
   *  ADS1115_DISABLE_ALERT   -> disable comparator / alert pin (default) 
   */
  adc.setAlertPinMode(ADS1115_ASSERT_AFTER_1); // you can also choose ...AFTER_2 or 4 for this sketch

  /* Set the conversion rate in SPS (samples per second)
   * Options should be self-explaining: 
   * 
   *  ADS1115_8_SPS 
   *  ADS1115_16_SPS  
   *  ADS1115_32_SPS 
   *  ADS1115_64_SPS  
   *  ADS1115_128_SPS (default)
   *  ADS1115_250_SPS 
   *  ADS1115_475_SPS 
   *  ADS1115_860_SPS 
   */
  //adc.setConvRate(ADS1115_8_SPS); //uncomment if you want to change the default

  /* Set continuous or single shot mode:
   * 
   *  ADS1115_CONTINUOUS  ->  continuous mode
   *  ADS1115_SINGLE     ->  single shot mode (default)
   */
  adc.setMeasureMode(ADS1115_CONTINUOUS); //comment or change if you want to change single shot

   /* Choose maximum limit or maximum and minimum alert limit (window) in volts - alert pin will 
   *  assert when measured values are beyond the maximum limit or outside the window 
   *  Upper limit first: setAlertLimit_V(MODE, maximum, minimum)
   *  In max limit mode the minimum value is the limit where the alert pin assertion will be cleared 
   *  again (if not latched!)  
   * 
   *  ADS1115_MAX_LIMIT
   *  ADS1115_WINDOW
   * 
   */
  adc.setAlertModeAndLimit_V(ADS1115_MAX_LIMIT, 2.285, 2.200); //uncomment if you want to change the default
  
  /* Enable or disable latch. If latch is enabled the alert pin will be active until the
   * conversion register is read (getResult functions). If disabled the alert pin assertion
   * will be cleared with next value within limits. 
   *  
   *  ADS1115_LATCH_DISABLED (default)
   *  ADS1115_LATCH_ENABLED
   */
  adc.setAlertLatch(ADS1115_LATCH_ENABLED); //uncomment if you want to change the default

  /* Sets the alert pin polarity if active:
   *  
   * ADS1115_ACT_LOW  ->  active low (default)   
   * ADS1115_ACT_HIGH ->  active high
   */
  //adc.setAlertPol(ADS1115_ACT_LOW); //uncomment if you want to change the default
 
  /* With this function the alert pin will assert, when a conversion is ready.
   * In order to deactivate, use the setAlertLimit_V function  
   */
  //adc.setAlertPinToConversionReady(); //uncomment if you want to change the default

  Serial.println("ADS1115 Example Sketch - uses the Alert Pin / Window Mode / Latch enabled");
  Serial.println();
  Serial.println("Waiting for Value out of Limit");
  attachInterrupt(digitalPinToInterrupt(interruptPin), outOfLimitAlert, FALLING);




//sequencer
pinMode(buttonPin, INPUT_PULLUP);  // PTT
  pinMode(pcbuttonPin, INPUT_PULLUP); // PTT 
  pinMode(lna, OUTPUT);
  pinMode(pa, OUTPUT);
  pinMode(bias, OUTPUT);
  pinMode(trv, OUTPUT);
  pinMode(trx, OUTPUT);
  pinMode(ledPin, OUTPUT);
  pinMode(alarminputTemp, INPUT_PULLUP);
  pinMode(alarminputPower, INPUT_PULLUP);
  pinMode(alarmled, OUTPUT);
  
  // set initial LED state


         digitalWrite(trx,LOW);
         digitalWrite(trv,LOW);
         digitalWrite(bias,LOW);
         digitalWrite(pa,LOW);          delay(relaisDelay);
         digitalWrite(lna,HIGH);    //  LNA-Antenna relay
         digitalWrite(alarmled, LOW);

  
}

void loop() {
  float voltage = 0.0;
  if(outOfLimit){
    voltage = adc.getResult_V();
    Serial.print("Voltage [V]: ");
    Serial.println(voltage);  
    digitalWrite(ledPinAlert,HIGH);
    delay(1000);
    digitalWrite(ledPinAlert,LOW);
    outOfLimit = false;
    attachInterrupt(digitalPinToInterrupt(interruptPin), outOfLimitAlert, FALLING); 
    adc.clearAlert(); // unlatches the alert Pin (alternatively use getResult_V)
  } 

//sequencer
{

  // Einheitlichen Status beider Buttons in einem Status festhalten, diesen schonmal mit dem Wert des Button initialisieren
  int reading = !digitalRead(buttonPin);

  // read the state of the switches into two local variables:
  int readingButton = !digitalRead(buttonPin); //invert,  key switches to GND
  int readingPcButton = !digitalRead(pcbuttonPin); //invert,  key switches to GND

  if ((readingButton == LOW) || (readingPcButton == LOW)) {
    reading = LOW;
  }  if ((readingButton == HIGH) || (readingPcButton == HIGH)) {
    reading = HIGH;
  }

  // check to see if you just pressed the button
  // (i.e. the input went from LOW to HIGH),  and you've waited
  // long enough since the last press to ignore any noise:

  // If the switch changed, due to noise or pressing:
  if (reading != lastButtonState) {
    // reset the debouncing timer
    lastDebounceTime = millis();
  }

  if ((millis() - lastDebounceTime) > debounceDelay) {
    // whatever the reading is at, it's been there for longer
    // than the debounce delay, so take it as the actual current state:

    // if the button state has changed:
    if (reading != buttonState) {
      debouncedLastButtonState=buttonState;
      buttonState = reading;

      ledState=buttonState;
    }
  }

  // set the LED:
  digitalWrite(ledPin, ledState); //shows state of  PTT
  // save the reading.  Next time through the loop,
  // it'll be the lastButtonState:

  if ((debouncedLastButtonState==LOW)&&(buttonState==HIGH))
  {
          digitalWrite(lna,LOW);      // start transmit
          delay(relaisDelay);
 
          digitalWrite(pa,HIGH);   // pa relay works,  contact to Ground
          delay(relaisDelay);

          digitalWrite(bias,HIGH);    // pa bias works, contact to Ground
          delay(relaisDelay);

          digitalWrite(trv,HIGH);     // transverter works,  contact to Ground
          delay(relaisDelay);       // 
 
          digitalWrite(trx,HIGH);   //  
         
          debouncedLastButtonState=HIGH;
   }
   if ((debouncedLastButtonState==HIGH)&&(buttonState==LOW))  // start receive
   {
           digitalWrite(trx,LOW);   // transceiver stops sending
           delay(relaisDelay);       // 
         
          digitalWrite(trv,LOW);            // transverter stops sending
          delay(relaisDelay);               
          digitalWrite(bias,LOW);            // PA bias stops
          delay(relaisDelay);               

          digitalWrite(pa,LOW);            // pa relay stops,
          delay(relaisDelay);              
          digitalWrite(lna,HIGH);           // lna activ

          debouncedLastButtonState=LOW;      //
    }

    
//Alarm
alarminputstate = digitalRead (alarminputTemp);

 if (alarminputstate == LOW)  {

           digitalWrite(trx,LOW);   // transceiver stops sending
           delay(relaisDelay);       // 
           digitalWrite(trv,LOW);            // transverter stops sending
           digitalWrite(bias,LOW);            // PA bias stops
           digitalWrite(pa,LOW);            // pa relay stops,
           digitalWrite(lna,LOW);      
           digitalWrite(alarmled, HIGH);

           while(1) { }  //endless loop stop
           
 }

alarminputstate = digitalRead (alarminputPower);

 if (alarminputstate == LOW)  {

           digitalWrite(trx,LOW);   // transceiver stops sending
           delay(relaisDelay);       // 
           digitalWrite(trv,LOW);            // transverter stops sending
           digitalWrite(bias,LOW);            // PA bias stops
           digitalWrite(pa,LOW);            // pa relay stops,
           digitalWrite(lna,LOW);      
           digitalWrite(alarmled, HIGH);

           while(1) { }  //endless loop stop
           
 }
lastButtonState = reading;
    
 }
  
}

void outOfLimitAlert(){
  detachInterrupt(interruptPin);
  outOfLimit = true;
}

