/*
      +++++++++ Akkutester mit: TFT 1,8", 128*160 pixel, INA291 Sensor

         Spannungsanzeige
         Stromanzeige
         Amperstundenanzeige
         Entladeschlussp.-Anzeige
         Bargraph für Strom 0-3A
         Entladeschlussspannung über Drehgeber einstellbar
         Relaisausgang für Abschaltung der Last bei Entladeschluss an D6
         Display- Helligkeit in Software einstellbar

      +++++++++ Made by DL9NAC für DC5WW ++++++++

      !!!!! Stand: 27.06.2022 !!!!!
*/

#include <Adafruit_GFX.h>  // Bibliotheken einbinden
#include <Adafruit_ST7735.h>
#include <Fonts/FreeSans18pt7b.h>
#include <SPI.h>
#include <Rotary.h>     // https://github.com/brianlow/Rotary
#include <INA219_WE.h>  // https://github.com/wollewald/INA219_WE, https://wolles-elektronikkiste.de/ina219, Copyright (c) 2020 Wolfgang (Wolle) Ewald
#include <EEPROM.h>

#define TFT_CS 10  // Display, Anschlüsse zuweisen
#define TFT_RST 8
#define TFT_DC 9
#define I2C_ADDRESS 0x40  // INA219 Adresse
INA219_WE ina219 = INA219_WE(I2C_ADDRESS);

Adafruit_ST7735 tft = Adafruit_ST7735(TFT_CS, TFT_DC, TFT_RST);  //Display definieren
Rotary r = Rotary(2, 3);                                         // Drehgeber Anschlüsse, Interupt geht nur an D2 und D3!

float EndU = 50.0;  // globale Variablen definieren
float busVoltage = 0.0;
float current = 0.0;
float Ah = 0.0;
uint8_t I_bargraph = 0;
uint8_t I_bargraph_alt = 0;
int8_t I_bargraph_diff = 0;
uint32_t previousMillis = 0;
uint32_t currentMillis = 0;
bool Messen = false;
bool STOP = false;
bool Merker = false;
uint8_t wz = 0;
char Printout[10];

GFXcanvas1 canvas(67, 29);  //  pixel canvas definieren (67x29 Pixel- Rechteck zum Anzeigen sich ändernder Werte)



// ++++++++++++++++ Encoder Interrupt Abfrage ++++++++++++++++++++++++++++

ISR(PCINT2_vect) {
  unsigned char result = r.process();

  if (result == DIR_NONE) {
    STOP = true;  // Nur Entladeschlussspannung aufs Display schreiben, alles andere aus
  }

  else if ((result == DIR_CW) && (Messen == false)) {

    EndU++;
    if (EndU > 2500) {
      EndU = 2500;
    }
  }

  else if ((result == DIR_CCW) && (Messen == false)) {
    EndU--;
    if (EndU <= 0) {
      EndU = 0;
    }
  }
}
// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++




void setup(void) {  //--------------------  Dieser Teil "setup" wird nur beim Start, also einmal, durchlaufen ----------------------

  pinMode(12, INPUT_PULLUP);  // Drehgeber Drucktaster
  pinMode(6, OUTPUT);         // Relais Last
  pinMode(5, OUTPUT);         // Display Beleuchtung
  analogWrite(5, 200);       // Display Beleuchtung, Helligkeit 0-255


  r.begin();  // Interrupt für Drehgeber erzeugen
  PCICR |= (1 << PCIE2);
  PCMSK2 |= (1 << PCINT18) | (1 << PCINT19);
  sei();


  ina219.setPGain(PG_320);  // Einstellungen für Strom/Spannungssensor
  ina219.setCorrectionFactor(1);
  ina219.setShuntVoltOffset_mV(0.0);
  ina219.setShuntSizeInOhms(0.1045);
  ina219.setADCMode(SAMPLE_MODE_128);


  //  1.8" TFT vorbereiten
  tft.initR(INITR_BLACKTAB);
  tft.fillScreen(ST77XX_BLACK);
  tft.setRotation(3);  // Hier kann die Anzeige um 180° gedreht werden, wenn für den Einbau nötig (1)


  // ----------------- Dauerbeschriftungsblock --------------
  tft.setTextColor(ST77XX_WHITE);
  tft.setCursor(1, 33);
  tft.print("  Volt        Entladeschl.");
  tft.setCursor(3, 80);
  tft.print("  Ampere       Ah");
  tft.setCursor(41, 94);
  tft.print("1");
  tft.setCursor(95, 94);
  tft.print("2");
  tft.setCursor(145, 94);
  tft.print("3");

  tft.drawLine(0, 44, 159, 44, ST77XX_WHITE);      // 1. Trennlinie horiz.
  tft.drawLine(0, 89, 159, 89, ST77XX_WHITE);      // 2. Trennlinie horiz.
  tft.drawLine(80, 2, 80, 89, ST77XX_WHITE);       // Trennlinie Mitte vertikal
  tft.drawLine(0, 98, 0, 128, ST77XX_WHITE);       // Nulllinie Bargraph
  tft.drawLine(27, 104, 27, 108, ST77XX_WHITE);    // Teilstrich 0.5A
  tft.drawLine(54, 100, 54, 108, ST77XX_WHITE);    // Teilstrich 1.0A
  tft.drawLine(81, 104, 81, 108, ST77XX_WHITE);    // Teilstrich 1.5A
  tft.drawLine(108, 98, 108, 108, ST77XX_WHITE);   // Teilstrich 2.0A
  tft.drawLine(133, 104, 133, 108, ST77XX_WHITE);  // Teilstrich 2.5A
  tft.drawLine(159, 98, 159, 108, ST77XX_WHITE);   // Teilstrich 3.0A
  tft.drawRect(0, 109, 160, 19, ST77XX_WHITE);     // Startrahmen Bargraph


  EEPROM.get(0, EndU);

  if (isnan(EndU)) {  // Wenn EEPROM noch leer Startwert  5V verwenden
    EndU = 500;
  }

  dtostrf(EndU / 100, 2, 2, Printout);
  canvas.setFont(&FreeSans18pt7b);
  canvas.setCursor(0, 26);
  canvas.println(Printout);
  tft.drawBitmap(86, 2, canvas.getBuffer(), 67, 29, ST77XX_GREEN, ST77XX_BLACK);
  canvas.fillScreen(ST77XX_BLACK);
}



void loop() {  //----------------- Dieser Teil "loop" wird im Betrieb, also ständig, durchlaufen -------------------

  // Werte vom Strom/Spannungssensor holen
  busVoltage = ina219.getBusVoltage_V();
  current = ina219.getCurrent_mA() / 1000;


  // Entladeschlussspannung Auswertung

  if ((digitalRead(12) == LOW) && (Messen == false)) {  //Drehgeber gedrückt
    digitalWrite(6, HIGH);                              // Relais einschalten
    Messen = true;
    Ah = 0;
    delay(1000);
    EEPROM.put(0, EndU);  // Entladeschlussspannung im EEPROM speichern
  }

  if (busVoltage < EndU / 100) {
    digitalWrite(6, LOW);  // Relais aus
    Messen = false;
  }

  if ((digitalRead(12) == LOW) && (Messen == true)) {  //Drehgeber erneut gedrückt
    digitalWrite(6, LOW);                              // Relais ausschalten
    Messen = false;
  }

  if (Messen == true) {

    currentMillis = millis();
    if (currentMillis - previousMillis >= 1000) {  // Sekundentakt Erzeugung
      Ah = (Ah + current);                         // während Entladung: Ah im Sekundentakt  aufaddieren
      previousMillis = currentMillis;
    }
  }


  // ------------ Werte aufs Display schreiben --------------
  // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

  if (STOP == false) {  //Nur wenn Drehgeber nicht betätigt


    // Strom
    dtostrf(current, 1, 2, Printout);                                                // Wert formatieren, 1 Vorkomma - 2 Nachkommastelle
    canvas.setFont(&FreeSans18pt7b);                                                 // Schriftart zuordnen
    canvas.setCursor(0, 26);                                                         // Text position im Canvas (links unten)
    canvas.println(Printout);                                                        // Wert ausgeben
    tft.drawBitmap(2, 48, canvas.getBuffer(), 67, 29, ST77XX_YELLOW, ST77XX_BLACK);  // Pixel aufs Display schreiben, 88 = X Pos., 2 = Y Pos, Vordergrund, Hindergrundfarbe
    canvas.fillScreen(ST77XX_BLACK);                                                 // Canvas löschen mit Hintergrundfarbe


    // Spannung
    dtostrf(busVoltage, 2, 2, Printout);
    canvas.setFont(&FreeSans18pt7b);
    canvas.setCursor(0, 26);
    canvas.println(Printout);
    tft.drawBitmap(3, 2, canvas.getBuffer(), 67, 29, ST77XX_CYAN, ST77XX_BLACK);
    canvas.fillScreen(ST77XX_BLACK);


    // Ah
    dtostrf(Ah / 3600, 2, 2, Printout);
    canvas.setFont(&FreeSans18pt7b);
    canvas.setCursor(0, 26);
    canvas.println(Printout);
    if (Messen == true) {
      tft.drawBitmap(87, 48, canvas.getBuffer(), 67, 29, ST77XX_ORANGE, ST77XX_BLACK);
    } else {
      tft.drawBitmap(87, 48, canvas.getBuffer(), 67, 29, ST77XX_WHITE, ST77XX_BLACK);
    }
    canvas.fillScreen(ST77XX_BLACK);
  }


  // --------------- Bargraph ----------------

  I_bargraph = (current * 53.33);                 // Bargraph Anpassung an Displaybreite
  I_bargraph_diff = I_bargraph - I_bargraph_alt;  // Berechnung der Differenz durch Vergleich mit vorhergehendem Wert
  I_bargraph_alt = I_bargraph;                    // alten Wert gleichsetzen

  tft.fillRect(1, 110, I_bargraph, 17, ST77XX_YELLOW);
  if (I_bargraph_diff < 0) {  // Bei kleiner werdenden Bargraph Restfläche wieder schwarz füllen
    tft.fillRect(I_bargraph, 110, I_bargraph - (I_bargraph_diff - 1), 17, ST77XX_BLACK);
  }
  //+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++


  // Nur wenn keine Messung läuft Entladeschlussspannung aufs Display schreiben
  if ((Messen == false) && (STOP == true)) {

    dtostrf(EndU / 100, 2, 2, Printout);
    canvas.setFont(&FreeSans18pt7b);
    canvas.setCursor(0, 26);
    canvas.println(Printout);
    tft.drawBitmap(86, 2, canvas.getBuffer(), 67, 29, ST77XX_GREEN, ST77XX_BLACK);
    canvas.fillScreen(ST77XX_BLACK);
  }


  if (STOP == true) {  // Wenn Drehgeber nicht mehr betätigt nach 20 Zyklen wieder alle Anzeigen aktualisieren

    wz++;
    if (wz > 20) {
      STOP = false;
      wz = 0;
    }
  }
}
