// NotRotorControl von DL6MHW (2021-2022)
// FUNKAMATEUR 9/22 S718-720
// Basisversion mit CW/CCW und Langsamlauf 
// LCD-Shield-Beispiel von https://funduino.de/zb-01-keypad-shield
#include <LiquidCrystal.h>
LiquidCrystal lcd(8, 9, 4, 5, 6, 7); //Angabe der erforderlichen Pins
 
int rotorOffset=488; //hier der A5=Poti-Wert für Norden
int rotorFaktor=194; //hier der Faktor=Ohm-Wert für ein 100stel Grad
int A5Wert = 0;
int status = 0; //0=Rotor steht/1=slow/2=fast
int dir=0; //Richtung in Grad

int Taster = 0;
int Analogwert = 0;
//diese Konstanten sind schon entsprechend des Tastennutzung  gewählt
#define TCW 0
#define TJA 1
#define T4X 2
#define TUSA 3
#define TCCW 4
#define KeinTaster 5

 
// Ab hier wird ein neuer Programmblock mit dem Namen "Tasterstatus" erstellt. 
// Hier wird ausschließlich geprüft, welcher Taster gedrückt ist.
int Tasterstatus()
{
  Analogwert = analogRead(A0); // Auslesen der Taster am Analogen Pin A0.
  if (Analogwert > 1000) return KeinTaster;
  if (Analogwert < 50) return TCW;
  if (Analogwert < 195) return TJA;
  if (Analogwert < 380) return T4X;
  if (Analogwert < 555) return TUSA;
  if (Analogwert < 790) return TCCW;
  return KeinTaster; // Ausgabe wenn kein Taster gedrückt wurde.
}

//Richtungsrelais 1+2 an A3 auf CCW setzen
void ccw() {
 digitalWrite(A3, LOW); 
}  

//Richtungsrelais 1+2 an A3 auf CW setzen
void cw() {
 digitalWrite(A3, HIGH); 
} 
 
//Langsamlauf über A1
void slow() {
 status=1;
 lcd.setCursor(11,1);
 lcd.print("Slow  ");
 digitalWrite(A1, HIGH);
}

//Schnelllauf über A1
void fast(){
 status=2;
 lcd.setCursor(11,1);
 lcd.print("FAST  ");
 digitalWrite(A1, LOW);
}

//stoppen mit 2 Sek langsamlauf
void stop() {
  slow();
  delay(2000);
  digitalWrite(A2, HIGH); //Rotorspanung ausschalten
  lcd.setCursor(11,1);
  lcd.print("     "); 
}

//Umrechnung A5Wert in Kompass-Grad
int a5wert2grad(int A5IN) {
  int grad;
  //Faktor 100 damit weiter mit Integer gerechnet werden kann
  grad = 100*(A5IN-rotorOffset)/rotorFaktor;
  if (grad<0) grad=360+grad;
  return grad;
}  

//Rotorspannung mit A2 einschalten, nach 1 Sekunde von Slow auf Fast 
void start() {
  slow();
  digitalWrite(A2, LOW); 
  delay(500);
  fast();
}

void setup()
{
  lcd.begin(16, 2); // Starten der Programmbibliothek.
  lcd.setCursor(0,0); // Angabe des Cursorstartpunktes oben links.
  lcd.print("Notrotor DL6MHW"); // Ausgabe des Textes "Nachricht".

  //Analogpings werden als digital out genutzt
  pinMode(A1, OUTPUT); //schaltet Spannung 12V/24V um
  pinMode(A2, OUTPUT); //schaltet Spannung ein
  pinMode(A3, OUTPUT); //wechselt Richtung

  //alle Relais sind Low Aktiv - so erstmal alle ausgeschaltet
  digitalWrite(A2, HIGH); //keine Spannung 
  digitalWrite(A1, HIGH); 
  digitalWrite(A3, HIGH); 

  delay(1000);
  lcd.setCursor(0,0);
  lcd.print("...         "); 
}



void loop()
{
  lcd.setCursor(0,1); // Bewegt den Cursor and die Stelle "0" in Zeile 2.
  //A5Wert auslesen und anzeigen
  A5Wert = analogRead(A5);
  lcd.print("A5:");
  lcd.setCursor(3,1);
  lcd.print(A5Wert);

  //Richtung anzeigen
  dir=a5wert2grad(A5Wert);
  lcd.setCursor(0,0);
  lcd.print("   ");
  lcd.setCursor(0,0);
  lcd.print(dir);
  lcd.print(" Grad  ");

  //Status anzeigen
  lcd.setCursor(9,1);
  lcd.print(status); 

  //Tastatur auslesen und Taste Anzeigen 
  Taster = Tasterstatus(); 
  lcd.setCursor(7,1); 
  lcd.print(Taster);

  
  if (Taster == KeinTaster) {
   if (status>0) { //Wenn Staus >0 läuft der Rotor und soll gestoppt werden
     lcd.setCursor(10,0);
     lcd.print("Stopping");
     stop();
     status=0;  
    } else { //sonst anzeige löschen     
     lcd.setCursor(10,0);
     lcd.print(" ...    ");
    }
  }
  if (Taster == TCW) { //CW starten
    lcd.setCursor(10,0); 
    lcd.print("CW   ");
    cw();
    if (status<1) start();
  }
  if (Taster == TCCW) { //CCW starten
    lcd.setCursor(10,0); 
    lcd.print("CCW    ");
    ccw();
    if (status<1) start();
  }
  delay(1000); //1 Sekunde wartezeit
} //Loop beenden
