# Testprogramm für SWR-Meter, Version1 vom  15.Januar2022
import TFT24
import machine
from machine import Pin, SPI, ADC
import time
import ili9341
spi = machine.SPI(2, baudrate = 32000000)
spi = SPI(mosi=Pin(23), sck=Pin(18), miso=Pin(19))
display= ili9341.ILI9341(spi, cs=machine.Pin(17), dc=machine.Pin(2), rst=machine.Pin(14), width=240, height=320)
tft=TFT24.TFTDisplay(240,320,display)   # Eine Instanz (Objekt) der Klasse Clear wird angelegt
tft.Clr()     # Start der Eigenschaft (Funktion) ClearDisp
tft.Fill(0,0,0)
adcv=ADC(Pin(36))
adcr=ADC(Pin(39))
flagv=0    # Flag: V-Aktion!
flagr=0    # Flag: R-Aktion!
xvwold=0  # x-Wert des Balkens für Vorwärts-old
dwv=0    # Durchschnittswert Vorwärts
dwr=0    # Durchschnittswert Rückwärts
n=1      # Anzahl der Durchschnittswerte
tft.Ptz3(0,1,"V-Leistung:",255,255,255)
tft.Ptz3(0,7,"SWR:",255,255,255)

while True:
    ewvn= adcv.read()
    dwv = int((dwv*n+ewvn)/(n+1))            #Gleitende Mittelwertbildung für Vorwärts
    ewrn= adcr.read()
    dwr = int((dwr*n+ewrn)/(n+1))             #Gleitende Mittelwertbildung für Rückwärts
    
    
    if ((ewvn <= dwv-30) or (ewvn >= dwv+30)):
        flagv=1
    if ((ewrn <= dwr-30) or (ewrn >= dwr+30)):
        flagr=1    
        
    if (flagv == 1):    
        tft.Fra(190,210,120,50,0,0,0)      #Löschen des alten Vorwärts-Zahlenwertes
        vw="{:4.0f}W"
        tft.Ptz3(11,1,vw.format(dwv),255,255,255)
        xvw=int(dwv/4096*320)
        
        if (xvw<=xvwold):                  #Kürzen des Balkens   
            tft.Fra(xvw,100,(319-xvw),50,0,0,0)
        else:
            tft.Fra(0,100,xvw,50,0,255,0)      #Filled Rectangle
        xvwold=xvw
        print("Vorwärts: ", dwv)
        flagv=0
        
    if (flagr == 1):     
        tft.Fra(60,0,120,50,0,0,0)      #Löschen des alten SWR-Wertes
        wrn=dwr/1000
        rw="{:1.3f}"
        tft.Ptz3(4,7,rw.format(wrn),255,255,255)
        print("Rückwärts: ", dwr) 
        flagr=0
    
    time.sleep_ms(10)








