# The MIT License (MIT)
# Copyright (c) 2021 Mike Teachman
# https://opensource.org/licenses/MIT

# example for MicroPython rotary encoder

import sys
if sys.platform == 'esp8266' or sys.platform == 'esp32':
    from rotary_irq_esp import RotaryIRQ
elif sys.platform == 'pyboard':
    from rotary_irq_pyb import RotaryIRQ
elif sys.platform == 'rp2':
    from rotary_irq_rp2 import RotaryIRQ
else:
    print('Warning:  The Rotary module has not been tested on this platform')

import time
from machine import Pin, ADC
adc=ADC(Pin(36))
pin_sw = Pin(27,Pin.IN,Pin.PULL_UP)     # Pin des Encoder-Tasters

r = RotaryIRQ(pin_num_clk=26,
              pin_num_dt=25,
              min_val=-1,
              max_val=17
              ,
              reverse=False,
              range_mode=RotaryIRQ.RANGE_WRAP)

val_old = r.value()
pin_sw_old=1

while True:
    flagsw=0                 #Flag-Speicherbit für den Encoder-Switch (ausgelöst)
    val_new = r.value()
    if val_old != val_new:
        val_old = val_new
        print('result =', val_new)
    
    if (pin_sw()==0) and (pin_sw_old==1):   #H-L-Flankenerkennung
        time.sleep_ms(10)
        if (pin_sw())==0:                 # nach 10ms nochmal fragen (Entprellung)             
            flagsw=1                      # Switch wurde betätigt
    if (pin_sw()==1):
        flagsw=0
        
    pin_sw_old=pin_sw()
    
    if (flagsw==1):
        print (3.3/4096*adc.read(),"V")
        flagsw=0

    time.sleep_ms(50)