library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

package Definitions is
	--constant g_CLKS_PER_BIT : integer := 868; -- 57600  @ 50MHz
	--constant g_CLKS_PER_BIT : integer := 217; -- 230400 @ 50MHz
	--constant g_CLKS_PER_BIT : integer := 2170; -- 57600  @ 125MHz
	--constant g_CLKS_PER_BIT : integer := 543; -- 230400 @ 125MHz
	--constant g_CLKS_PER_BIT : integer := 2482; -- 57600  @ 143MHz
	constant g_CLKS_PER_BIT : integer := 621; -- 230400 @ 143MHz
	
	subtype reg_t is std_logic_vector(15 downto 0);
	type reg_array_t is array(0 to 7) of reg_t;
	
	subtype idx_t is std_logic_vector(15 downto 0);
	type idx_array_t is array(0 to 7) of idx_t;
	
	type range_sel_t is (uni_1_25_V_ref, bipol_1_25_V_ref);
end Definitions;
