use work.all;
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity DAC is
	port(
		res_n : in std_logic;
		clk : in std_logic;
		DAC_nSYNC : out std_logic;
		DAC_SCLK : out std_logic;
		DAC_DIN : out std_logic;
		DAC_data : in std_logic_vector(15 downto 0);
		DAC_send_d : in std_logic
	);
end DAC;

architecture behav of DAC is
	type state_t is (reset_state, apply_data, wait_state_1, wait_state_1_e, clk_re_state, wait_state_2, wait_state_2_e, clk_fe_state);
	signal current_state : state_t := reset_state;
	signal next_state : state_t;
	signal data_idx : integer range 0 to 24 := 0;
	signal next_data_idx : integer range 0 to 24 := 0;
begin
	calc_next_state: process(current_state, DAC_send_d, data_idx) is
	begin
		case current_state is
			when reset_state =>
				if DAC_send_d = '1' then
					next_state <= apply_data;
				else
					next_state <= reset_state;
				end if;
				next_data_idx <= 0;
			when apply_data =>
				next_state <= wait_state_1;
				next_data_idx <= data_idx;
			when wait_state_1 =>
				next_state <= wait_state_1_e;
				next_data_idx <= data_idx;
            when wait_state_1_e =>
				next_state <= clk_re_state;
				next_data_idx <= data_idx;
			when clk_re_state =>
				next_state <= wait_state_2;
				next_data_idx <= data_idx;
			when wait_state_2 =>
				next_state <= wait_state_2_e;
				next_data_idx <= data_idx;
            when wait_state_2_e =>
				next_state <= clk_fe_state;
				next_data_idx <= data_idx + 1;
			when clk_fe_state =>
				if data_idx < 24 then
					next_state <= apply_data;
				else
					next_state <= reset_state;
				end if;
				next_data_idx <= data_idx;
		end case;
	end process;

	g_p: process(res_n, clk) is
	begin
		if res_n = '0' then
			current_state <= reset_state;
			data_idx <= 0;
		elsif clk'event and clk = '1' then
			current_state <= next_state;
			data_idx <= next_data_idx;
		end if;
	end process;
	
	work_p: process(current_state, DAC_data, data_idx) is
	begin
		case current_state is
			when reset_state =>
				DAC_nSYNC <= '1';
				DAC_SCLK <= '1';
				DAC_DIN <= '0';
			when apply_data =>
				DAC_nSYNC <= '0';
				DAC_SCLK <= '1';
				if data_idx > 7 and data_idx < 24 then
					DAC_DIN <= DAC_data(23 - data_idx);
				else
					DAC_DIN <= '0';
				end if;
			when wait_state_1 =>
				DAC_nSYNC <= '0';
				DAC_SCLK <= '1';
				if data_idx > 7 and data_idx < 24 then
					DAC_DIN <= DAC_data(23 - data_idx);
				else
					DAC_DIN <= '0';
				end if;
            when wait_state_1_e =>
				DAC_nSYNC <= '0';
				DAC_SCLK <= '1';
				if data_idx > 7 and data_idx < 24 then
					DAC_DIN <= DAC_data(23 - data_idx);
				else
					DAC_DIN <= '0';
				end if;
			when clk_re_state =>
				DAC_nSYNC <= '0';
				DAC_SCLK <= '0';
				if data_idx > 7 and data_idx < 24 then
					DAC_DIN <= DAC_data(23 - data_idx);
				else
					DAC_DIN <= '0';
				end if;
			when wait_state_2 =>
				DAC_nSYNC <= '0';
				DAC_SCLK <= '0';
				if data_idx > 7 and data_idx < 24 then
					DAC_DIN <= DAC_data(23 - data_idx);
				else
					DAC_DIN <= '0';
				end if;
            when wait_state_2_e =>
				DAC_nSYNC <= '0';
				DAC_SCLK <= '0';
				if data_idx > 7 and data_idx < 24 then
					DAC_DIN <= DAC_data(23 - data_idx);
				else
					DAC_DIN <= '0';
				end if;
			when clk_fe_state =>
				DAC_nSYNC <= '0';
				DAC_SCLK <= '1';
				if data_idx > 7 and data_idx < 24 then
					DAC_DIN <= DAC_data(23 - data_idx);
				else
					DAC_DIN <= '0';
				end if;
		end case;
	end process;
end architecture;
