use work.all;
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use work.Definitions.all;

entity C2616 is
	port(
		res_n : in std_logic;
		clk_in : in std_logic;
		RX : in std_logic;
		TX : out std_logic;
		
		-- pins to ram device
		sdram_data_Dq : inout std_logic_vector(15 downto 0);
      o_sdram_addr : out std_logic_vector(12 downto 0);
      o_sdram_clk : out std_logic;
      o_sdram_cke : out std_logic;
      o_sdram_cs_l : out std_logic;
      o_sdram_ras_l : out std_logic;
      o_sdram_cas_l : out std_logic;
      o_sdram_we_l : out std_logic;
      o_sdram_ba : out std_logic_vector(1 downto 0);
      o_sdram_dqml : out std_logic;
      o_sdram_dqmh : out std_logic;
		
		DAC_high_1_nSYNC : out std_logic;
		DAC_high_1_SCLK : out std_logic;
		DAC_high_1_DIN : out std_logic;
		
		DAC_low_1_nSYNC : out std_logic;
		DAC_low_1_SCLK : out std_logic;
		DAC_low_1_DIN : out std_logic;
		
		ADC_1_V_nRST : out std_logic;
		ADC_1_V_SDI : out std_logic;
		ADC_1_V_nCS : out std_logic;
		ADC_1_V_SCLK : out std_logic;
		ADC_1_V_SDO_0 : in std_logic;
		ADC_1_V_RVS : in std_logic;
		
		ADC_1_C_nRST : out std_logic;
		ADC_1_C_SDI : out std_logic;
		ADC_1_C_nCS : out std_logic;
		ADC_1_C_SCLK : out std_logic;
		ADC_1_C_SDO_0 : in std_logic;
		ADC_1_C_RVS : in std_logic;
		
		DAC_high_2_nSYNC : out std_logic;
		DAC_high_2_SCLK : out std_logic;
		DAC_high_2_DIN : out std_logic;
		
		DAC_low_2_nSYNC : out std_logic;
		DAC_low_2_SCLK : out std_logic;
		DAC_low_2_DIN : out std_logic;
		
		ADC_2_V_nRST : out std_logic;
		ADC_2_V_SDI : out std_logic;
		ADC_2_V_nCS : out std_logic;
		ADC_2_V_SCLK : out std_logic;
		ADC_2_V_SDO_0 : in std_logic;
		ADC_2_V_RVS : in std_logic;
		
		ADC_2_C_nRST : out std_logic;
		ADC_2_C_SDI : out std_logic;
		ADC_2_C_nCS : out std_logic;
		ADC_2_C_SCLK : out std_logic;
		ADC_2_C_SDO_0 : in std_logic;
		ADC_2_C_RVS : in std_logic;
		
		LEDs : out std_logic_vector(7 downto 0)
	);
end C2616;

architecture struct of C2616 is
	signal clk_150 : std_logic;
	signal clk_sdram : std_logic;
	signal rx_complete : std_logic;
	signal tx_active : std_logic;
	signal tx_start : std_logic;
	signal RX_byte : std_logic_vector(7 downto 0);
	signal TX_byte : std_logic_vector(7 downto 0);
	
	signal software_reset : std_logic;
	signal led_reg : std_logic_vector(15 downto 0);
	signal voltage_current_1 : std_logic;
	signal start_i_1 : std_logic;
	signal start_o_1 : std_logic;
	signal voltage_current_2 : std_logic;
	signal start_i_2 : std_logic;
	signal start_o_2 : std_logic;
	signal calibration_1 : std_logic;
	signal calibration_2 : std_logic;
	signal N_samples : std_logic_vector(15 downto 0);
	
	signal set_point_1_reg : std_logic_vector(15 downto 0);
	signal Kp_1_reg : std_logic_vector(15 downto 0);
	signal Ki_1_reg : std_logic_vector(15 downto 0);
	signal Kd_1_reg : std_logic_vector(15 downto 0);
	signal Kf_1_reg : std_logic_vector(15 downto 0);
	signal Mp_1_reg : std_logic_vector(15 downto 0);
	signal Mi_1_reg : std_logic_vector(15 downto 0);
	signal Md_1_reg : std_logic_vector(15 downto 0);
	signal Mf_1_reg : std_logic_vector(15 downto 0);
	signal bias_high_1_reg : std_logic_vector(15 downto 0);
	signal bias_low_1_reg : std_logic_vector(15 downto 0);
	signal limit_1 : std_logic_vector(15 downto 0);
	
	signal set_point_2_reg : std_logic_vector(15 downto 0);
	signal Kp_2_reg : std_logic_vector(15 downto 0);
	signal Ki_2_reg : std_logic_vector(15 downto 0);
	signal Kd_2_reg : std_logic_vector(15 downto 0);
	signal Kf_2_reg : std_logic_vector(15 downto 0);
	signal Mp_2_reg : std_logic_vector(15 downto 0);
	signal Mi_2_reg : std_logic_vector(15 downto 0);
	signal Md_2_reg : std_logic_vector(15 downto 0);
	signal Mf_2_reg : std_logic_vector(15 downto 0);
	signal bias_high_2_reg : std_logic_vector(15 downto 0);
	signal bias_low_2_reg : std_logic_vector(15 downto 0);
	signal limit_2 : std_logic_vector(15 downto 0);
	
	signal reg_array_r : reg_array_t;
	signal reg_array_w : reg_array_t;
	signal read_addr_reg : std_logic_vector(15 downto 0);
	
	signal mem_ready : std_logic;
	
	signal mem_idx_1 : std_logic_vector(15 downto 0);
	signal strobe_1 : std_logic;
	signal ADC_1_V_data_o : std_logic_vector(15 downto 0);
	signal ADC_1_C_data_o : std_logic_vector(15 downto 0);
	signal DAC_1_high_data_o : std_logic_vector(15 downto 0);
	signal DAC_1_low_data_o : std_logic_vector(15 downto 0);
	
	signal mem_idx_2 : std_logic_vector(15 downto 0);
	signal strobe_2 : std_logic;
	signal ADC_2_V_data_o : std_logic_vector(15 downto 0);
	signal ADC_2_C_data_o : std_logic_vector(15 downto 0);
	signal DAC_2_high_data_o : std_logic_vector(15 downto 0);
	signal DAC_2_low_data_o : std_logic_vector(15 downto 0);
	
	signal read_req : std_logic;
	signal read_req_1cyc : std_logic;
	signal read_req_done : std_logic;
	
	signal write_addr_test : std_logic_vector(15 downto 0);
	signal write_data_test : std_logic_vector(15 downto 0);
	signal write_req_test : std_logic;
begin
	pll_1: entity PLL
	port map(
		areset => NOT res_n,
		inclk0 => clk_in,    -- 50MHz from the cristal oscillator
		c0 => clk_150,       -- 150MHz
		c1 => clk_sdram      -- 150MHz @ 281.25 degree phase shift for SDRAM
	);
	
	uart_rx_1: entity UART_RX
	generic map(
		g_CLKS_PER_BIT => g_CLKS_PER_BIT
	)
	port map(
		i_Clk => clk_150,
		i_RX_Serial => RX,
		o_RX_DV => rx_complete,
		o_RX_Byte => RX_byte
	);
	
	uart_tx_1: entity UART_TX
	generic map(
		g_CLKS_PER_BIT => g_CLKS_PER_BIT
	)
	port map(
		i_Clk => clk_150,
		i_TX_DV => tx_start,
		i_TX_byte => TX_byte,
		o_TX_Active => tx_active,
		o_TX_Serial => TX,
		o_TX_Done => open
	);
	
	main_logic_1: entity main_logic
	port map(
		res_n => res_n,
		clk => clk_150,
		RX => RX_byte,
		RX_d => rx_complete,
		TX => TX_byte,
		TX_d => tx_start,
		TX_active => tx_active,
		
		software_reset => software_reset,
		led_reg => led_reg,
		start_o_1 => start_o_1,
		start_o_2 => start_o_2,
		start_i_1 => start_i_1,
		start_i_2 => start_i_2,
		voltage_current_1 => voltage_current_1,
		voltage_current_2 => voltage_current_2,
		calibration_1 => calibration_1,
		calibration_2 => calibration_2,
		N_samples => N_samples,
		
		set_point_1_reg => set_point_1_reg,
		Kp_1_reg => Kp_1_reg,
		Ki_1_reg => Ki_1_reg,
		Kd_1_reg => Kd_1_reg,
		Kf_1_reg => Kf_1_reg,
		Mp_1_reg => Mp_1_reg,
		Mi_1_reg => Mi_1_reg,
		Md_1_reg => Md_1_reg,
		Mf_1_reg => Mf_1_reg,
		bias_high_1_reg => bias_high_1_reg,
		bias_low_1_reg => bias_low_1_reg,
		limit_1 => limit_1,
		
		set_point_2_reg => set_point_2_reg,
		Kp_2_reg => Kp_2_reg,
		Ki_2_reg => Ki_2_reg,
		Kd_2_reg => Kd_2_reg,
		Kf_2_reg => Kf_2_reg,
		Mp_2_reg => Mp_2_reg,
		Mi_2_reg => Mi_2_reg,
		Md_2_reg => Md_2_reg,
		Mf_2_reg => Mf_2_reg,
		bias_high_2_reg => bias_high_2_reg,
		bias_low_2_reg => bias_low_2_reg,
		limit_2 => limit_2,
		
		read_addr_reg => read_addr_reg,
		
		ADC_1_V_data_reg => reg_array_r(0),
		ADC_1_C_data_reg => reg_array_r(1),
		DAC_1_high_data_reg => reg_array_r(2),
		DAC_1_low_data_reg => reg_array_r(3),
		
		ADC_2_V_data_reg => reg_array_r(4),
		ADC_2_C_data_reg => reg_array_r(5),
		DAC_2_high_data_reg => reg_array_r(6),
		DAC_2_low_data_reg => reg_array_r(7),
		
		read_req => read_req,
		read_req_done => read_req_done,
		
		write_addr_test => write_addr_test,
		write_data_test => write_data_test,
		write_req_test => write_req_test
	);
	
	controller_1: entity controller
	port map(
		res_n => res_n,
		software_reset => software_reset,
		clk_h => clk_150,
		N_samples => N_samples,
		
		DAC_high_nSYNC => DAC_high_1_nSYNC,
		DAC_high_SCLK => DAC_high_1_SCLK,
		DAC_high_DIN => DAC_high_1_DIN,
		
		DAC_low_nSYNC => DAC_low_1_nSYNC,
		DAC_low_SCLK => DAC_low_1_SCLK,
		DAC_low_DIN => DAC_low_1_DIN,
		
		ADC_V_nRST => ADC_1_V_nRST,
		ADC_V_SDI => ADC_1_V_SDI,
		ADC_V_nCS => ADC_1_V_nCS,
		ADC_V_SCLK => ADC_1_V_SCLK,
		ADC_V_SDO_0 => ADC_1_V_SDO_0,
		ADC_V_RVS => ADC_1_V_RVS,
		
		ADC_C_nRST => ADC_1_C_nRST,
		ADC_C_SDI => ADC_1_C_SDI,
		ADC_C_nCS => ADC_1_C_nCS,
		ADC_C_SCLK => ADC_1_C_SCLK,
		ADC_C_SDO_0 => ADC_1_C_SDO_0,
		ADC_C_RVS => ADC_1_C_RVS,
		
		voltage_current => voltage_current_1,
		start_i => start_i_1,
		start_o => start_o_1,
		calibration_i => calibration_1,
		
		set_point_reg => set_point_1_reg,
		Kp_reg => Kp_1_reg,
		Ki_reg => Ki_1_reg,
		Kd_reg => Kd_1_reg,
		Kf_reg => Kf_1_reg,
		Mp_reg => Mp_1_reg,
		Mi_reg => Mi_1_reg,
		Md_reg => Md_1_reg,
		Mf_reg => Mf_1_reg,
		bias_high_reg => bias_high_1_reg,
		bias_low_reg => bias_low_1_reg,
		limit => limit_1,
		
		mem_idx => mem_idx_1,
		strobe => strobe_1,
		mem_ready => mem_ready,
		ADC_V_data_o => reg_array_w(0),
		ADC_C_data_o => reg_array_w(1),
		DAC_high_data_o => reg_array_w(2),
		DAC_low_data_o => reg_array_w(3)
	);
	
	controller_2: entity controller
	port map(
		res_n => res_n,
		software_reset => software_reset,
		clk_h => clk_150,
      N_samples => N_samples,
		
		DAC_high_nSYNC => DAC_high_2_nSYNC,
		DAC_high_SCLK => DAC_high_2_SCLK,
		DAC_high_DIN => DAC_high_2_DIN,
		
		DAC_low_nSYNC => DAC_low_2_nSYNC,
		DAC_low_SCLK => DAC_low_2_SCLK,
		DAC_low_DIN => DAC_low_2_DIN,
		
		ADC_V_nRST => ADC_2_V_nRST,
		ADC_V_SDI => ADC_2_V_SDI,
		ADC_V_nCS => ADC_2_V_nCS,
		ADC_V_SCLK => ADC_2_V_SCLK,
		ADC_V_SDO_0 => ADC_2_V_SDO_0,
		ADC_V_RVS => ADC_2_V_RVS,
		
		ADC_C_nRST => ADC_2_C_nRST,
		ADC_C_SDI => ADC_2_C_SDI,
		ADC_C_nCS => ADC_2_C_nCS,
		ADC_C_SCLK => ADC_2_C_SCLK,
		ADC_C_SDO_0 => ADC_2_C_SDO_0,
		ADC_C_RVS => ADC_2_C_RVS,
		
		voltage_current => voltage_current_2,
		start_i => start_i_2,
		start_o => start_o_2,
      calibration_i => calibration_2,
		
		set_point_reg => set_point_2_reg,
		Kp_reg => Kp_2_reg,
		Ki_reg => Ki_2_reg,
		Kd_reg => Kd_2_reg,
		Kf_reg => Kf_2_reg,
		Mp_reg => Mp_2_reg,
		Mi_reg => Mi_2_reg,
		Md_reg => Md_2_reg,
		Mf_reg => Mf_2_reg,
		bias_high_reg => bias_high_2_reg,
		bias_low_reg => bias_low_2_reg,
      limit => limit_2,
		
		mem_idx => mem_idx_2,
		strobe => strobe_2,
		mem_ready => mem_ready,
		ADC_V_data_o => reg_array_w(4),
		ADC_C_data_o => reg_array_w(5),
		DAC_high_data_o => reg_array_w(6),
		DAC_low_data_o => reg_array_w(7)
	);
	
	read_req_h_p: process(res_n, clk_150) is
		variable triggered : std_logic;
	begin
		if res_n = '0' then
			triggered := '0';
		elsif clk_150'event and clk_150 = '1' then
			if triggered = '0' and read_req = '1' then
				read_req_1cyc <= '1';
				triggered := '1';
			else
				read_req_1cyc <= '0';
			end if;
			
			if read_req = '0' then
				triggered := '0';
			end if;
		end if;
	end process;
	
	mem_manager_e: entity memory_manager
	port map(
		res_n => res_n,
		clk => clk_150,
		clk_sdram => clk_sdram,
		N_samples => N_samples,
		
		-- pins to ram device
		sdram_data_Dq => sdram_data_Dq,
      o_sdram_addr => o_sdram_addr,
      o_sdram_clk => o_sdram_clk,
      o_sdram_cke => o_sdram_cke,
      o_sdram_cs_l => o_sdram_cs_l,
      o_sdram_ras_l => o_sdram_ras_l,
      o_sdram_cas_l => o_sdram_cas_l,
      o_sdram_we_l => o_sdram_we_l,
      o_sdram_ba => o_sdram_ba,
      o_sdram_dqml => o_sdram_dqml,
      o_sdram_dqmh => o_sdram_dqmh,
		
		-- common interface
		mem_ready_o => mem_ready,
		
		-- write interface
		write_req_1 => strobe_1,
		write_idx_1 => mem_idx_1,
		write_req_2 => strobe_2,
		write_idx_2 => mem_idx_2,
		data_i => reg_array_w,
		
		-- read interface
		read_req => read_req_1cyc,
		read_req_done => read_req_done,
		read_idx => read_addr_reg,
		data_o => reg_array_r,
		
		-- test write interface
		write_addr_test => write_addr_test,
		write_data_test => write_data_test,
		write_req_test => write_req_test
	);
	
	LEDs <= led_reg(7 downto 0);
end architecture;
