// 12.10.2021 DL9DWR
// Board - Einstellung: "NodeMcu 1.0 (ESP-12E Module)"
// Als AP und Server 
// ESP8266, wenn LED leuchtet, ist Server gestartet
#include <ESP8266WiFi.h>
#include <ESP8266WebServer.h>
#include "index_html.h" 

#include <Wire.h>

#include <MechaQMC5883.h>
MechaQMC5883 qmc;

int LED=2;              // GPIO2 = blaue LED

const char *ssid = "kompass-ap";      // WLAN-Name
const char *password = "123456789";   // WLAN-Passwort


const int ap_channel = 6;             // WLAN-Kanal
const boolean ap_hidden = false;      // WLAN-Name nicht verbergen

IPAddress local_ip(192,168,4,10);     // Adresse des Kompasses
IPAddress gateway(192,168,4,1);
IPAddress netmask(255,255,255,0);

ESP8266WebServer server(80);

void setup() {
  Wire.begin();
  qmc.init();

  pinMode(LED, OUTPUT);         // Init der LED_BUILTIN Pin als Output
  digitalWrite(LED, HIGH);      // LED aus
  
  Serial.begin(115200);
  Serial.println();

  Serial.println("Setting IP Address");
  WiFi.softAPConfig(local_ip, gateway, netmask);
  
  Serial.print("IP Address: ");
  Serial.println(WiFi.softAPIP());

  Serial.println("Starting Access Point");
  boolean result = WiFi.softAP(ssid, password, ap_channel, ap_hidden);
  if (result == true) {
    Serial.println("Access Point Ready");
    Serial.print("SSID: ");
    Serial.println(ssid);
    Serial.print("Channel: ");
    Serial.println(ap_channel);
    
    server.on("/", Ereignis_Index); 
    server.onNotFound(handleNotFound);
    server.begin();

    Serial.println("Web Server Started");
    digitalWrite(LED, LOW);   
    delay(500);
    digitalWrite(LED, HIGH); 
    delay(500);
    digitalWrite(LED, LOW); 
    }
    else {
    Serial.println("Failed!");
    }
}

void loop() {
  server.handleClient();
}

void Ereignis_Index() {  // gehört zu WLAN! Wird ausgeführt wenn "http://<ip address>/" aufgerufen wurde
 
  int x, y, z;
  int azimuth;
  //float azimuth; //is supporting float too
  qmc.read(&x, &y, &z,&azimuth);
  azimuth = qmc.azimuth(&y,&x);
  
  String xStr; 
  xStr = String(azimuth); // Wandelt Integer in String um
  
  if (server.args() > 0) // wenn Argumente im GET Anfrage vorhanden sind z.B http://<ip address>/?zustand=r
  {
     
  server.sendHeader("Cache-Control", "no-cache"); // damit Daten nicht aus dem Browser cach kommen
  server.send(200, "text/plain",  (xStr));        // Antwort an Internet Browser
  }
  
  else        // wenn keine Argumente im GET Anfrage
  {
    //("Sende Index.html");
    server.send(200, "text/html", indexHTML);  // Index Webseite senden (siehe Datei "index_html.h")
 }
}

void handleNotFound() {
  server.send(404, "text/plain", "404 Not found");
}
