
/*
TRX Sequencer für den RedPitaya und entsprechend zu steuernde Endstufen
DF2RI 28.12.2020

Sequenzer für 2 potentialfreie PTT Ausgänge und einen 12 V PTT Ausgang max 4 Ampere

Relais 1, 2, 3,  sind bei RX alle abgefallen !!  Relais werden an + 5 V und den entsprechenden Digitalport D3 D4 D5 geschaltet

12 V Ausgang ist bei RXX aus geschaltet

PTT Taster des Sequenzers wird nach Masse und D2 geschaltet

*/
  
  int ptt=2;                      //  pin D2 PTT ;   PTT schaltet nach Masse, wird an PTT1 Stiftleiste der RedPitaya Adapterplatine angeschlossen
  
  int relais1=3;                  //  pin D3 (LED rot) Antennenumschaltrelais K1 am Eingang RedPitaya
  int relais2=4;                  //  pin D4 (LED weiss) Antennenumschaltrelais Antennenseite 
  int relais3=5;                 //   pin D5 (LED blau) PTT 1 KW PA 
  int PMOS=7;                    //   pin D7 steuert den PMOS Transistor zum schalten des 12 V PTT Ausganges an, schaltet mit Relais 1 an D3
  int pttstatus = 1;              //  ptt Variable PTT nach Masse
 
  void setup()  {
  
    pinMode(relais1, OUTPUT);          //Antennenumschaltrelais TRX Seite
    pinMode(relais2, OUTPUT);          //Antennenumschaltrelais Antennenseite UND +12 V für VV 5 Watt
    pinMode(relais3, OUTPUT);          //PTT 1 KW PA
  
    pinMode(PMOS, OUTPUT);              //Antennenumschaltrelais TRX Seite, invertiert
     
     
  
    pinMode(ptt, INPUT_PULLUP);       // PTT Schalter nach Masse, interner Pulluw Widerstand wird nach intern +5 V aktiviert
                                     
                                      
  
    digitalWrite(relais1, LOW);       //Voreinstellung beim Start des Programms für die drei Relais ( AUS )
    digitalWrite(relais2, LOW);       //Voreinstellung beim Start des Programms für die drei Relais ( AUS )
    digitalWrite(relais3, LOW);       //Voreinstellung beim Start des Programms für die drei Relais ( AUS )

    digitalWrite(PMOS, LOW);          //Voreinstellung beim Start des Programms für den PMOS-FET  ( AUS )
                                        
                                       
  }
    
  void loop() {                         // Beginn Hauptprogramm das immer wiederholt wird
  
    pttstatus = digitalRead (ptt);      // abfragen des PTT Einganges
                                        
    
      if (pttstatus == LOW)             // wenn PTT vom RedPitaya auf Masse geht, dann......
    
    {      
      digitalWrite(relais1, HIGH);      //Antennenumschaltrelais RedPitaya Seite  schaltet den Eingang 1 des RP auf Masse und
      digitalWrite(PMOS, HIGH);         // PTT 12 V für kleine PA wird eingeschaltet maximal 4 Ampere
      delay(20);                       //  20 ms warten bis das nächste Relais schaltet ; HIER kann die ERSTE Einschaltverzögerung in Millisekunden geändert werden !!
      digitalWrite(relais2, HIGH);      // Antennenumschaltrelais Antennenseite schaltet und der Ausgang der Vorverstärker PA wird auf die SMA Buchse auf die Antenne oder die Nachfolgende PA geschaltet 
                                        
      delay(20);                       // 20 ms warten bis die PTT für 750 W PA eingeschaltet wird ; HIER kann die Zweite Einschaltverzögerung in Millisekunden geändert werden !!
      digitalWrite(relais3, HIGH);      //PTT 750 KW PA PTT schaltet
                                        
      delay(100);
    }
  
      else                              // wenn PTT vom RedPitaya nicht mehr kommt, dann ....
    
    {     
      digitalWrite(relais3, LOW);       //PTT 1 KW PA PTT schaltet ab
                                        
      delay(20);                        // 20 ms warten bis ms warten bis das nächste Relais abfällt ; HIER kann die ERSTE Abfallverzögerung in Millisekunden geändert werden !!
      digitalWrite(relais2, LOW);       //Antennenumschaltrelais Antennenseite schaltet ab
                                        
      delay(10);                       // 20 ms warten  bis das nächste Relais abfällt ; HIER kann die ZWEITE Abfallverzögerung in Millisekunden geändert werden !!
      digitalWrite(relais1, LOW);       //Antennenumschaltrelais Eingang RedPitaya Seite schaltet ab
     digitalWrite(PMOS, LOW);           //Antennenumschaltrelais 12 V Vorverstärker ) schaltet ab
     delay(100);
    }


  }  
 
  
  
 

 
 
