// Steuerung Antennentuner mit Arduino Mega 2560 
// DK3HA
// Version 1.1
// Änderung ctx-Erweiterung auf 0..127 ( 1 zusätzliches Relais, um evtl. auf 30m
// eine Anpassung zu erreichen. K7 (ctx7) auf Pin7 Pinhead Cap-Tx. --> Pin 15 Jp1 
// zusätzliche Heizung auf Pin 22 und 23. Pin 22 --> GND, Pin23 --> 12V/300mA
//

#include <EEPROM.h>
#include <LiquidCrystal.h>
#include <SPI.h>
#include <Rotary.h>   //Rotary encoder: https://github.com/brianlow/Rotary 

LiquidCrystal lcd(13, 12, 11, 10, 9, 8);
unsigned long currentTime;
unsigned long loopTime;
const int pin_A = A1;        //      Cant Enc Pin1 --> A0 Alps-Encoder tausche A0 - A1
const int pin_B = A0;        //      Cant Enc Pin2 --> A1
const int pin_SW1B = A2;     //      SW1B Umschaltung manuell-Speicherbetrieb
unsigned char encoder_A;
unsigned char encoder_B;
unsigned char encoder_A_last = 0;
unsigned long loopTime2;
const int pin_A2 = A4;       //      Tx Enc Pin1 --> A3 Alps-Encoder tausche A3 - A4
const int pin_B2 = A3;       //      Tx Enc Pin2 --> A4
const int pin_SW2B =A5;      //      SW2B Push-Button encoder2
unsigned char encoder_A2;
unsigned char encoder_B2;
unsigned char encoder_A2_last = 0;
unsigned long loopTime3;
const int pin_A3 = A7;       //      L Enc Pin1     --> A6 Alps-Encoder tausche A6 - A7
const int pin_B3 = A6;       //      L Enc Pin2     --> A7
const int pin_SW3B =A8;      //      SW3B Push-Button encoder3
unsigned char encoder_A3;
unsigned char encoder_B3;
unsigned char encoder_A3_last = 0;
unsigned long loopTime4;
const int pin_A4 = A10;       //   SP Enc Pin1 --> A9 Alps-Encoder tausche A10 - A9
const int pin_B4 = A9;        //   SP Enc Pin2 --> A10
unsigned char encoder_A4;
unsigned char encoder_B4;
unsigned char encoder_A4_last = 0;

const int pin_SW4B = A11;        // Button SW4B an Port A11,Daten ins EEPROM
int pin_SW4B_Status = 1;         // Status Sw4B
int pin_SW4B_push =0;            // Sw4B gedrückt
int dbounce_Time = 200;          // Entprellzeit
unsigned long pin_SW4B_Time = 0; // wie lange wird Sw4B gedrückt

int count_cant = 0;
int count_ctx = 0;
int count_l = 0;
int count_sp = 0;     // Speicheradresse von 0 bis 30, 31 für last_count-sp
                      // noch nicht implementiert                 
int cant_change =0;
int ctx_change =0;
int l_change =0;
int sp_change =0;
int x = 0;            // Zählvariable

byte cant_byte= 0;
byte ctx_byte = 0;
byte l_byte = 0;
byte sp_byte= 0;
byte sp_used_byte =0;
byte cant_feld[32];
byte ctx_feld[32];
byte l_feld[32];
byte sp_used_feld[32];
String str = "      ";


////////////////////////////////////////////////////////////////////////////
// Nach gefundener Abstimmung hier die Frequenz im Format "xx,xxx" eintragen 
// und den Sketch neu kompilieren.
// Die Anführungsstriche müssen erhalten bleiben.
// Die Position 31 bleibt unverändert.
// f0 --> Frequenz für Speicherplatz 0 usw.
 
#define f0  "10,100"     // Zeile 0 Position 0 
#define f1  "10,150"     
#define f2  "14,000"     
#define f3  "14,100"     
#define f4  "14,200"    
#define f5  "14,300"    
#define f6  "18,068"     
#define f7  "18,168"  
#define f8  "21,100"    
#define f9  "21,300"    
#define f10 "21,400"    
#define f11 "21,200"     
#define f12 "24,900"     
#define f13 "28,100"    
#define f14 "28,300"       
#define f15 "28,500"     
#define f16 "28,900"     
#define f17 "      "  
#define f18 "      "     
#define f19 "      "     
#define f20 "      "    
#define f21 "      "    
#define f22 "      "    
#define f23 "      "    
#define f24 "      "    
#define f25 "      "     
#define f26 "      "     
#define f27 "      "     
#define f28 "      "     
#define f29 "      "    
#define f30 "      "    
#define f31 "used  "    

// Ende der Frequenzliste je Speicherplatz
////////////////////////////////////////////////////////////////////////////////////////


bool sp_betrieb = false;
bool manuell = false;

///////////////////////////////  Ende Deklaration ///////////////////////////////////////
                     
void setup() 

{ pinMode(pin_A, INPUT_PULLUP);
  pinMode(pin_B, INPUT_PULLUP);
  pinMode(pin_A2, INPUT_PULLUP);
  pinMode(pin_B2, INPUT_PULLUP);
  pinMode(pin_A3, INPUT_PULLUP);
  pinMode(pin_B3, INPUT_PULLUP);
  pinMode(pin_A4, INPUT_PULLUP);
  pinMode(pin_B4, INPUT_PULLUP);
  pinMode(pin_SW1B, INPUT_PULLUP);
  pinMode(pin_SW2B, INPUT_PULLUP);
  pinMode(pin_SW3B, INPUT_PULLUP);
  pinMode(pin_SW4B, INPUT_PULLUP);
  
  Serial.begin(9600);
  for (x=22;x<52;x++)
 {
  pinMode(x,OUTPUT);                     // Pins 28 bis 52 initialisiert
  digitalWrite(x,LOW);                   // digitalWrite(x,LOW);-> beim Einsatz des ULN2803
 }
 for (x=0; x<32; x++)
 {
  cant_feld[x] = 0;
  ctx_feld[x] = 0;
  l_feld[x] = 0;
  sp_used_feld[x] = 0;
 }
 for (x=32; x<128; x++)                  // EEPROM Leerzellen (ctx,L,sp_belegt)auf 0 setzen
 {                                       // wegen LCD-Anzeige  
  if (EEPROM.read(x) == 255)             // ctx und L Platz nur für Werte < 100
    { EEPROM.update(x,0); }              // ctx [0..127], L [0..31],sp_belegt [0..1]              
 }
 
 // EEprom lesen für Speicherplätze
 // Organisation im EEPROM: 
 // Adressen im EEPROM [0..31]   --> Kondensatorwerte Antennenseite 256 Werte ( 2^8 )
 // Adressen im EEPROM [32..63]  --> Kondensatorwerte Senderseite 128 Werte ( 2^7 )
 // Adressen im EEPROM [64..95]  --> Induktivitätswerte (symmetrisch) 32 Werte ( 2^5 )
 // Adressen im EEPROM [96..127] --> Speicherplatz frei = 0 / belegt = 1  2 Werte
 
                                            // Die Felder CANT, CTX, L, sp_belegt [0..31]
                                            // werden im EEPROM wie angegeben abgebildet.
 for (x=0;x<32;x++)                         
 {
  cant_feld[x] = EEPROM.read(x);            // Adresse 0..31   cant im EEPROM
  ctx_feld[x] = EEPROM.read(x+32);          // Adresse 32..63  ctx im EEPROM
  l_feld[x] = EEPROM.read(x+64);            // Adresse 64..95  l im EEPROM
  sp_used_feld[x] = EEPROM.read(x+96);      // Adresse 96..127 1--> belegt, 0--> frei 
 }
  currentTime = millis();
  loopTime = currentTime;
  loopTime2 = currentTime;
  loopTime3 = currentTime;
  lcd.begin(16, 2);
  lcd.clear();
  lcd.print("Symm. ATU DK3HA");
  delay(2000);
  lcd.clear();
  lcd.setCursor(0, 0);   
  if (digitalRead(pin_SW1B)== 1) 
 {                  
  lcd.print("CANT CTX  L SP  ");          //Zeile 0
  //         0123456789abcdef
  lcd.setCursor(0, 1);                    //Zeile 1
  lcd.print("000 000 000     ");          // 
 }
  else 
  {
    lcd.print("        MHz SP  ");        // Pos. 15 und 16 count_sp
    lcd.setCursor(0, 1);                  //Zeile 1
    lcd.print("CA    CT    L   ");        // 
  }
}

////////////////////// Ende Setup-Routine //////////////////////

////////////////////// HAUPTPROGRAMMSCHLEIFE ///////////////////

void loop() 
{ 
if (digitalRead(pin_SW1B)== 1)             // "1" manuell  "0" Speicherbetrieb
{ 
   if (manuell == false)                  // 
   {
    lcd.setCursor(14, 0); 
    lcd.print(" ");
    lcd.setCursor(15,0);                  //    
    lcd.print(count_sp);
    if (sp_used_feld [count_sp] == 1)
    {
     lcd.setCursor(12, 1);
     lcd.print("used");  
    }
    else {
          lcd.setCursor(12, 1);
          lcd.print("free"); 
         }
    
    manuell = true;
   }

 pin_SW4B_Status = digitalRead(pin_SW4B);  // Einlesen Sw4B
 if (pin_SW4B_Status == 0)                 // Sw4B gedrückt
    {
     pin_SW4B_Time = millis();             // Pin_SW4B_Time -> aktuelle Zeit
     pin_SW4B_push = 1;                    // Speichern, dass Sw4B gedrückt wurde
    }
  if ((millis() - pin_SW4B_Time > dbounce_Time) && pin_SW4B_push ==1) // 
    {                                      // millis() - Beginn push > Entprellzeit und 
                                           // Sw4B ist gedrückt
   cant_feld[count_sp] = cant_byte;        // Speicher Adresse 0..31 für Feld 
   ctx_feld[count_sp] = ctx_byte;          // Speicher Adresse 0..31 für Feld 
   l_feld[count_sp] = l_byte;              // Speicher Adresse 0..31 für Feld 
   sp_used_byte = 1;
   sp_used_feld[count_sp] = sp_used_byte ;
   
   EEPROM.write(count_sp,cant_byte );      // 
   EEPROM.write(count_sp+32,ctx_byte );    //
   EEPROM.write(count_sp+64,l_byte );      //   
   EEPROM.write(count_sp+96, sp_used_byte);//                                        
   pin_SW4B_push =0;                       // Sw4B-Speicher wieder auf 0 zurückgesetzt.                       
                                           // 
   count_sp++;                             // Zählstand des Speichers um 1 erhöhen
   lcd.setCursor(14, 0);
   if(count_sp <10) 
   {
   lcd.print(" ");
   lcd.setCursor(15,0);        // 
   }
   lcd.print(count_sp);  
   sp_used_byte = 0;
    } 
   
    
rotary_enc();                               // Encoder cant Kondensatoren Antennenseite
if (cant_change == 1) 
  { lcd.setCursor(0, 1);
    if(count_cant <10) lcd.print("0");      // führende Nullen im LCD-Display
    if(count_cant <100) lcd.print("0");     // führende Nullen im LCD-Display  
    lcd.print(count_cant);
    cant_byte = count_cant & B11111111;
    
    PORTA = cant_byte;
    cant_change = 0;                   

//   Serial.print("cant_feld ");  
//   Serial.print(cant_feld[0]); 
  } 
    
rotary_enc2();                              // Encoder ctx Kondensatoren Senderseite
if (ctx_change == 1) 
  { lcd.setCursor(4, 1);
    if(count_ctx <10) lcd.print("0");       // führende Nullen im LCD-Display
    if(count_ctx <100) lcd.print("0");      // führende Nullen im LCD-Display
    lcd.print(count_ctx);                   // count_ctx: aktueller Zählstand Eingangs-Cs (CTx)                                                                                                                                                                                                                                                              
    ctx_byte = count_ctx & B11111111;
    
    PORTC = ctx_byte;
    ctx_change = 0;                           
/*
   Serial.print("ctx_feld ");  
   Serial.print(ctx_feld[0]); 
*/   
  }   
    
rotary_enc3();                              // Encoder L parallele Induktivitäten
if (l_change == 1) 
  { lcd.setCursor(8, 1);
    if(count_l <10) lcd.print("0");         // führende Nullen im LCD-Display
    if(count_l <100) lcd.print("0");        // führende Nullen im LCD-Display  
    lcd.print(count_l);                     // count_l: aktueller Zählstand Induktivitäten  
    l_byte = count_l & B11111111;
    
    PORTL = l_byte;
    l_change = 0;                                                                                                                                                                
   
/*    
   Serial.print("l_feld ");  
   Serial.print(l_feld[0]);  
*/
  }      

rotary_enc4();               // Encoder Speicherwahl
if (sp_change == 1) 
  { lcd.setCursor(14, 0);
   if(count_sp <10) {
    lcd.print(" ");
    lcd.setCursor(15,0);     // 
   }
    lcd.print(count_sp);     // count_sp: aktueller Zählstand Feld- und EEPROM-Speicher
    if (sp_used_feld [count_sp] == 1)
    {
     lcd.setCursor(12, 1);
     lcd.print("used");  
    }
    else {
          lcd.setCursor(12, 1);
          lcd.print("free"); 
         }
    sp_change = 0;                                                                                                                                                                
   
/*    
   Serial.print("sp_feld ");  
   Serial.print(sp_feld[0]);  
*/
  }  
  
///////////////////////////// Ende manueller Betrieb ////////////////////////////////////

///////////////////////////// Beginn Speicherbetrieb, wenn SW1B = LOW ///////////////////
      
} else                         
 {
   rotary_enc4();              // Encoder Speicherwahl
   if (sp_betrieb == false){
    sp_change = 1;
    sp_betrieb = true;
   }
   if (sp_change == 1) 
  { lcd.setCursor(14, 0);
   if(count_sp <10) 
   {
    lcd.print(" ");
    lcd.setCursor(15,0);       // 
   }      
    lcd.print(count_sp);       // count_sp: aktueller Zählstand Feld- und EEPROM-Speicher
  
    switch (count_sp) {
      case 0 : str = f0; break;
      case 1 : str = f1; break;
      case 2 : str = f2; break;
      case 3 : str = f3; break;
      case 4 : str = f4; break;
      case 5 : str = f5; break;
      case 6 : str = f6; break;
      case 7 : str = f7; break;
      case 8 : str = f8; break;
      case 9 : str = f9; break;
      case 10 : str = f10; break;
      case 11 : str = f11; break;
      case 12 : str = f12; break;
      case 13 : str = f13; break;
      case 14 : str = f14; break;
      case 15 : str = f15; break;
      case 16 : str = f16; break;
      case 17 : str = f17; break;
      case 18 : str = f18; break;
      case 19 : str = f19; break;
      case 20 : str = f20; break;
      case 21 : str = f21; break;
      case 22 : str = f22; break;
      case 23 : str = f23; break;
      case 24 : str = f24; break;
      case 25 : str = f25; break;
      case 26 : str = f26; break;
      case 27 : str = f27; break;
      case 28 : str = f28; break;
      case 29 : str = f29; break;
      case 30 : str = f30; break;
      case 31 : str = f31; break; 
    } 
    
    lcd.setCursor(0, 0);                  // Zeile 1
    lcd.print(str);                       // 
    cant_byte = cant_feld[count_sp];
    ctx_byte = ctx_feld[count_sp];
    l_byte = l_feld[count_sp];
    PORTA = cant_byte;
    PORTC = ctx_byte;
    PORTL = l_byte;

    lcd.setCursor(2, 1);                 // Speicherbetrieb CANT-Wert --> LCD
    if(cant_byte <10) 
    {
      lcd.print("   ");    
      lcd.setCursor(4,1); 
      lcd.print(cant_byte);     
    } else {         
        if(cant_byte <100)
        { lcd.print("   "); 
          lcd.setCursor(3,1); 
          lcd.print(cant_byte);   
        } else {
           lcd.print("   "); 
           lcd.setCursor(2,1);  
           lcd.print(cant_byte); 
               }  
            }

    lcd.setCursor(8, 1);                 // Speicherbetrieb CTX-Wert --> LCD
    if(ctx_byte <100) 
    {
      lcd.print("   ");    
      lcd.setCursor(10,1); 
      lcd.print(ctx_byte);     
    } else {         
           lcd.print("   "); 
           lcd.setCursor(9,1);  
           lcd.print(ctx_byte); 
           }  

    lcd.setCursor(13, 1);                // Speicherbetrieb L-Wert --> LCD
    if(l_byte <10) 
    {
      lcd.print("   ");    
      lcd.setCursor(15,1); 
      lcd.print(l_byte);     
    } else {         
           lcd.print("   "); 
           lcd.setCursor(14,1);  
           lcd.print(l_byte); 
           }  
                            
    sp_change = 0;    
   
  }
 } 
}
////////////////////// Ende der Hauptprogrammschleife /////////////////////

/////////////////Subroutine: Kondensatoren Antennenseite setzen cant ////////////

void rotary_enc()
{
currentTime = millis();
if (currentTime >= (loopTime + 2)) 
 {
 encoder_A = digitalRead(pin_A);
 encoder_B = digitalRead(pin_B);
 if ((!encoder_A) && (encoder_A_last)) 
  {
  if (encoder_B) 
   { count_cant = count_cant +1;
     if (count_cant > 255)             // 8 Relais für Cs Antennenseite 2^8-1
       { count_cant = 0;               //  
       } 
   }
 else 
   { count_cant = count_cant -1;
     if (count_cant <0)
       { count_cant = 255;
       }        
   }
   cant_change =1;
  }
  encoder_A_last = encoder_A;        // Speichere Wert für nächsten Wechsel
  loopTime = currentTime;            // Aktualisierung loopTime
 }
}

//////////////////// Subroutine: Kondensatoren Senderseite setzen ctx //////////////////

void rotary_enc2()
{
  currentTime = millis();
  if (currentTime >= (loopTime2 + 2)) 
  {
    encoder_A2 = digitalRead(pin_A2);
    encoder_B2 = digitalRead(pin_B2);
    if ((!encoder_A2) && (encoder_A2_last)) 
  {
      if (encoder_B2) 
      { count_ctx = count_ctx +1;     
      if (count_ctx > 127)                // 6 Relais für Cs Senderseite 2^7-1
       { count_ctx = 0;
       }
      }
 else 
   { count_ctx = count_ctx -1;
     if (count_ctx <0)
       { count_ctx = 127;
       }                                 
   }
  ctx_change =1; 
  }
    encoder_A2_last = encoder_A2;     // Speichere Wert für nächsten Wechsel
    loopTime2 = currentTime;          // Aktualisierung loopTime2
  }
}

/////////////////////// Subroutine: Induktivitäten setzen //////////////////// 

void rotary_enc3()
{
  currentTime = millis();
  if (currentTime >= (loopTime3 + 2)) 
  {
    encoder_A3 = digitalRead(pin_A3);
    encoder_B3 = digitalRead(pin_B3);
    if ((!encoder_A3) && (encoder_A3_last)) 
  {
      if (encoder_B3) 
      { count_l = count_l +1;
      if (count_l > 31)              // 5 Relais für Cs Senderseite 2^5-1
       { count_l = 0;
       }                                      
      }
 else 
   { count_l = count_l -1;       
     if (count_l <0)
       { count_l = 31;
       }    
   }
  l_change =1; 
  }
    encoder_A3_last = encoder_A3;     // Speichere Wert für nächsten Wechsel
    loopTime3 = currentTime;          // Aktualisierung loopTime3
  }
}

//////////////////////// Subroutine: Speicherwahl ////////////////////////////
void rotary_enc4()
{
  currentTime = millis();
  if (currentTime >= (loopTime4 + 2)) 
  {
    encoder_A4 = digitalRead(pin_A4);
    encoder_B4 = digitalRead(pin_B4);
    if ((!encoder_A4) && (encoder_A4_last)) 
  {
      if (encoder_B4) 
      { count_sp = count_sp +1;
      if (count_sp > 30)              // 31 freie Speicherplätze 0..30
       { count_sp = 0;                // Adresse 31 reserviert 
       }                              // für die letzten Werte       
      }                               // noch nicht implementiert
 else 
   { count_sp = count_sp -1;       
     if (count_sp <0)
       { count_sp = 30;
       }    
   }
  sp_change =1; 
  }
    encoder_A4_last = encoder_A4;     // Speichere Wert für nächsten Wechsel
    loopTime4 = currentTime;          // Aktualisierung loopTime4
  }
}

/////////////////////////  Ende ///////////////////////
