/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.update;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingWorker;
import krause.util.ras.logging.ErrorLogHelper;
import krause.util.ras.logging.TraceHelper;
import krause.vna.update.DownloadFile;
import krause.vna.update.FileDownloadJob;
import krause.vna.update.FileDownloadStatusListener;

public class FileDownloadTask
extends SwingWorker<List<FileDownloadJob>, FileDownloadJob> {
    private List<FileDownloadJob> jobs = new ArrayList<FileDownloadJob>();
    private FileDownloadStatusListener listener = null;
    private boolean abort = false;

    public FileDownloadTask(FileDownloadStatusListener pList) {
        this.listener = pList;
    }

    public void abort() {
        this.abort = true;
    }

    @Override
    protected List<FileDownloadJob> doInBackground() throws Exception {
        TraceHelper.entry(this, "doInBackground");
        for (FileDownloadJob job : this.jobs) {
            try {
                job.setStatus(0);
                this.publish(job);
                int rc = this.downloadFile(job.getFile(), job.getLocalDirectory());
                job.setStatus(rc);
                this.publish(job);
            }
            catch (Exception e) {
                ErrorLogHelper.exception(this, "doInBackground", e);
                job.setStatus(99);
                this.publish(job);
            }
        }
        TraceHelper.exit(this, "doInBackground");
        return this.jobs;
    }

    @Override
    protected void process(List<FileDownloadJob> jobs) {
        TraceHelper.entry(this, "process");
        if (this.listener != null) {
            for (FileDownloadJob job : jobs) {
                this.listener.publishState(job);
            }
        }
        TraceHelper.exit(this, "process");
    }

    public void publishProgress(int percentage) {
    }

    public void addJob(FileDownloadJob job) {
        this.jobs.add(job);
    }

    public void addJobs(List<FileDownloadJob> jobs) {
        for (FileDownloadJob job : jobs) {
            this.addJob(job);
        }
    }

    private int downloadFile(DownloadFile file, String targetDirectory) {
        String outputFileName;
        int rc;
        block48: {
            TraceHelper.entry((Object)this, "downloadFile", file.getRemoteFileName());
            rc = 0;
            URL url = null;
            URLConnection urlConn = null;
            InputStream inpStream = null;
            BufferedInputStream bufInpStream = null;
            FileOutputStream fileOutStream = null;
            FilterOutputStream buffOutStream = null;
            outputFileName = String.valueOf(targetDirectory) + System.getProperty("file.separator") + file.getLocalFileName();
            if (this.abort) {
                rc = 3;
            } else {
                try {
                    try {
                        int i;
                        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                        messageDigest.reset();
                        new File(targetDirectory).mkdirs();
                        url = new URL(file.getRemoteFileName());
                        urlConn = url.openConnection();
                        inpStream = urlConn.getInputStream();
                        bufInpStream = new BufferedInputStream(inpStream);
                        fileOutStream = new FileOutputStream(outputFileName);
                        buffOutStream = new BufferedOutputStream(fileOutStream);
                        long filesize = 0L;
                        while ((i = bufInpStream.read()) != -1 && !this.abort) {
                            ((BufferedOutputStream)buffOutStream).write(i);
                            ++filesize;
                            messageDigest.update((byte)(i & 0xFF));
                        }
                        file.setFileSize(filesize);
                        ((BufferedOutputStream)buffOutStream).flush();
                        rc = this.abort ? 3 : 1;
                        byte[] resultByte = messageDigest.digest();
                        StringBuffer sb = new StringBuffer();
                        i = 0;
                        while (i < resultByte.length) {
                            sb.append(Integer.toHexString(resultByte[i] & 0xFF | 0x100).substring(1, 3));
                            ++i;
                        }
                        TraceHelper.text(this, "downloadFile", "md5 for file=[" + sb.toString() + "] xml=[" + file.getHash() + "]");
                    }
                    catch (Exception e) {
                        ErrorLogHelper.exception(this, "downloadFile", e);
                        rc = 2;
                        if (buffOutStream != null) {
                            try {
                                buffOutStream.close();
                                if (this.abort) {
                                    File fi = new File(outputFileName);
                                    fi.delete();
                                }
                            }
                            catch (IOException e2) {
                                ErrorLogHelper.exception(this, "downloadFile", e2);
                            }
                        }
                        if (fileOutStream != null) {
                            try {
                                fileOutStream.close();
                            }
                            catch (IOException e3) {
                                ErrorLogHelper.exception(this, "downloadFile", e3);
                            }
                        }
                        if (bufInpStream != null) {
                            try {
                                bufInpStream.close();
                            }
                            catch (IOException e4) {
                                ErrorLogHelper.exception(this, "downloadFile", e4);
                            }
                        }
                        if (inpStream != null) {
                            try {
                                inpStream.close();
                            }
                            catch (IOException e5) {
                                ErrorLogHelper.exception(this, "downloadFile", e5);
                            }
                        }
                        break block48;
                    }
                }
                catch (Throwable throwable) {
                    if (buffOutStream != null) {
                        try {
                            buffOutStream.close();
                            if (this.abort) {
                                File fi = new File(outputFileName);
                                fi.delete();
                            }
                        }
                        catch (IOException e) {
                            ErrorLogHelper.exception(this, "downloadFile", e);
                        }
                    }
                    if (fileOutStream != null) {
                        try {
                            fileOutStream.close();
                        }
                        catch (IOException e) {
                            ErrorLogHelper.exception(this, "downloadFile", e);
                        }
                    }
                    if (bufInpStream != null) {
                        try {
                            bufInpStream.close();
                        }
                        catch (IOException e) {
                            ErrorLogHelper.exception(this, "downloadFile", e);
                        }
                    }
                    if (inpStream != null) {
                        try {
                            inpStream.close();
                        }
                        catch (IOException e) {
                            ErrorLogHelper.exception(this, "downloadFile", e);
                        }
                    }
                    throw throwable;
                }
                if (buffOutStream != null) {
                    try {
                        buffOutStream.close();
                        if (this.abort) {
                            File fi = new File(outputFileName);
                            fi.delete();
                        }
                    }
                    catch (IOException e) {
                        ErrorLogHelper.exception(this, "downloadFile", e);
                    }
                }
                if (fileOutStream != null) {
                    try {
                        fileOutStream.close();
                    }
                    catch (IOException e) {
                        ErrorLogHelper.exception(this, "downloadFile", e);
                    }
                }
                if (bufInpStream != null) {
                    try {
                        bufInpStream.close();
                    }
                    catch (IOException e) {
                        ErrorLogHelper.exception(this, "downloadFile", e);
                    }
                }
                if (inpStream != null) {
                    try {
                        inpStream.close();
                    }
                    catch (IOException e) {
                        ErrorLogHelper.exception(this, "downloadFile", e);
                    }
                }
            }
        }
        TraceHelper.exitWithRC((Object)this, "downloadFile", "rc=" + rc + " - " + outputFileName);
        return rc;
    }

    @Override
    protected void done() {
        TraceHelper.entry(this, "done");
        this.listener.done();
        TraceHelper.exit(this, "done");
    }
}

