/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.resources;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import krause.util.SortedProperties;
import krause.vna.resources.VNAMessages;

public class VNAMessageExtractor2 {
    public static void main(String[] args) {
        VNAMessageExtractor2.extractMessagesForLocale(new Locale("en", "EN"));
        VNAMessageExtractor2.extractMessagesForLocale(new Locale("sv", "SE"));
        VNAMessageExtractor2.extractMessagesForLocale(new Locale("de", "DE"));
        VNAMessageExtractor2.extractMessagesForLocale(new Locale("it", "IT"));
        VNAMessageExtractor2.extractMessagesForLocale(new Locale("pl", "PL"));
        VNAMessageExtractor2.extractMessagesForLocale(new Locale("hu", "HU"));
        VNAMessageExtractor2.extractMessagesForLocale(new Locale("nl", "NL"));
        VNAMessageExtractor2.extractMessagesForLocale(new Locale("es", "ES"));
        VNAMessageExtractor2.extractMessagesForLocale(new Locale("fr", "FR"));
        VNAMessageExtractor2.extractMessagesForLocale(new Locale("ja", "JP"));
    }

    public static void extractMessagesForLocale(Locale locale) {
        SortedProperties localeProps = new SortedProperties();
        Locale.setDefault(locale);
        ResourceBundle bundle = ResourceBundle.getBundle(VNAMessages.BUNDLE_NAME);
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            String val = bundle.getString(key);
            if (key.endsWith(".Command") || key.endsWith(".Image") || key.endsWith(".URL") || key.endsWith(".copyright") || key.endsWith(".date") || key.endsWith(".version")) continue;
            localeProps.put(key, val);
        }
        String filename = "c:/temp/VNAMessage_" + locale.getLanguage().toLowerCase() + ".properties";
        try {
            FileOutputStream os = new FileOutputStream(filename);
            localeProps.store(os, "Extracted by VNAMessageExtractor for " + locale.toString() + "\n\rPlease use only\n\r  http://propedit.sourceforge.jp/propertieseditor.jnlp\n\rto edit this file!!!");
            System.out.println("File [" + filename + "] saved");
            ((OutputStream)os).close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

