/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.marker.math;

import krause.util.ras.logging.TraceHelper;
import krause.vna.marker.math.VNAMarkerMathInput;
import krause.vna.marker.math.VNAMarkerMathResult;

public class VNAMarkerMathHelper {
    private static final double TWO_PI = Math.PI * 2;

    public static VNAMarkerMathResult execute(VNAMarkerMathInput input) {
        VNAMarkerMathResult rc = new VNAMarkerMathResult(input);
        TraceHelper.entry(VNAMarkerMathResult.class, "execute");
        if (input.getHighFrequency() - input.getLowFrequency() > 0L) {
            rc.setBandWidth(input.getHighFrequency() - input.getLowFrequency());
            rc.setQ(input.getCenterFrequency() / rc.getBandWidth());
        }
        rc.setSerialCapacity(1.0 / (Math.PI * 2 * (double)input.getCenterFrequency() * input.getZ()));
        rc.setSerialInductance(input.getZ() / (Math.PI * 2 * (double)input.getCenterFrequency()));
        rc.setRp(input.getRs() * (1.0 + input.getXs() / input.getRs() * (input.getXs() / input.getRs())));
        rc.setXp(rc.getRp() * input.getRs() / input.getXs());
        TraceHelper.exit(VNAMarkerMathResult.class, "execute");
        return rc;
    }
}

