/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.importers;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import krause.common.exception.ProcessingException;
import krause.util.ras.logging.ErrorLogHelper;
import krause.util.ras.logging.TraceHelper;
import krause.vna.importers.SnPInfoBlock;
import krause.vna.importers.SnPRecord;
import org.apache.commons.math.complex.Complex;

public class SnPImporter {
    private Map<String, SnPInfoBlock.PARAMETER> PARAMETER_MAP = new HashMap<String, SnPInfoBlock.PARAMETER>();
    private Map<String, SnPInfoBlock.FORMAT> FORMAT_MAP = new HashMap<String, SnPInfoBlock.FORMAT>();

    public SnPImporter() {
        this.PARAMETER_MAP.put("S", SnPInfoBlock.PARAMETER.S);
        this.PARAMETER_MAP.put("Y", SnPInfoBlock.PARAMETER.Y);
        this.PARAMETER_MAP.put("Z", SnPInfoBlock.PARAMETER.Z);
        this.PARAMETER_MAP.put("H", SnPInfoBlock.PARAMETER.H);
        this.PARAMETER_MAP.put("G", SnPInfoBlock.PARAMETER.G);
        this.FORMAT_MAP.put("DB", SnPInfoBlock.FORMAT.DB);
        this.FORMAT_MAP.put("MA", SnPInfoBlock.FORMAT.MA);
        this.FORMAT_MAP.put("RI", SnPInfoBlock.FORMAT.RI);
    }

    private SnPRecord analyseDataLine(SnPInfoBlock infoblock, String line) {
        SnPRecord rc = null;
        TraceHelper.entry(this, "analyseDataLine");
        String[] parts = line.toUpperCase().split("\\s+");
        if (parts.length > 1) {
            rc = new SnPRecord();
            double freq = Double.parseDouble(parts[0]);
            rc.setFrequency((long)(freq * (double)infoblock.getFrequencyMultiplier()));
            int pairs = (parts.length - 1) / 2;
            int i = 0;
            while (i < pairs) {
                double loss = Double.parseDouble(parts[1 + 2 * i]);
                double phase = Double.parseDouble(parts[2 + 2 * i]);
                rc.getLoss()[i] = loss;
                rc.getPhase()[i] = phase;
                ++i;
            }
            i = pairs;
            while (i < 4) {
                rc.getLoss()[i] = Double.NaN;
                rc.getPhase()[i] = Double.NaN;
                ++i;
            }
        }
        TraceHelper.exit(this, "analyseDataLine");
        return rc;
    }

    private int analyseOptionLine(SnPInfoBlock infoBlock, String line) {
        int rc = 99;
        TraceHelper.entry(this, "analyseOptionLine");
        String[] parts = line.toUpperCase().split("\\s+");
        if (parts.length == 6) {
            if ("GHZ".equals(parts[1])) {
                infoBlock.setFrequencyMultiplier(1000000000L);
            } else if ("MHZ".equals(parts[1])) {
                infoBlock.setFrequencyMultiplier(1000000L);
            } else if ("KHZ".equals(parts[1])) {
                infoBlock.setFrequencyMultiplier(1000L);
            } else {
                infoBlock.setFrequencyMultiplier(1L);
            }
            infoBlock.setParameter(this.PARAMETER_MAP.get(parts[2]));
            infoBlock.setFormat(this.FORMAT_MAP.get(parts[3]));
            infoBlock.setReference(new Complex(Double.parseDouble(parts[5]), 0.0));
            rc = 1;
        }
        TraceHelper.exit(this, "analyseOptionLine");
        return rc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SnPInfoBlock readFile(String filename, String encoding) throws ProcessingException {
        SnPInfoBlock rc = null;
        TraceHelper.entry(this, "readFile");
        Scanner scanner = null;
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(filename);
                scanner = new Scanner((InputStream)fis, encoding);
                rc = new SnPInfoBlock();
                rc.setFilename(filename);
                int state = 0;
                block14: while (scanner.hasNextLine() && state != 99) {
                    String line = scanner.nextLine();
                    TraceHelper.text(this, "readFile", String.valueOf(state) + "::" + line);
                    line = line.trim();
                    if (line.length() == 0) continue;
                    switch (state) {
                        case 0: {
                            if (line.startsWith("!")) {
                                state = 0;
                                if (rc.getComment() == null) {
                                    rc.setComment(line);
                                    break;
                                }
                                rc.setComment(String.valueOf(rc.getComment()) + line);
                                break;
                            }
                            if (!line.startsWith("#")) continue block14;
                            state = this.analyseOptionLine(rc, line);
                            break;
                        }
                        case 1: {
                            SnPRecord inpRec = this.analyseDataLine(rc, line);
                            if (inpRec != null) {
                                rc.getRecords().add(inpRec);
                                break;
                            }
                            state = 99;
                            break;
                        }
                        case 99: {
                            throw new ProcessingException("Illegal file format");
                        }
                    }
                }
            }
            catch (FileNotFoundException e) {
                ErrorLogHelper.exception(this, "readFile", e);
                throw new ProcessingException(e);
            }
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    ErrorLogHelper.exception(this, "readFile", e);
                }
            }
        }
        TraceHelper.exit(this, "readFile");
        return rc;
    }
}

