/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.gui.util;

import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JTextField;
import krause.util.ras.logging.ErrorLogHelper;
import krause.util.ras.logging.TraceHelper;
import krause.vna.gui.util.RangeCheckInputVerifier;

public class RangeCheckedTextField
extends JTextField
implements FocusListener {
    public static final int MAX_LEN = 9;
    public static final Dimension DEFAULT_SIZE = new Dimension(100, 20);
    private double lowerLimit = 1000000.0;
    private double upperLimit = 1.0E8;
    private boolean validData = false;
    private NumberFormat formatToUse = null;

    public RangeCheckedTextField() {
        this.setHorizontalAlignment(11);
        this.setMinimumSize(DEFAULT_SIZE);
        this.setMaximumSize(this.getMinimumSize());
        this.setPreferredSize(this.getMinimumSize());
        this.formatToUse = NumberFormat.getIntegerInstance();
        this.formatToUse.setGroupingUsed(true);
        this.formatToUse.setMaximumFractionDigits(0);
        this.formatToUse.setMinimumFractionDigits(0);
        this.formatToUse.setMaximumIntegerDigits(12);
        this.formatToUse.setMinimumIntegerDigits(1);
        this.setInputVerifier(new RangeCheckInputVerifier(this.formatToUse));
        this.addFocusListener(this);
    }

    public RangeCheckedTextField(NumberFormat fmt) {
        this.setHorizontalAlignment(11);
        this.setMinimumSize(DEFAULT_SIZE);
        this.setMaximumSize(this.getMinimumSize());
        this.setPreferredSize(this.getMinimumSize());
        this.formatToUse = fmt;
        this.setInputVerifier(new RangeCheckInputVerifier(this.formatToUse));
        this.addFocusListener(this);
    }

    public void setLowerLimit(double lowerLimit) {
        this.lowerLimit = lowerLimit;
    }

    public void setUpperLimit(double upperLimit) {
        this.upperLimit = upperLimit;
    }

    public double getLowerLimit() {
        return this.lowerLimit;
    }

    public double getUpperLimit() {
        return this.upperLimit;
    }

    public void setValue(double f) {
        this.setText(NumberFormat.getNumberInstance().format(f));
    }

    public double getValue() {
        double rc = 0.0;
        try {
            rc = NumberFormat.getNumberInstance().parse(this.getText()).doubleValue();
        }
        catch (ParseException e) {
            ErrorLogHelper.exception(this, "getValue", e);
        }
        return rc;
    }

    @Override
    public void focusGained(FocusEvent e) {
        TraceHelper.entry(this, "focusGained");
        RangeCheckedTextField tf = (RangeCheckedTextField)e.getComponent();
        tf.select(0, 999);
        TraceHelper.exit(this, "focusGained");
    }

    @Override
    public void focusLost(FocusEvent e) {
        TraceHelper.entry(this, "focusLost");
        TraceHelper.exit(this, "focusLost");
    }

    public boolean isValidData() {
        return this.validData;
    }

    public void setValidData(boolean validData) {
        this.validData = validData;
    }
}

