/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.gui.update;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import krause.util.ras.logging.TraceHelper;
import krause.vna.resources.VNAMessages;
import krause.vna.update.FileDownloadJob;

public class VNAUpdateTableModel
extends AbstractTableModel {
    private List<FileDownloadJob> jobs = new ArrayList<FileDownloadJob>();
    private String[] columnNames = new String[]{VNAMessages.getString("VNAUpdateTableModel.filename"), VNAMessages.getString("VNAUpdateTableModel.filesize"), VNAMessages.getString("VNAUpdateTableModel.status")};

    @Override
    public int getRowCount() {
        return this.jobs.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        int s;
        Object rc = "";
        FileDownloadJob job = this.jobs.get(rowIndex);
        rc = columnIndex == 0 ? job.getFile().getLocalFileName() : (columnIndex == 1 ? new Long(job.getFile().getFileSize()) : (columnIndex == 2 ? ((s = job.getStatus()) == -1 ? "New" : (s == 0 ? "Downloading ..." : (s == 1 ? "OK" : (s == 3 ? "Abort" : (s == 2 ? "Error" : "???"))))) : "???"));
        return rc;
    }

    public List<FileDownloadJob> getJobs() {
        return this.jobs;
    }

    public void addElement(FileDownloadJob block) {
        this.jobs.add(block);
        this.fireTableDataChanged();
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    public void clear() {
        this.jobs.clear();
        this.fireTableDataChanged();
    }

    public void updateElement(FileDownloadJob job) {
        TraceHelper.entry(this, "updateElement");
        this.fireTableDataChanged();
        TraceHelper.exit(this, "updateElement");
    }
}

