/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.gui.smith;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import krause.common.gui.KrauseDialog;
import krause.util.ras.logging.ErrorLogHelper;
import krause.util.ras.logging.TraceHelper;
import krause.vna.config.VNAConfig;
import krause.vna.data.calibrated.VNACalibratedSampleBlock;
import krause.vna.gui.VNAMainFrame;
import krause.vna.gui.input.ComplexInputFieldValueChangeListener;
import krause.vna.gui.panels.marker.VNAMarker;
import krause.vna.gui.panels.marker.VNAMarkerPanel;
import krause.vna.gui.smith.SelectedSampleTuple;
import krause.vna.gui.smith.SmithDataCurve;
import krause.vna.gui.smith.SmithPanel;
import krause.vna.gui.smith.SmithPanelDataSupplier;
import krause.vna.gui.util.SwingUtil;
import krause.vna.resources.VNAMessages;
import org.apache.commons.math.complex.Complex;
import org.jfree.ui.ExtensionFileFilter;

public class VNASyncedSmithDiagramDialog
extends KrauseDialog
implements WindowListener,
ActionListener,
SmithPanelDataSupplier,
ComplexInputFieldValueChangeListener {
    private VNAConfig config = VNAConfig.getSingleton();
    private static final String RAW_EXTENSION = "gif";
    private static final String RAW_DESCRIPTION = "GIF images (*.gif)";
    private SmithDataCurve dataCurve = null;
    private SmithPanel smithDiagram;
    private VNAMainFrame mainFrame = null;
    private VNACalibratedSampleBlock lastDataReceived = null;

    public VNASyncedSmithDiagramDialog(VNAMainFrame pMainFrame) {
        super(false);
        TraceHelper.entry(this, "VNASyncedSmithDiagramDialog");
        this.setConfigurationPrefix("VNASyncedSmithDiagramDialog");
        this.setProperties(VNAConfig.getSingleton());
        this.setDefaultCloseOperation(0);
        this.mainFrame = pMainFrame;
        this.setTitle(VNAMessages.getString("Dlg.SyncedSmith.Title"));
        this.setResizable(true);
        this.setPreferredSize(new Dimension(600, 600));
        this.getContentPane().add(this.createButtonPanel(), "South");
        this.getContentPane().add((Component)this.createSmithPanel(), "Center");
        this.doInit();
        TraceHelper.exit(this, "VNASyncedSmithDiagramDialog");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        TraceHelper.entry((Object)this, "actionPerformed", cmd);
        if (VNAMessages.getString("Button.Save.GIF.Command").equals(cmd)) {
            this.doExportToImage();
        }
        TraceHelper.exit(this, "actionPerformed");
    }

    public void consumeCalibratedData(VNACalibratedSampleBlock currentData) {
        TraceHelper.entry(this, "consumeCalibratedData");
        this.lastDataReceived = currentData;
        if (this.lastDataReceived != null && this.lastDataReceived.getCalibratedSamples().length > 0) {
            this.dataCurve = this.smithDiagram.createDataCurve(this.lastDataReceived.getCalibratedSamples());
            this.smithDiagram.repaint();
        }
        TraceHelper.exit(this, "consumeCalibratedData");
    }

    private Component createButtonPanel() {
        TraceHelper.entry(this, "createButtonPanel");
        JPanel pnlButton = new JPanel();
        pnlButton.add(SwingUtil.createJButton("Button.Save.GIF", this));
        TraceHelper.exit(this, "createButtonPanel");
        return pnlButton;
    }

    private JPanel createSmithPanel() {
        TraceHelper.entry(this, "createSmithPanel");
        JPanel rc = new JPanel();
        rc.setLayout(new BorderLayout());
        this.smithDiagram = new SmithPanel(this);
        rc.add((Component)this.smithDiagram, "Center");
        TraceHelper.exit(this, "createSmithPanel");
        return rc;
    }

    @Override
    public void dispose() {
        TraceHelper.entry(this, "dispose");
        super.dispose();
        TraceHelper.exit(this, "dispose");
    }

    @Override
    protected void doCANCEL() {
        TraceHelper.entry(this, "doCANCEL");
        TraceHelper.exit(this, "doCANCEL");
    }

    private void doExportToImage() {
        block15: {
            JFileChooser fc = new JFileChooser();
            fc.setFileSelectionMode(0);
            fc.setFileFilter((FileFilter)new ExtensionFileFilter(RAW_DESCRIPTION, RAW_EXTENSION));
            fc.setSelectedFile(new File(String.valueOf(this.config.getExportDirectory()) + "/."));
            int returnVal = fc.showSaveDialog(this);
            if (returnVal == 0) {
                String msg;
                int response;
                File file = fc.getSelectedFile();
                if (!file.getName().endsWith(".gif")) {
                    file = new File(String.valueOf(file.getAbsolutePath()) + "." + RAW_EXTENSION);
                }
                if (file.exists() && (response = JOptionPane.showOptionDialog(this, msg = MessageFormat.format(VNAMessages.getString("Message.Export.1"), file.getName()), VNAMessages.getString("Message.Export.2"), 0, 3, null, null, null)) == 2) {
                    return;
                }
                Dimension size = this.smithDiagram.getSize();
                BufferedImage smithImage = new BufferedImage(size.width, size.height, 1);
                Graphics2D g2 = smithImage.createGraphics();
                this.smithDiagram.paint(g2);
                FileOutputStream outputStream = null;
                try {
                    try {
                        outputStream = new FileOutputStream(file.getAbsolutePath());
                        ImageIO.write((RenderedImage)smithImage, RAW_EXTENSION, outputStream);
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(this, e.getMessage(), VNAMessages.getString("Message.Export.2"), 0);
                        ErrorLogHelper.exception(this, "doExportToJPG", e);
                        if (outputStream == null) break block15;
                        try {
                            ((OutputStream)outputStream).close();
                        }
                        catch (IOException e2) {
                            ErrorLogHelper.exception(this, "doExportToJPG", e2);
                        }
                    }
                }
                finally {
                    if (outputStream != null) {
                        try {
                            ((OutputStream)outputStream).close();
                        }
                        catch (IOException e) {
                            ErrorLogHelper.exception(this, "doExportToJPG", e);
                        }
                    }
                }
            }
        }
    }

    @Override
    protected void doInit() {
        TraceHelper.entry(this, "doInit");
        this.doShow();
        TraceHelper.exit(this, "doInit");
    }

    @Override
    public SmithDataCurve getDataCurve() {
        return this.dataCurve;
    }

    @Override
    public SelectedSampleTuple[] getSelectedTuples() {
        VNAMarker[] markers;
        TraceHelper.entry(this, "getSelectedTuples");
        ArrayList<SelectedSampleTuple> tuples = new ArrayList<SelectedSampleTuple>();
        VNAMarkerPanel mp = this.mainFrame.getMarkerPanel();
        VNAMarker[] vNAMarkerArray = markers = mp.getMarkers();
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            VNAMarker marker = vNAMarkerArray[n2];
            if (marker.isVisible()) {
                SelectedSampleTuple t = new SelectedSampleTuple(marker.getSample().getDiagramX(), this.config.getColorMarker(1), marker.getShortName());
                tuples.add(t);
            }
            ++n2;
        }
        TraceHelper.exit(this, "getSelectedTuples");
        return tuples.toArray(new SelectedSampleTuple[tuples.size()]);
    }

    @Override
    public void valueChanged(Complex oldValue, Complex newValue) {
        TraceHelper.entry(this, "valueChanged");
        this.consumeCalibratedData(this.lastDataReceived);
        TraceHelper.exit(this, "valueChanged");
    }

    @Override
    public void windowClosing(WindowEvent e) {
        TraceHelper.entry(this, "windowClosing");
        this.mainFrame.getDiagramPanel().getScaleSelectPanel().doHandleSmithDiagram();
        TraceHelper.exit(this, "windowClosing");
    }
}

