/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.gui.smith;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import krause.common.gui.KrauseDialog;
import krause.util.ras.logging.TraceHelper;
import krause.vna.config.VNAConfig;
import krause.vna.gui.input.ComplexInputField;
import krause.vna.gui.input.ComplexInputFieldValueChangeListener;
import krause.vna.gui.util.SwingUtil;
import krause.vna.resources.VNAMessages;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.math.complex.Complex;

public class VNASmithDiagramConfigDialog
extends KrauseDialog
implements ComplexInputFieldValueChangeListener,
MouseListener {
    private VNAConfig config = VNAConfig.getSingleton();
    private JCheckBox cbRL;
    private JCheckBox cbRS;
    private JCheckBox cbXS;
    private JCheckBox cbZ;
    private JCheckBox cbPHASE;
    private ComplexInputField referenceResistance;
    private JTextField txtColBackground;
    private JTextField txtColText;
    private JTextField txtColLines;
    private JTextField txtColData;
    private JTextField txtColMarker;
    private JTextField txtColSWR2_1;
    private JTextField txtColSWR3_1;
    private JCheckBox cbMag;
    private AbstractButton cbSWR;

    public VNASmithDiagramConfigDialog() {
        super(true);
        TraceHelper.entry(this, "VNASmithDiagramConfigDialog");
        this.setConfigurationPrefix("VNASmithDiagramConfigDialog");
        this.setProperties(VNAConfig.getSingleton());
        this.setDefaultCloseOperation(0);
        this.setTitle(VNAMessages.getString("VNASmithDiagramConfigDialog.title"));
        this.setResizable(true);
        this.setPreferredSize(new Dimension(580, 500));
        this.getContentPane().setLayout((LayoutManager)new MigLayout("", "", ""));
        this.getContentPane().add((Component)this.createCenterPanel(), "grow,wrap");
        this.getContentPane().add(this.createButtonPanel(), "grow,wrap");
        this.doInit();
        TraceHelper.exit(this, "VNASmithDiagramConfigDialog");
    }

    private Component createButtonPanel() {
        TraceHelper.entry(this, "createButtonPanel");
        JPanel pnlButton = new JPanel();
        pnlButton.add((Component)SwingUtil.createJButton("VNASmithDiagramConfigDialog.invert", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VNASmithDiagramConfigDialog.this.doInvert();
            }
        }), "grow,wrap");
        pnlButton.add(SwingUtil.createJButton("Button.Default", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VNASmithDiagramConfigDialog.this.doDefaults();
            }
        }));
        pnlButton.add(SwingUtil.createJButton("Button.Cancel", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VNASmithDiagramConfigDialog.this.doCANCEL();
            }
        }));
        pnlButton.add(SwingUtil.createJButton("Button.OK", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VNASmithDiagramConfigDialog.this.doOK();
            }
        }));
        TraceHelper.exit(this, "createButtonPanel");
        return pnlButton;
    }

    private JPanel createCenterPanel() {
        TraceHelper.entry(this, "createCenterPanel");
        JPanel rc = new JPanel((LayoutManager)new MigLayout("", "[grow,fill]", ""));
        JPanel pnlMarkerOpt = new JPanel();
        pnlMarkerOpt.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), VNAMessages.getString("VNASmithDiagramConfigDialog.markers"), 4, 2, null, new Color(0, 0, 0)));
        this.cbRL = SwingUtil.createJCheckbox("Marker.RL", null);
        pnlMarkerOpt.add(this.cbRL);
        this.cbPHASE = SwingUtil.createJCheckbox("Marker.PhaseRL", null);
        pnlMarkerOpt.add(this.cbPHASE);
        this.cbZ = SwingUtil.createJCheckbox("Marker.Z", null);
        pnlMarkerOpt.add(this.cbZ);
        this.cbRS = SwingUtil.createJCheckbox("Marker.R", null);
        pnlMarkerOpt.add(this.cbRS);
        this.cbXS = SwingUtil.createJCheckbox("Marker.X", null);
        pnlMarkerOpt.add(this.cbXS);
        this.cbSWR = SwingUtil.createJCheckbox("Marker.SWR", null);
        pnlMarkerOpt.add(this.cbSWR);
        this.cbMag = SwingUtil.createJCheckbox("Marker.Magnitude", null);
        pnlMarkerOpt.add(this.cbMag);
        this.cbRL.setToolTipText(null);
        this.cbPHASE.setToolTipText(null);
        this.cbZ.setToolTipText(null);
        this.cbRS.setToolTipText(null);
        this.cbXS.setToolTipText(null);
        this.cbSWR.setToolTipText(null);
        this.cbMag.setToolTipText(null);
        JPanel pnlRefRes = new JPanel();
        pnlRefRes.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), VNAMessages.getString("VNASmithDiagramConfigDialog.reference"), 4, 2, null, new Color(0, 0, 0)));
        this.referenceResistance = new ComplexInputField(this.config.getSmithReference());
        this.referenceResistance.setMaximum(new Complex(5000.0, 5000.0));
        this.referenceResistance.setMinimum(new Complex(-5000.0, -5000.0));
        this.referenceResistance.setListener(this);
        pnlRefRes.add(this.referenceResistance);
        JPanel pnlColors = new JPanel((LayoutManager)new MigLayout("", "[grow,fill][][]", "[][][][][][][]"));
        pnlColors.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), VNAMessages.getString("VNASmithDiagramConfigDialog.colors"), 4, 2, null, new Color(0, 0, 0)));
        this.txtColBackground = this.createColorSelectField(pnlColors, "VNASmithDiagramConfigDialog.backColor", this);
        this.txtColText = this.createColorSelectField(pnlColors, "VNASmithDiagramConfigDialog.textColor", this);
        this.txtColLines = this.createColorSelectField(pnlColors, "VNASmithDiagramConfigDialog.lineColor", this);
        this.txtColData = this.createColorSelectField(pnlColors, "VNASmithDiagramConfigDialog.dataColor", this);
        this.txtColMarker = this.createColorSelectField(pnlColors, "VNASmithDiagramConfigDialog.markerColor", this);
        this.txtColSWR2_1 = this.createColorSelectField(pnlColors, "VNASmithDiagramConfigDialog.markerSWR2_1", this);
        this.txtColSWR3_1 = this.createColorSelectField(pnlColors, "VNASmithDiagramConfigDialog.markerSWR3_1", this);
        rc.add((Component)pnlMarkerOpt, "wrap,grow");
        rc.add((Component)pnlRefRes, "wrap,grow");
        rc.add((Component)pnlColors, "wrap,grow");
        TraceHelper.exit(this, "createCenterPanel");
        return rc;
    }

    private JTextField createColorSelectField(JPanel panel, String id, MouseListener mouseListener) {
        TraceHelper.entry(this, "createColorSelectField");
        JLabel lbl = new JLabel(VNAMessages.getString(id));
        panel.add((Component)lbl, "");
        JTextField rc = new JTextField(10);
        rc.setBorder(new BevelBorder(1, null, null, null, null));
        rc.setEditable(false);
        rc.setOpaque(true);
        rc.setForeground(Color.BLACK);
        rc.addMouseListener(mouseListener);
        rc.setToolTipText(VNAMessages.getString("VNASmithDiagramConfigDialog.clickToSelect"));
        panel.add((Component)rc, "width 40,wrap");
        TraceHelper.exit(this, "createColorSelectField");
        return rc;
    }

    @Override
    protected void doCANCEL() {
        TraceHelper.entry(this, "doCANCEL");
        this.dispose();
        TraceHelper.exit(this, "doCANCEL");
    }

    protected void doDefaults() {
        TraceHelper.entry(this, "doDefaults");
        this.cbZ.setSelected(true);
        this.cbRS.setSelected(true);
        this.cbXS.setSelected(true);
        this.cbRL.setSelected(true);
        this.cbPHASE.setSelected(true);
        this.cbMag.setSelected(true);
        this.referenceResistance.setComplexValue(new Complex(50.0, 0.0));
        this.txtColText.setBackground(Color.WHITE);
        this.txtColLines.setBackground(Color.GRAY);
        this.txtColData.setBackground(Color.GREEN);
        this.txtColBackground.setBackground(Color.BLACK);
        this.txtColMarker.setBackground(Color.YELLOW);
        this.txtColSWR2_1.setBackground(Color.CYAN);
        this.txtColSWR3_1.setBackground(Color.CYAN);
        TraceHelper.exit(this, "doDefaults");
    }

    @Override
    protected void doInit() {
        TraceHelper.entry(this, "doInit");
        this.cbMag.setSelected(this.config.getBoolean("SmithPanel.showMarker.Mag", true));
        this.cbPHASE.setSelected(this.config.getBoolean("SmithPanel.showMarker.Phase", true));
        this.cbRL.setSelected(this.config.getBoolean("SmithPanel.showMarker.RL", true));
        this.cbRS.setSelected(this.config.getBoolean("SmithPanel.showMarker.RS", true));
        this.cbXS.setSelected(this.config.getBoolean("SmithPanel.showMarker.XS", true));
        this.cbZ.setSelected(this.config.getBoolean("SmithPanel.showMarker.Z", true));
        this.cbSWR.setSelected(this.config.getBoolean("SmithPanel.showMarker.SWR", true));
        this.referenceResistance.setComplexValue(this.config.getSmithReference());
        this.txtColText.setBackground(this.config.getColor("SmithPanel.colText", Color.WHITE));
        this.txtColLines.setBackground(this.config.getColor("SmithPanel.colLines", Color.GRAY));
        this.txtColData.setBackground(this.config.getColor("SmithPanel.colData", Color.GREEN));
        this.txtColBackground.setBackground(this.config.getColor("SmithPanel.colBackground", Color.BLACK));
        this.txtColMarker.setBackground(this.config.getColor("SmithPanel.colMarker", Color.YELLOW));
        this.txtColSWR2_1.setBackground(this.config.getColor("SmithPanel.colSWR2_1", Color.CYAN));
        this.txtColSWR3_1.setBackground(this.config.getColor("SmithPanel.colSWR3_1", Color.CYAN));
        this.addEscapeKey();
        this.doShow();
        TraceHelper.exit(this, "doInit");
    }

    protected void doInvert() {
        TraceHelper.entry(this, "doInvert");
        this.invertBackgroundColor(this.txtColBackground);
        this.invertBackgroundColor(this.txtColData);
        this.invertBackgroundColor(this.txtColLines);
        this.invertBackgroundColor(this.txtColMarker);
        this.invertBackgroundColor(this.txtColText);
        this.invertBackgroundColor(this.txtColSWR2_1);
        this.invertBackgroundColor(this.txtColSWR3_1);
        TraceHelper.exit(this, "doInvert");
    }

    private void invertBackgroundColor(JTextField tf) {
        tf.setBackground(new Color(~tf.getBackground().getRGB()));
    }

    protected void doOK() {
        TraceHelper.entry(this, "doOK");
        this.config.putBoolean("SmithPanel.showMarker.Mag", this.cbMag.isSelected());
        this.config.putBoolean("SmithPanel.showMarker.Phase", this.cbPHASE.isSelected());
        this.config.putBoolean("SmithPanel.showMarker.RL", this.cbRL.isSelected());
        this.config.putBoolean("SmithPanel.showMarker.RS", this.cbRS.isSelected());
        this.config.putBoolean("SmithPanel.showMarker.XS", this.cbXS.isSelected());
        this.config.putBoolean("SmithPanel.showMarker.Z", this.cbZ.isSelected());
        this.config.putBoolean("SmithPanel.showMarker.SWR", this.cbSWR.isSelected());
        Complex oldRes = this.config.getSmithReference();
        Complex newRes = this.referenceResistance.getComplexValue();
        if (!oldRes.equals((Object)newRes)) {
            JOptionPane.showMessageDialog(this, VNAMessages.getString("SmithPanel.1"), this.getTitle(), 1);
        }
        this.config.setSmithReference(newRes);
        this.config.putColor("SmithPanel.colText", this.txtColText.getBackground());
        this.config.putColor("SmithPanel.colLines", this.txtColLines.getBackground());
        this.config.putColor("SmithPanel.colData", this.txtColData.getBackground());
        this.config.putColor("SmithPanel.colBackground", this.txtColBackground.getBackground());
        this.config.putColor("SmithPanel.colMarker", this.txtColMarker.getBackground());
        this.config.putColor("SmithPanel.colSWR2_1", this.txtColSWR2_1.getBackground());
        this.config.putColor("SmithPanel.colSWR3_1", this.txtColSWR3_1.getBackground());
        this.doCANCEL();
        TraceHelper.exit(this, "doOK");
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        JTextField tf = (JTextField)e.getComponent();
        tf.setBackground(JColorChooser.showDialog(this.getOwner(), VNAMessages.getString("ColorDialog.select"), tf.getBackground()));
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void valueChanged(Complex oldValue, Complex newValue) {
        TraceHelper.entry(this, "valueChanged");
        TraceHelper.exit(this, "valueChanged");
    }
}

