/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.gui.smith;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import krause.util.ras.logging.TraceHelper;
import krause.vna.config.VNAConfig;
import krause.vna.data.calibrated.VNACalibratedSample;
import krause.vna.gui.smith.SelectedSampleTuple;
import krause.vna.gui.smith.SmithDataCurve;
import krause.vna.gui.smith.SmithDiagramCurve;
import krause.vna.gui.smith.SmithPanelDataSupplier;
import krause.vna.gui.smith.VNASmithDiagramConfigDialog;
import krause.vna.resources.VNAMessages;
import org.apache.commons.math.complex.Complex;

public class SmithPanel
extends JPanel {
    public static final Complex PLUS_1 = new Complex(1.0, 0.0);
    public static final Complex PLUS_50 = new Complex(50.0, 0.0);
    public static final int FACTOR2_1 = 666;
    public static final int FACTOR3_1 = 1000;
    public static final String versionText = VNAMessages.getString("Application.version");
    public static final String copyrightText = VNAMessages.getString("Application.copyright");
    private Complex referenceResistance = PLUS_50;
    private SmithPanelDataSupplier dataSupplier;
    private AffineTransform transformTranslate;
    private AffineTransform transformScale;
    private VNAConfig config = VNAConfig.getSingleton();
    private final Font textFont = new Font("Courier", 1, 15);
    private List<SmithDiagramCurve> realCurves = new ArrayList<SmithDiagramCurve>();
    private List<SmithDiagramCurve> imaginaryCurves = new ArrayList<SmithDiagramCurve>();
    private Color colText;
    private Color colLines;
    private Color colData;
    private Color colBackground;
    private Color colMarker;
    private Color colSWR2_1;
    private Color colSWR3_1;
    private boolean showPhase;
    private boolean showRL;
    private boolean showRS;
    private boolean showXS;
    private boolean showZ;
    private boolean showMag;
    private boolean showSwr;

    public SmithPanel(SmithPanelDataSupplier pDataSupplier) {
        this.dataSupplier = pDataSupplier;
        this.calculateSmithChart();
        this.setBounds(0, 0, 250, 250);
        this.readConfig();
        this.setBackground(this.colBackground);
        this.setToolTipText(VNAMessages.getString("SmithPanel.tooltip"));
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                SmithPanel.this.doConfig();
            }
        });
    }

    private void readConfig() {
        TraceHelper.entry(this, "readConfig");
        this.colText = this.config.getColor("SmithPanel.colText", Color.WHITE);
        this.colLines = this.config.getColor("SmithPanel.colLines", Color.GRAY);
        this.colData = this.config.getColor("SmithPanel.colData", Color.GREEN);
        this.colBackground = this.config.getColor("SmithPanel.colBackground", Color.BLACK);
        this.colMarker = this.config.getColor("SmithPanel.colMarker", Color.YELLOW);
        this.colSWR2_1 = this.config.getColor("SmithPanel.colSWR2_1", Color.CYAN);
        this.colSWR3_1 = this.config.getColor("SmithPanel.colSWR3_1", Color.CYAN);
        this.referenceResistance = this.config.getSmithReference();
        this.showPhase = this.config.getBoolean("SmithPanel.showMarker.Phase", true);
        this.showRL = this.config.getBoolean("SmithPanel.showMarker.RL", true);
        this.showRS = this.config.getBoolean("SmithPanel.showMarker.RS", true);
        this.showXS = this.config.getBoolean("SmithPanel.showMarker.XS", true);
        this.showZ = this.config.getBoolean("SmithPanel.showMarker.Z", true);
        this.showMag = this.config.getBoolean("SmithPanel.showMarker.Mag", true);
        this.showSwr = this.config.getBoolean("SmithPanel.showMarker.SWR", true);
        TraceHelper.exit(this, "readConfig");
    }

    protected void doConfig() {
        TraceHelper.entry(this, "doConfig");
        new VNASmithDiagramConfigDialog();
        this.readConfig();
        this.repaint();
        TraceHelper.exit(this, "doConfig");
    }

    private void calculateSmithChart() {
        TraceHelper.entry(this, "calculateSmithChart");
        this.realCurves.add(this.createCircle4Real(0.0));
        this.realCurves.add(this.createCircle4Real(0.2));
        this.realCurves.add(this.createCircle4Real(0.5));
        this.realCurves.add(this.createCircle4Real(1.0));
        this.realCurves.add(this.createCircle4Real(2.0));
        this.realCurves.add(this.createCircle4Real(5.0));
        this.imaginaryCurves.add(this.createCircle4Imaginary(-5.0));
        this.imaginaryCurves.add(this.createCircle4Imaginary(-2.0));
        this.imaginaryCurves.add(this.createCircle4Imaginary(-1.0));
        this.imaginaryCurves.add(this.createCircle4Imaginary(-0.5));
        this.imaginaryCurves.add(this.createCircle4Imaginary(-0.2));
        this.imaginaryCurves.add(this.createCircle4Imaginary(0.0));
        this.imaginaryCurves.add(this.createCircle4Imaginary(0.2));
        this.imaginaryCurves.add(this.createCircle4Imaginary(0.5));
        this.imaginaryCurves.add(this.createCircle4Imaginary(1.0));
        this.imaginaryCurves.add(this.createCircle4Imaginary(2.0));
        this.imaginaryCurves.add(this.createCircle4Imaginary(5.0));
        TraceHelper.exit(this, "calculateSmithChart");
    }

    public SmithDiagramCurve createCircle4Imaginary(double imaginary) {
        int py;
        int px;
        Complex gamma;
        Complex comp;
        SmithDiagramCurve rc = new SmithDiagramCurve();
        rc.setLabel(NumberFormat.getNumberInstance().format(imaginary));
        rc.setRealCurve(false);
        double x = 0.0;
        while (x < 10.0) {
            comp = new Complex(x, imaginary);
            gamma = this.mGamma(comp);
            px = (int)(gamma.getReal() * 1000.0);
            py = (int)(gamma.getImaginary() * 1000.0);
            rc.addPoint(px, -py);
            x += 0.1;
        }
        x = 10.0;
        while (x < 100.0) {
            comp = new Complex(x, imaginary);
            gamma = this.mGamma(comp);
            px = (int)(gamma.getReal() * 1000.0);
            py = (int)(gamma.getImaginary() * 1000.0);
            rc.addPoint(px, -py);
            x += 0.5;
        }
        return rc;
    }

    public SmithDiagramCurve createCircle4Real(double real) {
        int py;
        int px;
        Complex gamma;
        Complex comp;
        SmithDiagramCurve rc = new SmithDiagramCurve();
        rc.setLabel(NumberFormat.getNumberInstance().format(real));
        rc.setRealCurve(false);
        double x = -100.0;
        while (x < -10.0) {
            comp = new Complex(real, x);
            gamma = this.mGamma(comp);
            px = (int)(gamma.getReal() * 1000.0);
            py = (int)(gamma.getImaginary() * 1000.0);
            rc.addPoint(px, -py);
            x += 0.5;
        }
        x = -10.0;
        while (x < 10.0) {
            comp = new Complex(real, x);
            gamma = this.mGamma(comp);
            px = (int)(gamma.getReal() * 1000.0);
            py = (int)(gamma.getImaginary() * 1000.0);
            rc.addPoint(px, -py);
            x += 0.1;
        }
        x = 10.0;
        while (x < 100.0) {
            comp = new Complex(real, x);
            gamma = this.mGamma(comp);
            px = (int)(gamma.getReal() * 1000.0);
            py = (int)(gamma.getImaginary() * 1000.0);
            rc.addPoint(px, -py);
            x += 0.5;
        }
        return rc;
    }

    public SmithDataCurve createDataCurve(VNACalibratedSample[] samples) {
        TraceHelper.entry(this, "createDataCurve");
        SmithDataCurve rc = new SmithDataCurve(samples.length);
        rc.setSamples(samples);
        Point2D[] points = new Point2D[samples.length];
        int i = 0;
        while (i < samples.length) {
            VNACalibratedSample sample = samples[i];
            double real = sample.getR();
            if (real < 0.0) {
                real = 0.0;
            }
            double imag = sample.getX();
            Complex comp = new Complex(real, imag);
            Complex gamma = comp.subtract(this.referenceResistance).divide(comp.add(this.referenceResistance));
            Point2D.Double aPoint = new Point2D.Double(gamma.getReal() * 1000.0, -gamma.getImaginary() * 1000.0);
            points[i] = aPoint;
            ++i;
        }
        rc.addPoints(points);
        TraceHelper.exit(this, "createDataCurve");
        return rc;
    }

    private Complex mGamma(Complex z) {
        Complex rc = null;
        rc = z.subtract(PLUS_1).divide(z.add(PLUS_1));
        return rc;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D grafObject = (Graphics2D)g.create();
        g.setColor(this.colBackground);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(this.colText);
        g.setFont(this.textFont);
        g.drawString("L    vna/J " + versionText + "  " + copyrightText, 20, 15);
        g.drawString("C    Ref=" + this.referenceResistance.getReal() + "+" + this.referenceResistance.getImaginary() + "i", 20, this.getHeight() - 10);
        SmithDataCurve curve = this.dataSupplier.getDataCurve();
        SelectedSampleTuple[] tuples = this.dataSupplier.getSelectedTuples();
        this.transformTranslate = AffineTransform.getTranslateInstance(this.getWidth() / 2, this.getHeight() / 2);
        double minVal = (double)Math.min(this.getWidth(), this.getHeight()) * 0.93;
        double scale = minVal / 2000.0;
        Font f = grafObject.getFont().deriveFont((float)(12.0 / scale)).deriveFont(1);
        grafObject.setFont(f);
        this.transformScale = AffineTransform.getScaleInstance(scale, scale);
        grafObject.transform(this.transformTranslate);
        grafObject.transform(this.transformScale);
        for (SmithDiagramCurve polygon : this.realCurves) {
            grafObject.setColor(this.colLines);
            grafObject.drawString(polygon.getLabel(), polygon.xpoints[polygon.npoints / 2], polygon.ypoints[polygon.npoints / 2]);
            grafObject.drawPolyline(polygon.xpoints, polygon.ypoints, polygon.npoints);
        }
        for (SmithDiagramCurve polygon : this.imaginaryCurves) {
            int y = polygon.ypoints[0];
            if (y < 0) {
                y += 50;
            } else if (y > 0) {
                y -= 50;
            }
            grafObject.drawString(polygon.getLabel(), polygon.xpoints[0], y);
            grafObject.drawPolyline(polygon.xpoints, polygon.ypoints, polygon.npoints);
        }
        grafObject.setColor(this.colSWR3_1);
        grafObject.drawOval(-500, -500, 1000, 1000);
        grafObject.setColor(this.colSWR2_1);
        grafObject.drawOval(-333, -333, 666, 666);
        grafObject.setColor(this.colData);
        if (curve != null) {
            Line2D[] lines = curve.getLines();
            int i = 0;
            Line2D[] line2DArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                Line2D line = line2DArray[n2];
                grafObject.draw(line);
                if (tuples != null) {
                    int s = 0;
                    while (s < tuples.length) {
                        if (tuples[s].getIndex() == i) {
                            grafObject.setColor(this.colMarker);
                            grafObject.drawRect((int)line.getX1() - 15, (int)line.getY1() - 15, 30, 30);
                            grafObject.drawString(tuples[s].getName(), (int)line.getX1() - 7, (int)line.getY1() - 20);
                            grafObject.setColor(this.colData);
                        }
                        ++s;
                    }
                }
                ++i;
                ++n2;
            }
            g.setColor(this.colText);
            g.setFont(this.textFont);
            VNACalibratedSample[] samples = curve.getSamples();
            if (samples != null) {
                this.drawInfo1(g, samples);
                if (tuples != null) {
                    this.drawInfo2(g, samples, tuples);
                }
            }
        }
    }

    private void drawInfo2(Graphics g, VNACalibratedSample[] samples, SelectedSampleTuple[] tuples) {
        int index = 0;
        int x = this.getWidth() / 4 * 3;
        int yOffset = 10;
        int yStep = 16;
        SelectedSampleTuple[] selectedSampleTupleArray = tuples;
        int n = tuples.length;
        int n2 = 0;
        while (n2 < n) {
            SelectedSampleTuple tuple = selectedSampleTupleArray[n2];
            VNACalibratedSample sample = samples[tuple.getIndex()];
            g.drawString(String.format("%s: %,12dHz", tuple.getName(), sample.getFrequency()), x, yOffset + yStep * index++);
            if (this.showRL) {
                g.drawString(String.format("    RL %7.2fdB", sample.getReflectionLoss()), x, yOffset + yStep * index++);
            }
            if (this.showPhase) {
                g.drawString(String.format("    RP %7.2f\u00b0", sample.getReflectionPhase()), x, yOffset + yStep * index++);
            }
            if (this.showZ) {
                g.drawString(String.format("    Z  %6.1f\u03a9", sample.getZ()), x, yOffset + yStep * index++);
            }
            if (this.showRS) {
                g.drawString(String.format("    Rs %6.1f\u03a9", sample.getR()), x, yOffset + yStep * index++);
            }
            if (this.showXS) {
                g.drawString(String.format("    Xs %6.1f\u03a9", sample.getX()), x, yOffset + yStep * index++);
            }
            if (this.showSwr) {
                g.drawString(String.format("    Swr %5.1f:1", sample.getSWR()), x, yOffset + yStep * index++);
            }
            if (this.showMag) {
                g.drawString(String.format("    Mag %7.3f", sample.getMag()), x, yOffset + yStep * index++);
            }
            ++n2;
        }
    }

    private void drawInfo1(Graphics g, VNACalibratedSample[] samples) {
        long startFrq = samples[0].getFrequency();
        long stopFrq = samples[samples.length - 1].getFrequency();
        int x = this.getWidth() / 6 * 4;
        g.drawString(String.format("Start %,12dHz", startFrq), x, this.getHeight() - 25);
        g.drawString(String.format("Stop  %,12dHz", stopFrq), x, this.getHeight() - 10);
    }
}

