/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.gui.scollector;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;
import krause.common.exception.ProcessingException;
import krause.common.gui.KrauseDialog;
import krause.util.ras.logging.ErrorLogHelper;
import krause.util.ras.logging.TraceHelper;
import krause.vna.config.VNAConfig;
import krause.vna.data.VNADataPool;
import krause.vna.gui.HelpButton;
import krause.vna.gui.importers.VNASnPDataTable;
import krause.vna.gui.importers.VNASnPDataTableModel;
import krause.vna.gui.util.SwingUtil;
import krause.vna.importers.SnPRecord;
import krause.vna.resources.VNAMessages;
import net.miginfocom.swing.MigLayout;
import org.jfree.ui.ExtensionFileFilter;

public class VNASnPExportDialog
extends KrauseDialog {
    private static final String S2P_EXTENSION = ".s2p";
    private JButton btOK;
    private VNASnPDataTable lstData;
    private SnPRecord[] sRecords;
    private VNAConfig config = VNAConfig.getSingleton();

    public VNASnPExportDialog(Window aFrame, SnPRecord[] pRecords) {
        super(aFrame, true);
        TraceHelper.entry(this, "VNASnPExportDialog");
        this.sRecords = pRecords;
        this.setProperties(VNAConfig.getSingleton());
        this.setConfigurationPrefix("VNASnPExportDialog");
        this.setTitle(VNAMessages.getString("VNASnPExportDialog.title"));
        this.setDefaultCloseOperation(0);
        this.setPreferredSize(new Dimension(800, 600));
        this.getContentPane().setLayout((LayoutManager)new MigLayout("", "[][grow,fill][][]", "[][grow,fill][]"));
        this.getContentPane().add((Component)new JLabel(VNAMessages.getString("VNASnPExportDialog.headline")), "span 4,grow,wrap");
        this.lstData = new VNASnPDataTable();
        JScrollPane scrollPane = new JScrollPane(this.lstData);
        scrollPane.setViewportBorder(null);
        this.getContentPane().add((Component)scrollPane, "span 4,grow,wrap");
        this.getContentPane().add((Component)SwingUtil.createJButton("Button.Cancel", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VNASnPExportDialog.this.doCANCEL();
            }
        }), "left");
        this.getContentPane().add((Component)new JLabel(), "");
        this.getContentPane().add((Component)new HelpButton(this, "VNASnPExportDialog"), "");
        this.btOK = SwingUtil.createJButton("Button.Save", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VNASnPExportDialog.this.doSave();
            }
        });
        this.getContentPane().add((Component)this.btOK, "right");
        this.getRootPane().setDefaultButton(this.btOK);
        this.doInit();
        TraceHelper.exit(this, "VNASnPImportDialog");
    }

    protected void doSave() {
        TraceHelper.entry(this, "doSave");
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(0);
        fc.setFileFilter((FileFilter)new ExtensionFileFilter("S2P files", S2P_EXTENSION));
        fc.setSelectedFile(new File(String.valueOf(this.config.getReferenceDirectory()) + "/."));
        int returnVal = fc.showSaveDialog(this);
        if (returnVal == 0) {
            String msg;
            int response;
            File file = fc.getSelectedFile();
            this.config.setReferenceDirectory(file.getParent());
            if (!file.getName().endsWith(S2P_EXTENSION)) {
                file = new File(String.valueOf(file.getAbsolutePath()) + S2P_EXTENSION);
            }
            if (file.exists() && (response = JOptionPane.showOptionDialog(this, msg = MessageFormat.format(VNAMessages.getString("Message.Export.1"), file.getName()), VNAMessages.getString("Message.Export.2"), 0, 3, null, null, null)) == 2) {
                return;
            }
            try {
                this.exportS2P(file.getAbsolutePath());
            }
            catch (ProcessingException e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), VNAMessages.getString("Message.Export.2"), 0);
                ErrorLogHelper.exception(this, "doExport", e);
            }
            this.setVisible(false);
            this.dispose();
        }
        TraceHelper.exit(this, "doSave");
    }

    @Override
    protected void doCANCEL() {
        TraceHelper.entry(this, "doCANCEL");
        this.setVisible(false);
        this.dispose();
        TraceHelper.exit(this, "doCANCEL");
    }

    @Override
    protected void doInit() {
        TraceHelper.entry(this, "doInit");
        VNASnPDataTableModel model = this.lstData.getModel();
        ArrayList<SnPRecord> recList = new ArrayList<SnPRecord>();
        SnPRecord[] snPRecordArray = this.sRecords;
        int n = this.sRecords.length;
        int n2 = 0;
        while (n2 < n) {
            SnPRecord record = snPRecordArray[n2];
            recList.add(record);
            ++n2;
        }
        model.getData().clear();
        model.getData().addAll(recList);
        model.fireTableDataChanged();
        this.doShow();
        TraceHelper.exit(this, "doInit");
    }

    private void exportS2P(String fnp) throws ProcessingException {
        TraceHelper.entry(this, "exportS2P");
        if (fnp != null) {
            DecimalFormatSymbols dfs = this.getDecimalFormatSymbols();
            DecimalFormat fmtFrequency = new DecimalFormat("000000000", dfs);
            DecimalFormat fmtLoss = new DecimalFormat("0.00000000", dfs);
            DecimalFormat fmtPhase = new DecimalFormat("0.00000000", dfs);
            DecimalFormat fmtReference = new DecimalFormat("0.0", dfs);
            FileOutputStream fos = null;
            Writer w = null;
            try {
                try {
                    fos = new FileOutputStream(fnp);
                    w = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "ISO-8859-1"));
                    w.write("! created by ");
                    w.write(System.getProperty("user.name"));
                    w.write(" at ");
                    w.write(new Date().toString());
                    w.write(System.getProperty("line.separator"));
                    w.write("! generated using vna/J Version ");
                    w.write(VNAMessages.getString("Application.version"));
                    w.write(System.getProperty("line.separator"));
                    w.write("# Hz S DB R ");
                    double real = VNADataPool.getSingleton().getDriver().getDeviceInfoBlock().getReferenceResistance().getReal();
                    w.write(fmtReference.format(real));
                    w.write(System.getProperty("line.separator"));
                    int numSamples = this.sRecords.length;
                    int i = 0;
                    while (i < numSamples) {
                        SnPRecord data = this.sRecords[i];
                        w.write(fmtFrequency.format(data.getFrequency()));
                        w.write(" ");
                        int j = 0;
                        while (j < 4) {
                            w.write(fmtLoss.format(data.getLoss()[j]));
                            w.write(" ");
                            w.write(fmtPhase.format(data.getPhase()[j]));
                            w.write(" ");
                            ++j;
                        }
                        w.write(System.getProperty("line.separator"));
                        ++i;
                    }
                }
                catch (IOException e) {
                    ErrorLogHelper.exception(this, "exportS2P", e);
                    throw new ProcessingException(e);
                }
            }
            finally {
                if (w != null) {
                    try {
                        w.flush();
                        w.close();
                        w = null;
                    }
                    catch (IOException e) {
                        ErrorLogHelper.exception(this, "exportS2P", e);
                    }
                }
                if (fos != null) {
                    try {
                        fos.flush();
                        fos.close();
                        fos = null;
                    }
                    catch (IOException e) {
                        ErrorLogHelper.exception(this, "exportS2P", e);
                    }
                }
            }
        }
        TraceHelper.exit(this, "exportS2P");
    }

    private DecimalFormatSymbols getDecimalFormatSymbols() {
        if (".".equals(this.config.getExportDecimalSeparator())) {
            return new DecimalFormatSymbols(Locale.ENGLISH);
        }
        return new DecimalFormatSymbols(Locale.GERMAN);
    }
}

