/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.gui.scale.values;

import krause.util.ras.logging.TraceHelper;
import krause.vna.config.VNAConfig;
import krause.vna.data.calibrated.VNACalibratedSample;
import krause.vna.device.VNADeviceInfoBlock;
import krause.vna.gui.format.VNAFormatFactory;
import krause.vna.gui.scale.VNAScaleSymbols;
import krause.vna.gui.scale.values.VNALinearScale;
import krause.vna.resources.VNAMessages;

public class VNAZAbsScale
extends VNALinearScale {
    private static final double ABSOLUTE_MIN = 0.0;
    private static final double ABSOLUTE_MAX = 99999.0;
    private static final double DEFAULT_MIN = 0.0;
    private static final double DEFAULT_MAX = 1000.0;

    public VNAZAbsScale() {
        super(VNAMessages.getString("Scale.ZABS"), VNAMessages.getString("Scale.ZABS.Description"), VNAScaleSymbols.SCALE_TYPE.SCALE_Z_ABS, "Ohm", VNAFormatFactory.getZFormat(), 0.0, 99999.0);
    }

    @Override
    public int getScaledSampleValue(VNACalibratedSample sample, int height) {
        int rc = 0;
        double z = sample.getZ();
        rc = this.getCurrentMaxValue() > 0.0 && this.getCurrentMinValue() >= 0.0 ? (int)((double)height * ((z - this.getCurrentMinValue()) / this.getRange())) : (this.getCurrentMaxValue() > 0.0 && this.getCurrentMinValue() < 0.0 ? (int)((double)height * ((z - this.getCurrentMinValue()) / this.getRange())) : (int)((double)(--height) * ((z - this.getCurrentMinValue()) / this.getRange())));
        return height - rc;
    }

    @Override
    public void initScaleFromConfigOrDib(VNADeviceInfoBlock block, VNAConfig config) {
        TraceHelper.entry(this, "initScaleFromConfigOrDib");
        this.setAbsolutMinValue(0.0);
        this.setAbsolutMaxValue(99999.0);
        this.setDefaultMinValue(config.getDouble(String.valueOf(this.getClass().getSimpleName()) + ".defaultMinValue", 0.0));
        this.setDefaultMaxValue(config.getDouble(String.valueOf(this.getClass().getSimpleName()) + ".defaultMaxValue", 1000.0));
        this.resetDefault();
        TraceHelper.exit(this, "initScaleFromConfigOrDib");
    }

    @Override
    public boolean supportsCustomScaling() {
        return true;
    }
}

