/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.gui.scale.values;

import krause.util.ras.logging.TraceHelper;
import krause.vna.config.VNAConfig;
import krause.vna.data.calibrated.VNACalibratedSample;
import krause.vna.device.VNADeviceInfoBlock;
import krause.vna.gui.format.VNAFormatFactory;
import krause.vna.gui.scale.VNAScaleSymbols;
import krause.vna.gui.scale.values.VNALinearScale;
import krause.vna.resources.VNAMessages;

public class VNAThetaScale
extends VNALinearScale {
    private static final double ABSOLUTE_MIN = -95.0;
    private static final double ABSOLUTE_MAX = 95.0;
    private static final double DEFAULT_MIN = -90.0;
    private static final double DEFAULT_MAX = 90.0;

    public VNAThetaScale() {
        super(VNAMessages.getString("Scale.THETA"), VNAMessages.getString("Scale.THETA.Description"), VNAScaleSymbols.SCALE_TYPE.SCALE_THETA, "\u00b0", VNAFormatFactory.getThetaFormat(), -95.0, 95.0);
    }

    @Override
    public int getScaledSampleValue(VNACalibratedSample sample, int height) {
        int rc = 0;
        double theta = sample.getTheta();
        rc = this.getCurrentMaxValue() > 0.0 && this.getCurrentMinValue() >= 0.0 ? (int)((double)height * 1.0 * ((theta - this.getCurrentMinValue()) / this.getRange())) : (this.getCurrentMaxValue() > 0.0 && this.getCurrentMinValue() < 0.0 ? (int)((double)height * 1.0 * ((theta - this.getCurrentMinValue()) / this.getRange())) : (int)((double)(--height) * 1.0 * ((theta - this.getCurrentMinValue()) / this.getRange())));
        return height - rc;
    }

    @Override
    public void initScaleFromConfigOrDib(VNADeviceInfoBlock block, VNAConfig config) {
        TraceHelper.entry(this, "initScaleFromConfigOrDib");
        this.setAbsolutMinValue(-95.0);
        this.setAbsolutMaxValue(95.0);
        this.setDefaultMinValue(config.getDouble(String.valueOf(this.getClass().getSimpleName()) + ".defaultMinValue", -90.0));
        this.setDefaultMaxValue(config.getDouble(String.valueOf(this.getClass().getSimpleName()) + ".defaultMaxValue", 90.0));
        this.resetDefault();
        TraceHelper.exit(this, "initScaleFromConfigOrDib");
    }

    @Override
    public boolean supportsCustomScaling() {
        return true;
    }
}

