/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.gui.scale.values;

import java.awt.Color;
import java.awt.Graphics;
import krause.util.ras.logging.TraceHelper;
import krause.vna.config.VNAConfig;
import krause.vna.data.calibrated.VNACalibratedSample;
import krause.vna.device.VNADeviceInfoBlock;
import krause.vna.gui.format.VNAFormatFactory;
import krause.vna.gui.scale.VNAGenericScale;
import krause.vna.gui.scale.VNAScaleSymbols;
import krause.vna.resources.VNAMessages;

public class VNASWRScale
extends VNAGenericScale {
    public static final double ABSOLUTE_MIN = 1.0;
    public static final double ABSOLUTE_MAX = 50.0;
    public static final double DEFAULT_MIN = 1.0;
    public static final double DEFAULT_MAX = 5.0;

    private double swr2Relative(double swr) {
        return Math.log10(swr);
    }

    private double relative2Swr(double relative) {
        return Math.pow(10.0, relative);
    }

    public VNASWRScale() {
        super(VNAMessages.getString("Scale.SWR"), VNAMessages.getString("Scale.SWR.Description"), VNAScaleSymbols.SCALE_TYPE.SCALE_SWR, null, VNAFormatFactory.getSwrFormat(), 1.0, 50.0);
    }

    @Override
    public int getScaledSampleValue(VNACalibratedSample sample, int height) {
        double swr;
        int rc = 0;
        double newSwr = swr = sample.getSWR();
        if (swr > this.getCurrentMaxValue()) {
            newSwr = this.getCurrentMaxValue();
        } else if (swr < this.getCurrentMinValue()) {
            newSwr = this.getCurrentMinValue();
        }
        double scaleVal = this.swr2Relative(newSwr);
        double relativeMin = this.swr2Relative(this.getCurrentMinValue());
        double relativeMax = this.swr2Relative(this.getCurrentMaxValue());
        double range = relativeMax - relativeMin;
        scaleVal -= relativeMin;
        rc = height - 1 - (int)((double)height * (scaleVal /= range));
        return rc;
    }

    @Override
    public void paintScale(int width, int height, Graphics g) {
        TraceHelper.text(this, "paintScale", "ScaleMax=" + this.getCurrentMaxValue());
        TraceHelper.text(this, "paintScale", "ScaleMin=" + this.getCurrentMinValue());
        TraceHelper.text(this, "paintScale", "RangeScale=" + this.getRange());
        TraceHelper.text(this, "paintScale", "NoOfTicks=" + this.getNoOfTicks());
        g.setColor(Color.BLACK);
        g.setFont(g.getFont().deriveFont(10.0f));
        int[] tc = new int[this.getNoOfTicks() + 1];
        this.setTickCoordinates(tc);
        double stepDiagram = (double)(--height) * 1.0 / (double)this.getNoOfTicks();
        double relMinValue = this.swr2Relative(this.getCurrentMinValue());
        double relMaxValue = this.swr2Relative(this.getCurrentMaxValue());
        double relRange = relMaxValue - relMinValue;
        double relStep = relRange / (double)this.getNoOfTicks();
        TraceHelper.text(this, "paintScale", "ScaleMaxRel=" + relMaxValue);
        TraceHelper.text(this, "paintScale", "ScaleMinRel=" + relMinValue);
        TraceHelper.text(this, "paintScale", "RangeRel=" + relRange);
        TraceHelper.text(this, "paintScale", "StepRel=" + relStep);
        int i = 0;
        while (i <= this.getNoOfTicks()) {
            int y = height - (int)((double)i * stepDiagram);
            g.drawLine(0, y, width, y);
            tc[i] = y;
            double curVal = relMinValue + (double)i * relStep;
            curVal = this.relative2Swr(curVal);
            if (i == this.getNoOfTicks()) {
                y += 9;
            }
            g.drawString(String.valueOf(this.getFormat().format(curVal)) + ":1", 1, y);
            ++i;
        }
    }

    @Override
    public void initScaleFromConfigOrDib(VNADeviceInfoBlock block, VNAConfig config) {
        TraceHelper.entry(this, "initScaleFromConfigOrDib");
        this.setAbsolutMinValue(1.0);
        this.setAbsolutMaxValue(50.0);
        this.setDefaultMinValue(config.getDouble(String.valueOf(this.getClass().getSimpleName()) + ".defaultMinValue", 1.0));
        this.setDefaultMaxValue(config.getDouble(String.valueOf(this.getClass().getSimpleName()) + ".defaultMaxValue", 5.0));
        this.resetDefault();
        TraceHelper.exit(this, "initScaleFromConfigOrDib");
    }

    @Override
    public boolean supportsCustomScaling() {
        return true;
    }
}

