/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.gui.scale.values;

import krause.util.ras.logging.TraceHelper;
import krause.vna.config.VNAConfig;
import krause.vna.data.calibrated.VNACalibratedSample;
import krause.vna.device.VNADeviceInfoBlock;
import krause.vna.gui.format.VNAFormatFactory;
import krause.vna.gui.scale.VNAScaleSymbols;
import krause.vna.gui.scale.values.VNALinearScale;
import krause.vna.resources.VNAMessages;

public class VNARSSScale
extends VNALinearScale {
    private static final double ABSOLUTE_MIN = -80.0;
    private static final double ABSOLUTE_MAX = 10.0;
    private static final double DEFAULT_MIN = -80.0;
    private static final double DEFAULT_MAX = 0.0;

    public VNARSSScale() {
        super(VNAMessages.getString("Scale.RSS"), VNAMessages.getString("Scale.RSS.Description"), VNAScaleSymbols.SCALE_TYPE.SCALE_RSS, "dBm", VNAFormatFactory.getRSSFormat(), -99999.0, 99999.0);
    }

    @Override
    public int getScaledSampleValue(VNACalibratedSample sample, int height) {
        int rc = 0;
        double rss = sample.getRelativeSignalStrength1();
        rc = height - (int)((double)height * ((rss - this.getCurrentMinValue()) / this.getRange()));
        return rc;
    }

    @Override
    public void initScaleFromConfigOrDib(VNADeviceInfoBlock block, VNAConfig config) {
        TraceHelper.entry(this, "initScaleFromConfigOrDib");
        this.setAbsolutMinValue(-80.0);
        this.setAbsolutMaxValue(10.0);
        this.setDefaultMinValue(config.getDouble(String.valueOf(this.getClass().getSimpleName()) + ".defaultMinValue", -80.0));
        this.setDefaultMaxValue(config.getDouble(String.valueOf(this.getClass().getSimpleName()) + ".defaultMaxValue", 0.0));
        this.resetDefault();
        TraceHelper.exit(this, "initScaleFromConfigOrDib");
    }

    @Override
    public boolean supportsCustomScaling() {
        return true;
    }
}

