/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.gui.scale.values;

import krause.util.ras.logging.TraceHelper;
import krause.vna.config.VNAConfig;
import krause.vna.device.VNADeviceInfoBlock;
import krause.vna.gui.format.VNAFormatFactory;
import krause.vna.gui.scale.VNAScaleSymbols;
import krause.vna.gui.scale.values.VNALinearScale;

public abstract class VNAPhaseScale
extends VNALinearScale {
    public VNAPhaseScale(String scaleName, String desc, VNAScaleSymbols.SCALE_TYPE scaleType) {
        super(scaleName, desc, scaleType, "\u00b0", VNAFormatFactory.getPhaseFormat(), -180.0, 180.0);
    }

    @Override
    public void initScaleFromConfigOrDib(VNADeviceInfoBlock block, VNAConfig config) {
        TraceHelper.entry(this, "initScaleFromConfigOrDib");
        this.setAbsolutMaxValue(block.getMaxPhase());
        this.setAbsolutMinValue(block.getMinPhase());
        this.setDefaultMinValue(config.getDouble(String.valueOf(this.getClass().getSimpleName()) + ".defaultMinValue", block.getMinPhase()));
        this.setDefaultMaxValue(config.getDouble(String.valueOf(this.getClass().getSimpleName()) + ".defaultMaxValue", block.getMaxPhase()));
        this.resetDefault();
        TraceHelper.exit(this, "initScaleFromConfigOrDib");
    }

    @Override
    public boolean supportsCustomScaling() {
        return true;
    }

    protected int internalGetScaleSampleValue(double val, int height) {
        int rc = (int)((double)height * 1.0 * ((val - this.getCurrentMinValue()) / this.getRange()));
        rc = height - rc;
        return rc;
    }
}

