/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.gui.scale.values;

import java.awt.Color;
import java.awt.Graphics;
import java.text.NumberFormat;
import krause.vna.gui.scale.VNAGenericScale;
import krause.vna.gui.scale.VNAScaleSymbols;

public abstract class VNALinearScale
extends VNAGenericScale {
    public VNALinearScale(String scaleName, String scaleDescription, VNAScaleSymbols.SCALE_TYPE scaleType, String pUnit, NumberFormat pFormat, double absMinVal, double absMaxVal) {
        super(scaleName, scaleDescription, scaleType, pUnit, pFormat, absMinVal, absMaxVal);
    }

    @Override
    public void paintScale(int width, int height, Graphics g) {
        g.setColor(Color.BLACK);
        g.setFont(this.getFont());
        int nOfTicks = this.getNoOfTicks();
        int[] tickCoordinates = new int[nOfTicks + 1];
        this.setTickCoordinates(tickCoordinates);
        double scale = (double)(--height) * 1.0 / (double)nOfTicks;
        double addi = this.getRange() / (double)nOfTicks;
        double val = this.getCurrentMaxValue();
        int i = 0;
        while (i <= nOfTicks) {
            int y;
            tickCoordinates[i] = y = (int)(scale * (double)i);
            g.drawLine(0, y, width, y);
            if (i == 0) {
                g.drawString(this.getFormat().format(val), 1, y + 10);
            } else {
                g.drawString(this.getFormat().format(val), 1, y - 2);
            }
            val -= addi;
            ++i;
        }
    }
}

