/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.gui.scale.values;

import krause.util.ras.logging.TraceHelper;
import krause.vna.config.VNAConfig;
import krause.vna.data.calibrated.VNACalibratedSample;
import krause.vna.device.VNADeviceInfoBlock;
import krause.vna.gui.format.VNAFormatFactory;
import krause.vna.gui.scale.VNAScaleSymbols;
import krause.vna.gui.scale.values.VNALinearScale;
import krause.vna.resources.VNAMessages;

public class VNAGroupDelayScale
extends VNALinearScale {
    private static final double ABSOLUTE_MAX = 1000.0;
    private static final double ABSOLUTE_MIN = -1000.0;
    private static final double DEFAULT_MAX = 100.0;
    private static final double DEFAULT_MIN = -100.0;

    public VNAGroupDelayScale() {
        super(VNAMessages.getString("Scale.GRPDLY"), VNAMessages.getString("Scale.GRPDLY.Description"), VNAScaleSymbols.SCALE_TYPE.SCALE_GRPDLY, "ns", VNAFormatFactory.getGroupDelayFormat(), -1000.0, 1000.0);
    }

    @Override
    public int getScaledSampleValue(VNACalibratedSample sample, int height) {
        int rc = 0;
        double gd = sample.getGroupDelay();
        rc = height - (int)((double)height * ((gd - this.getCurrentMinValue()) / this.getRange()));
        return rc;
    }

    @Override
    public void initScaleFromConfigOrDib(VNADeviceInfoBlock block, VNAConfig config) {
        TraceHelper.entry(this, "initScaleFromConfigOrDib");
        this.setAbsolutMaxValue(1000.0);
        this.setAbsolutMinValue(-1000.0);
        this.setDefaultMinValue(config.getDouble(String.valueOf(this.getClass().getSimpleName()) + ".defaultMinValue", -100.0));
        this.setDefaultMaxValue(config.getDouble(String.valueOf(this.getClass().getSimpleName()) + ".defaultMaxValue", 100.0));
        this.resetDefault();
        TraceHelper.exit(this, "initScaleFromConfigOrDib");
    }

    @Override
    public boolean supportsCustomScaling() {
        return true;
    }
}

