/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.gui.scale;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import krause.common.gui.KrauseDialog;
import krause.util.ras.logging.TraceHelper;
import krause.vna.config.VNAConfig;
import krause.vna.gui.HelpButton;
import krause.vna.gui.VNAMainFrame;
import krause.vna.gui.scale.VNAGenericScale;
import krause.vna.gui.scale.VNAScaleSymbols;
import krause.vna.gui.scale.VNAScaleTextField;
import krause.vna.gui.util.SwingUtil;
import krause.vna.resources.VNAMessages;
import net.miginfocom.swing.MigLayout;

public class VNAScaleSetupDialog
extends KrauseDialog
implements ActionListener {
    private final JPanel contentPanel;
    private VNAConfig config = VNAConfig.getSingleton();
    private JButton btnSave;
    private JButton btnCancel;
    private ArrayList<VNAGenericScale> lstScales = new ArrayList();

    public VNAScaleSetupDialog(VNAMainFrame pMainFrame) {
        super((Window)pMainFrame.getJFrame(), true);
        TraceHelper.entry(this, "VNAScaleSetupDialog");
        this.setTitle(VNAMessages.getString("VNAScaleSetupDialog.Title"));
        this.setDefaultCloseOperation(0);
        this.setModal(true);
        this.setProperties(this.config);
        this.setConfigurationPrefix("VNAScaleSetupDialog");
        this.setMinimumSize(new Dimension(470, 210));
        this.setPreferredSize(new Dimension(470, 260));
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout((LayoutManager)new MigLayout("", "[grow,fill][30%][][30%][]", "[grow,fill][][]"));
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add(this.contentPanel);
        JLabel lbl = new JLabel(VNAMessages.getString("VNAScaleSetupDialog.Scale"));
        this.contentPanel.add((Component)lbl, "span 5, wrap");
        lbl = new JLabel();
        this.contentPanel.add((Component)lbl, "");
        lbl = new JLabel(VNAMessages.getString("VNAScaleSetupDialog.Min"));
        this.contentPanel.add((Component)lbl, "span 2");
        lbl = new JLabel(VNAMessages.getString("VNAScaleSetupDialog.Max"));
        this.contentPanel.add((Component)lbl, "span 2, wrap");
        this.lstScales.add(VNAScaleSymbols.MAP_SCALE_TYPES.get((Object)VNAScaleSymbols.SCALE_TYPE.SCALE_RS));
        this.lstScales.add(VNAScaleSymbols.MAP_SCALE_TYPES.get((Object)VNAScaleSymbols.SCALE_TYPE.SCALE_XS));
        this.lstScales.add(VNAScaleSymbols.MAP_SCALE_TYPES.get((Object)VNAScaleSymbols.SCALE_TYPE.SCALE_Z_ABS));
        this.lstScales.add(VNAScaleSymbols.MAP_SCALE_TYPES.get((Object)VNAScaleSymbols.SCALE_TYPE.SCALE_RSS));
        this.lstScales.add(VNAScaleSymbols.MAP_SCALE_TYPES.get((Object)VNAScaleSymbols.SCALE_TYPE.SCALE_SWR));
        this.lstScales.add(VNAScaleSymbols.MAP_SCALE_TYPES.get((Object)VNAScaleSymbols.SCALE_TYPE.SCALE_THETA));
        for (VNAGenericScale aScale : this.lstScales) {
            this.createScaleLine(aScale, this.contentPanel);
        }
        this.contentPanel.add((Component)new HelpButton(this, "VNAScaleSetupDialog"), "grow");
        this.btnSave = SwingUtil.createJButton("Button.Save", this);
        this.btnCancel = SwingUtil.createJButton("Button.Cancel", this);
        this.contentPanel.add((Component)this.btnCancel, "span 2, grow");
        this.btnSave.setActionCommand("OK");
        this.contentPanel.add((Component)this.btnSave, "span 2, grow");
        this.getRootPane().setDefaultButton(this.btnSave);
        this.doInit();
        TraceHelper.exit(this, "VNAScaleSetupDialog");
    }

    private void createScaleLine(VNAGenericScale aScale, JPanel contentPanel2) {
        NumberFormat fmt = aScale.getFormat();
        JLabel lbl = new JLabel(aScale.getName());
        this.contentPanel.add((Component)lbl, "");
        VNAScaleTextField txtMin = new VNAScaleTextField(fmt.format(aScale.getDefaultMinValue()), aScale);
        txtMin.setHorizontalAlignment(4);
        txtMin.setBorder(new LineBorder(new Color(171, 173, 179)));
        txtMin.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent arg0) {
                VNAScaleTextField fld = (VNAScaleTextField)arg0.getSource();
                VNAGenericScale s = fld.getScale();
                String txt = fld.getText();
                NumberFormat ft = s.getFormat();
                try {
                    Number val = ft.parse(txt);
                    double d = val.doubleValue();
                    if (d < s.getAbsolutMinValue()) {
                        d = s.getAbsolutMinValue();
                    }
                    s.setDefaultMinValue(d);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                fld.setText(ft.format(s.getDefaultMinValue()));
            }

            @Override
            public void focusGained(FocusEvent arg0) {
            }
        });
        this.contentPanel.add((Component)txtMin, "grow");
        lbl = new JLabel("(" + fmt.format(aScale.getAbsolutMinValue()) + ")");
        this.contentPanel.add((Component)lbl, "right");
        VNAScaleTextField txtMax = new VNAScaleTextField(fmt.format(aScale.getDefaultMaxValue()), aScale);
        txtMax.setHorizontalAlignment(4);
        txtMax.setBorder(new LineBorder(new Color(171, 173, 179)));
        txtMax.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent arg0) {
                VNAScaleTextField fld = (VNAScaleTextField)arg0.getSource();
                VNAGenericScale s = fld.getScale();
                String txt = fld.getText();
                NumberFormat ft = s.getFormat();
                try {
                    Number val = ft.parse(txt);
                    double d = val.doubleValue();
                    if (d > s.getAbsolutMaxValue()) {
                        d = s.getAbsolutMaxValue();
                    }
                    s.setDefaultMaxValue(d);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                fld.setText(ft.format(s.getDefaultMaxValue()));
            }

            @Override
            public void focusGained(FocusEvent arg0) {
            }
        });
        this.contentPanel.add((Component)txtMax, "grow");
        lbl = new JLabel("(" + fmt.format(aScale.getAbsolutMaxValue()) + ")");
        this.contentPanel.add((Component)lbl, "right, wrap");
        txtMax.setMinField(txtMin);
        txtMin.setMinField(txtMax);
    }

    @Override
    protected void doInit() {
        this.addEscapeKey();
        this.doShow();
    }

    protected void doSave() {
        TraceHelper.entry(this, "doSave");
        for (VNAGenericScale aScale : this.lstScales) {
            this.config.putDouble(String.valueOf(aScale.getClass().getSimpleName()) + ".defaultMinValue", aScale.getDefaultMinValue());
            this.config.putDouble(String.valueOf(aScale.getClass().getSimpleName()) + ".defaultMaxValue", aScale.getDefaultMaxValue());
        }
        this.setVisible(false);
        this.dispose();
        TraceHelper.exit(this, "doSave");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TraceHelper.entry(this, "actionPerformed");
        if (e.getSource() == this.btnCancel) {
            this.doCANCEL();
        } else if (e.getSource() == this.btnSave) {
            this.doSave();
        }
        TraceHelper.exit(this, "actionPerformed");
    }

    @Override
    protected void doCANCEL() {
        TraceHelper.entry(this, "doCANCEL");
        this.setVisible(false);
        this.dispose();
        TraceHelper.exit(this, "doCANCEL");
    }
}

