/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.gui.scale;

import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import krause.common.gui.KrauseDialog;
import krause.util.ras.logging.TraceHelper;
import krause.vna.gui.scale.VNAMeasurementScale;
import krause.vna.gui.util.RangeCheckedTextField;
import krause.vna.gui.util.SwingUtil;
import krause.vna.resources.VNAMessages;
import net.miginfocom.swing.MigLayout;

public class VNAScaleConfigDialog
extends KrauseDialog {
    private VNAMeasurementScale scale;
    private boolean exitWithOK = false;
    private JButton btnOK;
    private JButton btCancel;
    private JButton btnReset;
    private RangeCheckedTextField txtCurrMin;
    private RangeCheckedTextField txtCurrMax;

    public VNAScaleConfigDialog(Frame aFrame, VNAMeasurementScale pScale) {
        super((Window)aFrame, true);
        this.scale = pScale;
        this.setTitle(String.valueOf(VNAMessages.getString("VNAScaleConfigDialog.title")) + "-" + this.scale.getScale().getName());
        this.setResizable(true);
        this.setDefaultCloseOperation(2);
        JPanel panel = new JPanel();
        this.getContentPane().add((Component)panel, "Center");
        panel.setLayout((LayoutManager)new MigLayout("", "[][][grow]", ""));
        NumberFormat fmt = NumberFormat.getNumberInstance();
        fmt.setGroupingUsed(false);
        fmt.setMaximumFractionDigits(3);
        fmt.setMinimumFractionDigits(0);
        fmt.setMaximumIntegerDigits(10);
        fmt.setMinimumIntegerDigits(1);
        panel.add((Component)new JLabel(VNAMessages.getString("VNAScaleConfigDialog.max")), "span 2");
        this.txtCurrMax = new RangeCheckedTextField(fmt);
        this.txtCurrMax.setColumns(7);
        panel.add((Component)this.txtCurrMax, "wrap");
        panel.add((Component)new JLabel(VNAMessages.getString("VNAScaleConfigDialog.min")), "span 2");
        this.txtCurrMin = new RangeCheckedTextField(fmt);
        this.txtCurrMin.setColumns(7);
        panel.add((Component)this.txtCurrMin, "wrap");
        this.btnReset = SwingUtil.createJButton("Button.RESET", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VNAScaleConfigDialog.this.txtCurrMax.setValue(VNAScaleConfigDialog.this.txtCurrMax.getUpperLimit());
                VNAScaleConfigDialog.this.txtCurrMin.setValue(VNAScaleConfigDialog.this.txtCurrMin.getLowerLimit());
            }
        });
        panel.add((Component)this.btnReset, "");
        this.btCancel = SwingUtil.createJButton("Button.Cancel", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VNAScaleConfigDialog.this.doCANCEL();
            }
        });
        panel.add((Component)this.btCancel, "");
        this.btnOK = SwingUtil.createJButton("Button.OK", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VNAScaleConfigDialog.this.doOK();
            }
        });
        panel.add((Component)this.btnOK, "grow");
        this.doInit();
    }

    protected void doOK() {
        TraceHelper.entry(this, "doOK");
        this.scale.getScale().setCurrentMaxValue(Math.max(this.txtCurrMax.getValue(), this.txtCurrMin.getValue()));
        this.scale.getScale().setCurrentMinValue(Math.min(this.txtCurrMax.getValue(), this.txtCurrMin.getValue()));
        this.exitWithOK = true;
        this.dispose();
        TraceHelper.exit(this, "doOK");
    }

    @Override
    protected void doCANCEL() {
        TraceHelper.entry(this, "doCANCEL");
        this.dispose();
        TraceHelper.exit(this, "doCANCEL");
    }

    @Override
    protected void doInit() {
        TraceHelper.entry(this, "doInit");
        this.txtCurrMax.setUpperLimit(this.scale.getScale().getDefaultMaxValue());
        this.txtCurrMax.setLowerLimit(this.scale.getScale().getDefaultMinValue());
        this.txtCurrMax.setValue(this.scale.getScale().getCurrentMaxValue());
        this.txtCurrMin.setUpperLimit(this.scale.getScale().getDefaultMaxValue());
        this.txtCurrMin.setLowerLimit(this.scale.getScale().getDefaultMinValue());
        this.txtCurrMin.setValue(this.scale.getScale().getCurrentMinValue());
        this.addEscapeKey();
        this.showCentered(this.getOwner());
        TraceHelper.exit(this, "doInit");
    }

    public boolean isExitWithOK() {
        return this.exitWithOK;
    }
}

