/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.gui.reference;

import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Collections;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import krause.common.exception.ProcessingException;
import krause.common.gui.KrauseDialog;
import krause.util.ras.logging.ErrorLogHelper;
import krause.util.ras.logging.TraceHelper;
import krause.vna.config.VNAConfig;
import krause.vna.data.VNADataPool;
import krause.vna.data.calibrated.VNACalibratedSampleBlock;
import krause.vna.data.reference.VNAReferenceDataBlock;
import krause.vna.data.reference.VNAReferenceDataComparator;
import krause.vna.gui.raw.VNARawHandler;
import krause.vna.gui.reference.IVNAReferenceDataSelectionListener;
import krause.vna.gui.reference.VNAReferenceDataTable;
import krause.vna.gui.util.SwingUtil;
import krause.vna.resources.VNAMessages;
import net.miginfocom.swing.MigLayout;

public class VNAReferenceDataLoadDialog
extends KrauseDialog
implements IVNAReferenceDataSelectionListener {
    private static VNAConfig config = VNAConfig.getSingleton();
    private VNADataPool datapool = VNADataPool.getSingleton();
    private VNAReferenceDataTable lstFiles;
    private File currentDirectoy = new File(config.getReferenceDirectory());
    private JButton btCancel;
    private JButton btOK;
    private JLabel lblDirectory;
    private JTextField txtDirectory;
    private JButton btnSearch;
    private JButton btnRefresh;
    private VNAReferenceDataBlock selectedBlock = null;
    private JButton btClear;

    public VNAReferenceDataLoadDialog(Frame pOwner) {
        super((Window)pOwner, true);
        TraceHelper.entry(this, "VNAReferenceDataLoadDialog");
        this.setConfigurationPrefix("VNAReferenceDataLoadDialog");
        this.setProperties(config);
        this.setTitle(VNAMessages.getString("VNAReferenceDataLoadDialog.title"));
        this.setDefaultCloseOperation(0);
        this.setBounds(100, 100, 800, 333);
        this.setLayout((LayoutManager)new MigLayout("", "[][grow,fill][][]", "[][grow,fill][]"));
        this.lblDirectory = new JLabel(VNAMessages.getString("VNAReferenceDataLoadDialog.lblDirectory.text"));
        this.add((Component)this.lblDirectory, "");
        this.txtDirectory = new JTextField();
        this.txtDirectory.setEditable(false);
        this.txtDirectory.setColumns(30);
        this.add((Component)this.txtDirectory, "");
        this.btnRefresh = new JButton(VNAMessages.getString("VNAReferenceDataLoadDialog.btnRefresh.text"));
        this.btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VNAReferenceDataLoadDialog.this.loadDirectory();
            }
        });
        this.add((Component)this.btnRefresh, "wmin 100px");
        this.btnSearch = new JButton(VNAMessages.getString("VNAReferenceDataLoadDialog.btnSearch.text"));
        this.btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VNAReferenceDataLoadDialog.this.doChangeDirectory();
            }
        });
        this.add((Component)this.btnSearch, "wmin 100px, wrap");
        this.lstFiles = new VNAReferenceDataTable(this);
        JScrollPane scrollPane = new JScrollPane(this.lstFiles);
        scrollPane.setViewportBorder(null);
        this.add((Component)scrollPane, "span 4,grow,wrap");
        this.btClear = SwingUtil.createJButton("Button.Clear", null);
        this.btClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VNAReferenceDataLoadDialog.this.doClearReference();
            }
        });
        this.add((Component)this.btClear, "wmin 100px");
        this.add((Component)new JLabel(), "");
        this.btCancel = SwingUtil.createJButton("Button.Cancel", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VNAReferenceDataLoadDialog.this.doCANCEL();
            }
        });
        this.add((Component)this.btCancel, "wmin 100px");
        this.btOK = SwingUtil.createJButton("Button.Load", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VNAReferenceDataLoadDialog.this.doOK();
            }
        });
        this.add((Component)this.btOK, "wmin 100px, right");
        this.getRootPane().setDefaultButton(this.btOK);
        this.doInit();
        TraceHelper.exit(this, "VNAReferenceDataLoadDialog");
    }

    protected void doClearReference() {
        TraceHelper.entry(this, "doClearReference");
        this.selectedBlock = null;
        this.doOK();
        TraceHelper.exit(this, "doClearReference");
    }

    protected void doChangeDirectory() {
        TraceHelper.entry(this, "doChangeDirectory");
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle(VNAMessages.getString("VNAReferenceDataLoadDialog.directoryChooser"));
        fc.setFileSelectionMode(1);
        fc.setCurrentDirectory(this.currentDirectoy);
        int returnVal = fc.showOpenDialog(this.getOwner());
        if (returnVal == 0) {
            this.currentDirectoy = fc.getSelectedFile();
            this.loadDirectory();
        }
        TraceHelper.exit(this, "doChangeDirectory");
    }

    protected void doOK() {
        TraceHelper.entry(this, "doOK");
        this.datapool.setReferenceData(this.selectedBlock);
        config.setReferenceDirectory(this.currentDirectoy.getAbsolutePath());
        this.setVisible(false);
        this.dispose();
        TraceHelper.exit(this, "doOK");
    }

    @Override
    protected void doCANCEL() {
        TraceHelper.entry(this, "doCANCEL");
        this.setVisible(false);
        this.dispose();
        TraceHelper.exit(this, "doCANCEL");
    }

    @Override
    protected void doInit() {
        TraceHelper.entry(this, "doInit");
        this.addEscapeKey();
        this.loadDirectory();
        this.doShow();
        TraceHelper.exit(this, "doInit");
    }

    private void loadDirectory() {
        TraceHelper.entry(this, "loadDirectory");
        this.txtDirectory.setText(this.currentDirectoy.getAbsolutePath());
        this.lstFiles.getModel().clear();
        FilenameFilter fnf = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toUpperCase().endsWith("XML");
            }
        };
        File[] files = this.currentDirectoy.listFiles(fnf);
        int i = 0;
        while (i < files.length) {
            File currFile = files[i];
            try {
                VNACalibratedSampleBlock calSampleBlock = null;
                calSampleBlock = new VNARawHandler(this).readFile(currFile);
                if (calSampleBlock != null) {
                    VNAReferenceDataBlock blk = new VNAReferenceDataBlock(calSampleBlock);
                    blk.setFile(currFile);
                    this.lstFiles.addReferenceData(blk);
                }
            }
            catch (ProcessingException e) {
                ErrorLogHelper.exception(this, "loadDirectory", e);
            }
            ++i;
        }
        this.btOK.setEnabled(false);
        Collections.sort(this.lstFiles.getModel().getData(), new VNAReferenceDataComparator());
        this.lstFiles.updateUI();
        TraceHelper.exit(this, "loadDirectory");
    }

    @Override
    public void valueChanged(VNAReferenceDataBlock blk, boolean doubleClick) {
        TraceHelper.entry((Object)this, "valueChanged", "dbl=" + doubleClick);
        if (blk != null) {
            this.selectedBlock = blk;
            this.btOK.setEnabled(true);
            if (doubleClick) {
                this.doOK();
            }
        } else {
            this.btOK.setEnabled(false);
        }
        TraceHelper.exit(this, "valueChanged");
    }

    public VNAReferenceDataBlock getSelectedBlock() {
        return this.selectedBlock;
    }
}

