/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.gui.raw;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.util.Locale;
import krause.common.exception.ProcessingException;
import krause.util.ras.logging.ErrorLogHelper;
import krause.util.ras.logging.TraceHelper;
import krause.vna.data.VNADataPool;
import krause.vna.data.calibrated.VNACalibratedSampleBlock;
import krause.vna.resources.VNAMessages;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class VNARawXMLHandler {
    private void createAdditionalData(Element root) {
        root.addContent((Content)new Element("version").setText("1"));
        Element userInfo = new Element("user-info");
        VNADataPool datapool = VNADataPool.getSingleton();
        userInfo.addContent((Content)new Element("timestamp").setText(new Timestamp(System.currentTimeMillis()).toString()));
        userInfo.addContent((Content)new Element("user").setText(System.getProperty("user.name")));
        userInfo.addContent((Content)new Element("country").setText(Locale.getDefault().getCountry()));
        userInfo.addContent((Content)new Element("language").setText(Locale.getDefault().getLanguage()));
        userInfo.addContent((Content)new Element("display-variant").setText(Locale.getDefault().getDisplayVariant()));
        userInfo.addContent((Content)new Element("display-country").setText(Locale.getDefault().getDisplayCountry()));
        userInfo.addContent((Content)new Element("display-language").setText(Locale.getDefault().getDisplayLanguage()));
        userInfo.addContent((Content)new Element("display-variant").setText(Locale.getDefault().getDisplayVariant()));
        userInfo.addContent((Content)new Element("application-version").setText(VNAMessages.getString("Application.version")));
        userInfo.addContent((Content)new Element("application-date").setText(VNAMessages.getString("Application.date")));
        userInfo.addContent((Content)new Element("java-version").setText(System.getProperty("java.version")));
        userInfo.addContent((Content)new Element("java-runtime-version").setText(System.getProperty("java.runtime.version")));
        userInfo.addContent((Content)new Element("java-vm-version").setText(System.getProperty("java.vm.version")));
        userInfo.addContent((Content)new Element("java-vm-vendor").setText(System.getProperty("java.vm.vendor")));
        userInfo.addContent((Content)new Element("os-arch").setText(System.getProperty("os.arch")));
        userInfo.addContent((Content)new Element("os-name").setText(System.getProperty("os.name")));
        userInfo.addContent((Content)new Element("os-version").setText(System.getProperty("os.version")));
        userInfo.addContent((Content)new Element("sun-cpu-endian").setText(System.getProperty("sun.cpu.endian")));
        userInfo.addContent((Content)new Element("sun-desktop").setText(System.getProperty("sun.desktop")));
        userInfo.addContent((Content)new Element("scanmode").setText(datapool.getScanMode().key()));
        userInfo.addContent((Content)new Element("device").setText(datapool.getDriver().getDeviceInfoBlock().getLongName()));
        if (datapool.getMainCalibrationBlock().getFile() != null) {
            userInfo.addContent((Content)new Element("calibration-filename").setText(datapool.getMainCalibrationBlock().getFile().getName()));
        }
        root.addContent((Content)userInfo);
    }

    public String readXMLCommentFromFile(File file) throws ProcessingException {
        TraceHelper.entry((Object)this, "readXMLCommentFromFile", file.getAbsolutePath());
        String rc = "";
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(file);
            Element root = doc.getRootElement();
            if ("vna-j-scandata".equals(root.getName())) {
                rc = root.getChildText("comment");
            }
        }
        catch (Exception e) {
            throw new ProcessingException(e);
        }
        TraceHelper.exitWithRC((Object)this, "readXMLCommentFromFile", rc);
        return rc;
    }

    public VNACalibratedSampleBlock readXMLFromFile(File file) throws ProcessingException {
        TraceHelper.entry(this, "readXMLFromFile");
        VNACalibratedSampleBlock rc = null;
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(file);
            Element root = doc.getRootElement();
            if ("vna-j-scandata".equals(root.getName())) {
                rc = VNACalibratedSampleBlock.fromElement(root);
                if (rc == null) {
                    ErrorLogHelper.text(this, "readXMLFromFile", "error reading root element");
                    throw new ProcessingException(VNAMessages.getString("Message.Import.3"));
                }
            } else {
                ErrorLogHelper.text(this, "readXMLFromFile", "wrong root element found");
                throw new ProcessingException(VNAMessages.getString("Message.Import.3"));
            }
            rc.setFile(file);
        }
        catch (Exception e) {
            ErrorLogHelper.exception(this, "readXMLFromFile", e);
            throw new ProcessingException(e);
        }
        TraceHelper.exit(this, "readXMLFromFile");
        return rc;
    }

    public void writeXMLFile(VNACalibratedSampleBlock data, File file) throws ProcessingException {
        OutputStream fos = null;
        try {
            try {
                Element root = data.asElement();
                this.createAdditionalData(root);
                Document doc = new Document(root);
                XMLOutputter outp = new XMLOutputter();
                outp.setFormat(Format.getPrettyFormat());
                fos = new FileOutputStream(file);
                outp.output(doc, fos);
            }
            catch (FileNotFoundException e) {
                ErrorLogHelper.exception(this, "writeXMLFile", e);
                throw new ProcessingException(e);
            }
            catch (IOException e) {
                ErrorLogHelper.exception(this, "writeXMLFile", e);
                throw new ProcessingException(e);
            }
        }
        finally {
            if (fos != null) {
                try {
                    fos.flush();
                    ((FileOutputStream)fos).close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

