/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.gui.raw;

import java.awt.Window;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import krause.common.exception.ProcessingException;
import krause.util.ras.logging.TraceHelper;
import krause.vna.config.VNAConfig;
import krause.vna.data.VNADataPool;
import krause.vna.data.calibrated.VNACalibratedSampleBlock;
import krause.vna.gui.importers.VNASnPImportDialog;
import krause.vna.gui.raw.VNARawCommentField;
import krause.vna.gui.raw.VNARawXMLHandler;
import krause.vna.resources.VNAMessages;

public class VNARawHandler {
    protected Window owner;
    protected VNAConfig config = VNAConfig.getSingleton();
    protected VNADataPool datapool = VNADataPool.getSingleton();
    public static final String S1P_EXTENSION = "S1P";
    public static final String S2P_EXTENSION = "S2P";
    public static final String RAW_DESCRIPTION = "vna/J Import/Export files";
    public static final String RAW_EXTENSION_V2 = "XML";

    public VNARawHandler(Window pMainFrame) {
        TraceHelper.entry(this, "VNARawHandler");
        this.owner = pMainFrame;
        TraceHelper.exit(this, "VNARawHandler");
    }

    public String doExport(VNACalibratedSampleBlock blk) {
        TraceHelper.entry(this, "doExport");
        String rc = null;
        VNARawCommentField ac = new VNARawCommentField(this.owner, true);
        ac.setText(this.config.getLastRawComment());
        JFileChooser fc = new JFileChooser();
        fc.setAccessory(ac);
        fc.setFileSelectionMode(0);
        fc.setFileFilter(new FileNameExtensionFilter(RAW_DESCRIPTION, RAW_EXTENSION_V2));
        fc.setSelectedFile(new File(String.valueOf(this.config.getReferenceDirectory()) + "/."));
        int returnVal = fc.showSaveDialog(this.owner);
        if (returnVal == 0) {
            String msg;
            int response;
            File file = fc.getSelectedFile();
            this.config.setReferenceDirectory(file.getParent());
            if (!file.getName().endsWith(".XML")) {
                file = new File(String.valueOf(file.getAbsolutePath()) + "." + RAW_EXTENSION_V2);
            }
            if (file.exists() && (response = JOptionPane.showOptionDialog(this.owner, msg = MessageFormat.format(VNAMessages.getString("Message.Export.1"), file.getName()), VNAMessages.getString("Message.Export.2"), 0, 3, null, null, null)) == 2) {
                return rc;
            }
            this.config.setLastRawComment(ac.getText());
            blk.setComment(ac.getText());
            try {
                new VNARawXMLHandler().writeXMLFile(blk, file);
            }
            catch (ProcessingException e) {
                String msg2 = MessageFormat.format(VNAMessages.getString("Message.Export.6"), e.getMessage());
                JOptionPane.showMessageDialog(this.owner, msg2, VNAMessages.getString("Message.Export.5"), 0);
            }
            rc = file.getAbsolutePath();
        }
        TraceHelper.exitWithRC((Object)this, "doExport", rc);
        return rc;
    }

    public VNACalibratedSampleBlock doImport() {
        TraceHelper.entry(this, "doImport");
        VNACalibratedSampleBlock rc = null;
        VNARawCommentField ac = new VNARawCommentField(this.owner, false);
        ac.setEnabled(false);
        JFileChooser fc = new JFileChooser();
        fc.setAccessory(ac);
        fc.addPropertyChangeListener(ac);
        fc.addActionListener(ac);
        fc.setFileSelectionMode(0);
        fc.setSelectedFile(new File(String.valueOf(this.config.getReferenceDirectory()) + "/."));
        fc.setFileFilter(new FileNameExtensionFilter(RAW_DESCRIPTION, RAW_EXTENSION_V2, S1P_EXTENSION, S2P_EXTENSION));
        int returnVal = fc.showOpenDialog(this.owner);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            this.config.setReferenceDirectory(file.getParent());
            try {
                rc = this.readFile(file);
            }
            catch (ProcessingException e) {
                String m = MessageFormat.format(VNAMessages.getString("Message.Import.1"), e.getMessage());
                JOptionPane.showMessageDialog(this.owner, m, VNAMessages.getString("Message.Import.2"), 0);
            }
        }
        TraceHelper.exit(this, "doImport");
        return rc;
    }

    public void exportMainDiagram() {
        TraceHelper.entry(this, "exportMainDiagram");
        VNACalibratedSampleBlock blk = this.datapool.getCalibratedData();
        this.doExport(blk);
        TraceHelper.exit(this, "exportMainDiagram");
    }

    public String readComment(File file) throws ProcessingException {
        TraceHelper.entry(this, "readComment");
        String rc = null;
        if (file != null && file.getAbsolutePath().toUpperCase().endsWith(RAW_EXTENSION_V2)) {
            TraceHelper.text(this, "readComment", "found XML in name");
            rc = new VNARawXMLHandler().readXMLCommentFromFile(file);
        }
        TraceHelper.exitWithRC((Object)this, "readComment", rc);
        return rc;
    }

    public VNACalibratedSampleBlock readFile(File file) throws ProcessingException {
        TraceHelper.entry(this, "readFile");
        VNACalibratedSampleBlock rc = null;
        if (file.getAbsolutePath().toUpperCase().endsWith(RAW_EXTENSION_V2)) {
            rc = new VNARawXMLHandler().readXMLFromFile(file);
        } else if (file.getAbsolutePath().toUpperCase().endsWith(".S1P")) {
            rc = this.readSParameterFile(file);
        } else if (file.getAbsolutePath().toUpperCase().endsWith(".S2P")) {
            rc = this.readSParameterFile(file);
        } else {
            throw new ProcessingException(VNAMessages.getString("Message.Import.3"));
        }
        TraceHelper.exit(this, "readFile");
        return rc;
    }

    private VNACalibratedSampleBlock readSParameterFile(File file) {
        VNACalibratedSampleBlock rc = null;
        TraceHelper.entry(this, "readSParameterFile");
        VNASnPImportDialog dlg = new VNASnPImportDialog(this.owner, file.getAbsolutePath());
        rc = dlg.getData();
        dlg.dispose();
        TraceHelper.exit(this, "readSParameterFile");
        return rc;
    }
}

