/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.gui.preset;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import krause.common.TypedProperties;
import krause.common.gui.KrauseDialog;
import krause.util.PropertiesHelper;
import krause.util.ras.logging.ErrorLogHelper;
import krause.util.ras.logging.TraceHelper;
import krause.vna.config.VNAConfig;
import krause.vna.data.VNADataPool;
import krause.vna.gui.HelpButton;
import krause.vna.gui.VNAMainFrame;
import krause.vna.gui.panels.VNAScaleCheckBox;
import krause.vna.gui.panels.marker.VNAMarker;
import krause.vna.gui.panels.marker.VNAMarkerPanel;
import krause.vna.gui.scale.VNAGenericScale;
import krause.vna.gui.scale.VNAScaleSymbols;
import krause.vna.gui.util.SwingUtil;
import krause.vna.resources.VNAMessages;
import net.miginfocom.swing.MigLayout;
import org.jfree.ui.ExtensionFileFilter;

public class VNAPresetSaveDialog
extends KrauseDialog {
    private VNAMainFrame mainFrame = null;
    private VNAConfig config = VNAConfig.getSingleton();
    private VNADataPool datapool = VNADataPool.getSingleton();
    private JCheckBox cbFreq;
    private JCheckBox cbScanMode;
    private ArrayList<VNAScaleCheckBox> lstScales = new ArrayList();
    private JCheckBox cbMarkers;
    public static final String PREFS_EXTENSION = ".preset";
    public static final String PREFS_DESCRIPTION = "vna/J preset files(*.preset)";

    public VNAPresetSaveDialog(VNAMainFrame pMainFrame) {
        super((Window)pMainFrame.getJFrame(), true);
        TraceHelper.entry(this, "VNAPresetSaveDialog");
        this.mainFrame = pMainFrame;
        this.setConfigurationPrefix("VNAPresetSaveDialog");
        this.setProperties(this.config);
        this.setMinimumSize(new Dimension(350, 300));
        this.setPreferredSize(this.getMinimumSize());
        this.setTitle(VNAMessages.getString("VNAPresetSaveDialog.title"));
        this.getContentPane().setLayout(new BorderLayout());
        JPanel pnlButtons = new JPanel();
        pnlButtons.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "", 4, 2, null, new Color(0, 0, 0)));
        this.getContentPane().add((Component)pnlButtons, "South");
        pnlButtons.add(new HelpButton(this, "VNAPresetSaveDialog"));
        JButton btn = new JButton(VNAMessages.getString("Button.Close"));
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VNAPresetSaveDialog.this.doCANCEL();
            }
        });
        pnlButtons.add(btn);
        pnlButtons.setLayout(new FlowLayout(2, 5, 5));
        btn = SwingUtil.createJButton("Button.Save", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VNAPresetSaveDialog.this.doSAVE();
            }
        });
        pnlButtons.add(btn);
        this.getRootPane().setDefaultButton(btn);
        JPanel dataPanel = new JPanel();
        dataPanel.setLayout((LayoutManager)new MigLayout("", "[grow][][][][]", "[]"));
        this.getContentPane().add((Component)this.createDataPanel(), "Center");
        this.doInit();
        TraceHelper.entry(this, "VNAPresetSaveDialog");
    }

    private JPanel createDataPanel() {
        TraceHelper.entry(this, "createDataPanel");
        JPanel rc = new JPanel();
        rc.setLayout((LayoutManager)new MigLayout("", "[grow]", "[][][]"));
        rc.add((Component)new JLabel(VNAMessages.getString("VNAPresetSaveDialog.help")), "grow,wrap");
        JPanel pnlScales = new JPanel(new GridLayout(4, 4));
        pnlScales.setBorder(new TitledBorder(null, VNAMessages.getString("VNAPresetSaveDialog.scales"), 4, 2, null, null));
        for (VNAGenericScale currScale : VNAScaleSymbols.MAP_SCALE_TYPES.values()) {
            if (!currScale.supportsCustomScaling()) continue;
            VNAScaleCheckBox cb = new VNAScaleCheckBox(currScale.getName(), currScale);
            cb.setSelected(true);
            this.lstScales.add(cb);
            pnlScales.add(cb);
        }
        rc.add((Component)pnlScales, "wrap,grow");
        this.cbFreq = new JCheckBox(VNAMessages.getString("VNAPresetSaveDialog.frequency"));
        this.cbFreq.setSelected(true);
        rc.add((Component)this.cbFreq, "wrap,grow");
        this.cbScanMode = new JCheckBox(VNAMessages.getString("VNAPresetSaveDialog.scanmode"));
        this.cbScanMode.setSelected(true);
        rc.add((Component)this.cbScanMode, "wrap,grow");
        this.cbMarkers = new JCheckBox(VNAMessages.getString("VNAPresetSaveDialog.markers"));
        this.cbMarkers.setSelected(true);
        rc.add((Component)this.cbMarkers, "wrap,grow");
        TraceHelper.exit(this, "createDataPanel");
        return rc;
    }

    @Override
    protected void doCANCEL() {
        TraceHelper.entry(this, "doCANCEL");
        this.setVisible(false);
        this.dispose();
        TraceHelper.exit(this, "doCANCEL");
    }

    @Override
    protected void doInit() {
        TraceHelper.entry(this, "doInit");
        this.addEscapeKey();
        this.doShow();
        TraceHelper.exit(this, "doInit");
    }

    private void doSAVE() {
        TraceHelper.entry(this, "doSAVE");
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(0);
        fc.setFileFilter((FileFilter)new ExtensionFileFilter(PREFS_DESCRIPTION, PREFS_EXTENSION));
        fc.setCurrentDirectory(new File(this.config.getPresetsDirectory()));
        int returnVal = fc.showSaveDialog(this.mainFrame.getJFrame());
        if (returnVal == 0) {
            try {
                File file = fc.getSelectedFile();
                this.config.setPresetsDirectory(file.getParent());
                if (!file.getName().endsWith(PREFS_EXTENSION)) {
                    file = new File(String.valueOf(file.getAbsolutePath()) + PREFS_EXTENSION);
                }
                if (file.exists()) {
                    String msg = MessageFormat.format(VNAMessages.getString("VNAPresetSaveDialog.save.1"), file.getName());
                    int response = JOptionPane.showOptionDialog(this.mainFrame.getJFrame(), msg, VNAMessages.getString("VNAPresetSaveDialog.title"), 0, 3, null, null, null);
                    if (response == 2) {
                        return;
                    }
                }
                TypedProperties props = this.createProperties();
                PropertiesHelper.saveXMLProperties(props, file.getAbsolutePath());
                this.doCANCEL();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.mainFrame.getJFrame(), e.getMessage(), VNAMessages.getString("Message.Export.2"), 0);
                ErrorLogHelper.exception(this, "doExport", e);
            }
        }
        TraceHelper.exit(this, "doSAVE");
    }

    private TypedProperties createProperties() {
        TraceHelper.entry(this, "createProperties");
        TypedProperties rc = new TypedProperties();
        for (VNAScaleCheckBox cb : this.lstScales) {
            if (!cb.getScale().supportsCustomScaling() || !cb.isSelected()) continue;
            cb.getScale().saveToProperties(rc);
        }
        if (this.cbFreq.isSelected()) {
            this.datapool.getFrequencyRange().saveToProperties(rc);
        }
        if (this.cbScanMode.isSelected()) {
            this.datapool.getScanMode().saveToProperties(rc);
        }
        if (this.cbMarkers.isSelected()) {
            VNAMarkerPanel mp = this.mainFrame.getMarkerPanel();
            VNAMarker m = mp.getMarker(0);
            if (m.isVisible()) {
                rc.putLong("Marker1.frq", m.getFrequency());
            }
            if ((m = mp.getMarker(1)).isVisible()) {
                rc.putLong("Marker2.frq", m.getFrequency());
            }
            if ((m = mp.getMarker(2)).isVisible()) {
                rc.putLong("Marker3.frq", m.getFrequency());
            }
            if ((m = mp.getMarker(3)).isVisible()) {
                rc.putLong("Marker4.frq", m.getFrequency());
            }
        }
        TraceHelper.exit(this, "createProperties");
        return rc;
    }
}

