/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.gui.portextension;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import krause.common.gui.KrauseDialog;
import krause.util.ras.logging.TraceHelper;
import krause.vna.config.VNAConfig;
import krause.vna.gui.VNAMainFrame;
import krause.vna.gui.format.VNAFormatFactory;
import krause.vna.gui.util.SwingUtil;
import krause.vna.resources.VNAMessages;
import net.miginfocom.swing.MigLayout;

public class VNAPortExtensionParameterDialog
extends KrauseDialog {
    public static final String KEY_CABLE_INDEX = "PortExtension.cableIndex";
    public static final String KEY_CABLE_VF = "PortExtension.cableVelocityFactor";
    public static final String KEY_CABLE_LENGTH = "PortExtension.cableLength";
    private JButton btCancel;
    private JButton btOK;
    private JTextField txtLength;
    private JTextField txtVf;
    private VNAConfig config = VNAConfig.getSingleton();
    private JPanel pnlButtons;
    private JButton btClear;

    public VNAPortExtensionParameterDialog(VNAMainFrame pMainFrame) {
        super((Window)pMainFrame.getJFrame(), true);
        TraceHelper.entry(this, "VNAPortExtensionParameterDialog");
        this.setConfigurationPrefix("VNAPortExtensionParameterDialog");
        this.setProperties(this.config);
        this.setTitle(VNAMessages.getString("VNAPortExtensionParameterDialog.title"));
        this.setDefaultCloseOperation(0);
        this.setPreferredSize(new Dimension(350, 130));
        this.getContentPane().setLayout((LayoutManager)new MigLayout("", "[][grow,fill]", "[top, grow,fill][][]"));
        this.add((Component)new JLabel(VNAMessages.getString("VNAPortExtensionParameterDialog.lblVf")), "");
        this.txtVf = new JTextField();
        this.txtVf.setColumns(6);
        this.add((Component)this.txtVf, "wrap");
        this.add((Component)new JLabel(VNAMessages.getString("VNAPortExtensionParameterDialog.lblLength.text")), "");
        this.txtLength = new JTextField();
        this.txtLength.setColumns(6);
        this.add((Component)this.txtLength, "wrap");
        this.pnlButtons = new JPanel();
        this.pnlButtons.setLayout((LayoutManager)new MigLayout("", "[][]", "[]"));
        this.getContentPane().add((Component)this.pnlButtons, "span 2, right");
        this.btCancel = SwingUtil.createJButton("VNAPortExtensionParameterDialog.Button.Cancel", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VNAPortExtensionParameterDialog.this.doCANCEL();
            }
        });
        this.pnlButtons.add((Component)this.btCancel, "width 100px");
        this.btClear = SwingUtil.createJButton("VNAPortExtensionParameterDialog.Button.Clear", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VNAPortExtensionParameterDialog.this.doClear();
            }
        });
        this.pnlButtons.add((Component)this.btClear, "width 100px");
        this.btOK = SwingUtil.createJButton("VNAPortExtensionParameterDialog.Button.OK", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VNAPortExtensionParameterDialog.this.doOK();
            }
        });
        this.pnlButtons.add((Component)this.btOK, "width 100px");
        this.doInit();
        TraceHelper.exit(this, "VNAPortExtensionParameterDialog");
    }

    protected void doOK() {
        TraceHelper.entry(this, "doOK");
        Double len = null;
        Double vf = null;
        try {
            len = VNAFormatFactory.getLengthFormat().parse(this.txtLength.getText()).doubleValue();
        }
        catch (ParseException e) {
            JOptionPane.showMessageDialog(this.getOwner(), VNAMessages.getString("VNAPortExtensionParameterDialog.LenNoNumber.msg"), VNAMessages.getString("VNAPortExtensionParameterDialog.title"), 2);
            return;
        }
        try {
            vf = VNAFormatFactory.getVelocityFormat().parse(this.txtVf.getText()).doubleValue();
            if (vf <= 0.0 || vf > 1.0) {
                JOptionPane.showMessageDialog(this.getOwner(), VNAMessages.getString("VNAPortExtensionParameterDialog.VFError.msg"), VNAMessages.getString("VNAPortExtensionParameterDialog.title"), 2);
                return;
            }
        }
        catch (ParseException e) {
            JOptionPane.showMessageDialog(this.getOwner(), VNAMessages.getString("VNAPortExtensionParameterDialog.VFNoNumber.msg"), VNAMessages.getString("VNAPortExtensionParameterDialog.title"), 2);
            return;
        }
        if (len != null && vf != null) {
            this.config.putDouble(KEY_CABLE_LENGTH, len);
            this.config.putDouble(KEY_CABLE_VF, vf);
            this.setVisible(false);
            this.dispose();
        }
        TraceHelper.exit(this, "doOK");
    }

    protected void doClear() {
        this.config.remove(KEY_CABLE_INDEX);
        this.config.remove(KEY_CABLE_LENGTH);
        this.config.remove(KEY_CABLE_VF);
        this.setVisible(false);
        this.dispose();
    }

    @Override
    protected void doCANCEL() {
        TraceHelper.entry(this, "doCANCEL");
        this.setVisible(false);
        this.dispose();
        TraceHelper.exit(this, "doCANCEL");
    }

    @Override
    protected void doInit() {
        TraceHelper.entry(this, "doInit");
        if (this.config.containsKey(KEY_CABLE_VF)) {
            double vf = this.config.getDouble(KEY_CABLE_VF, 0.0);
            this.txtVf.setText(VNAFormatFactory.getVelocityFormat().format(vf));
        }
        if (this.config.containsKey(KEY_CABLE_LENGTH)) {
            double len = this.config.getDouble(KEY_CABLE_LENGTH, 0.0);
            this.txtLength.setText(VNAFormatFactory.getLengthFormat().format(len));
        }
        this.addEscapeKey();
        this.doShow();
        TraceHelper.exit(this, "doInit");
    }
}

