/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.gui.panels.data.table;

import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import krause.vna.gui.util.VNAFrequencyPair;

public class VNAFrequencyPairTableModel
extends AbstractTableModel {
    private List<VNAFrequencyPair> data = new ArrayList<VNAFrequencyPair>();

    public void addElement(VNAFrequencyPair newPair) {
        boolean isNew = true;
        for (VNAFrequencyPair pair : this.data) {
            if (!pair.equals(newPair)) continue;
            isNew = false;
            break;
        }
        if (isNew) {
            this.data.add(newPair);
            this.fireTableDataChanged();
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void clear() {
        this.data.clear();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return "Start";
        }
        if (column == 1) {
            return "Stop";
        }
        return "???";
    }

    public List<VNAFrequencyPair> getData() {
        return this.data;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object rc = null;
        VNAFrequencyPair pair = this.data.get(rowIndex);
        rc = columnIndex == 0 ? Long.valueOf(pair.getStartFrequency()) : (columnIndex == 1 ? Long.valueOf(pair.getStopFrequency()) : "???");
        return rc;
    }
}

