/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.gui.panels;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import krause.util.ras.logging.TraceHelper;
import krause.vna.config.VNAConfig;
import krause.vna.data.VNABandMap;
import krause.vna.data.VNADataPool;
import krause.vna.data.calibrated.VNACalibratedSample;
import krause.vna.data.calibrated.VNACalibratedSampleBlock;
import krause.vna.data.helper.VNACalibratedSampleHelper;
import krause.vna.data.reference.VNAReferenceDataBlock;
import krause.vna.data.reference.VNAReferenceDataHelper;
import krause.vna.device.IVNADriver;
import krause.vna.gui.VNAMainFrame;
import krause.vna.gui.panels.VNADiagramPanel;
import krause.vna.gui.panels.VNAScaleSelectPanel;
import krause.vna.gui.panels.marker.VNAMarker;
import krause.vna.gui.scale.VNAGenericScale;
import krause.vna.gui.util.VNAFrequencyPair;

public class VNAImagePanel
extends JPanel
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
ComponentListener {
    private final VNAConfig config = VNAConfig.getSingleton();
    private final VNADataPool datapool = VNADataPool.getSingleton();
    private final Font font = new Font("Dialog", 0, 17);
    private final VNABandMap bandMap = new VNABandMap();
    private int lastMouseX = -1;
    private VNAMainFrame mainFrame;
    private int lastMouseY = -1;
    private Cursor lastCursor = null;

    public VNAImagePanel(VNAMainFrame pMainFrame) {
        this.setBorder(new BevelBorder(0, null, null, null, null));
        this.mainFrame = pMainFrame;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addComponentListener(this);
        TraceHelper.exit(this, "componentResized");
    }

    @Override
    public void componentHidden(ComponentEvent arg0) {
    }

    @Override
    public void componentMoved(ComponentEvent arg0) {
    }

    @Override
    public void componentResized(ComponentEvent arg0) {
        Dimension dim = this.getSize();
        VNAConfig.getSingleton().setNumberOfSamples((int)dim.getWidth());
        this.datapool.clearResizedCalibrationBlock();
        this.datapool.clearCalibratedData();
        this.mainFrame.getDiagramPanel().repaint();
    }

    @Override
    public void componentShown(ComponentEvent arg0) {
    }

    public VNACalibratedSample getSampleAtMousePosition(int mouseX) {
        VNACalibratedSample rc = null;
        if (this.datapool.getCalibratedData() != null) {
            try {
                rc = this.datapool.getCalibratedData().getCalibratedSamples()[mouseX];
                rc.setDiagramX(mouseX);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return rc;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        TraceHelper.entry(this, "mouseClicked");
        VNAMarker marker = this.mainFrame.getMarkerPanel().getMarkerForMouseEvent(e);
        if (marker != null) {
            marker.update(this.getSampleAtMousePosition(e.getX()));
            this.repaint();
            VNAScaleSelectPanel ssp = this.mainFrame.getDiagramPanel().getScaleSelectPanel();
            if (ssp.getSmithDialog() != null) {
                ssp.getSmithDialog().consumeCalibratedData(this.datapool.getCalibratedData());
            }
        } else if (e.getButton() == 3 && (e.getModifiers() & 0xB) == 0) {
            TraceHelper.text(this, "mouseClicked", "right-button clicked");
            this.mainFrame.getMenuAndToolbarHandler().doExportJPGClipboard();
        }
        TraceHelper.exit(this, "mouseClicked");
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.lastCursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(1));
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.lastMouseY = -1;
        this.lastMouseX = -1;
        if (this.lastCursor != null) {
            this.setCursor(this.lastCursor);
        }
        this.mainFrame.getMarkerPanel().getMouseMarker().update(null);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.lastMouseX = e.getX();
        this.lastMouseY = e.getY();
        if (this.datapool.getCalibratedData() != null) {
            this.mainFrame.getMarkerPanel().getMouseMarker().update(this.getSampleAtMousePosition(e.getX()));
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.mainFrame.getMarkerPanel().consumeMouseWheelEvent(e);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        int width = this.getWidth();
        int height = this.getHeight();
        g.setColor(this.config.getColorDiagram());
        g.fillRect(0, 0, width, height);
        VNACalibratedSampleBlock calData = this.datapool.getCalibratedData();
        if (calData != null) {
            Color colLeft = this.config.getColorScaleLeft();
            Color colRight = this.config.getColorScaleRight();
            Color colDiagramLine = this.config.getColorDiagramLines();
            VNAMarker[] markers = this.mainFrame.getMarkerPanel().getMarkers();
            VNADiagramPanel diagPanel = this.mainFrame.getDiagramPanel();
            VNACalibratedSample[] samples = calData.getCalibratedSamples();
            int numSamples = samples.length;
            if (numSamples > 1) {
                VNAReferenceDataBlock refBlock;
                VNAGenericScale scaleLeft = diagPanel.getScaleLeft().getScale();
                VNAGenericScale scaleRight = diagPanel.getScaleRight().getScale();
                VNACalibratedSample sample = samples[0];
                int lastY1 = scaleLeft.getScaledSampleValue(sample, height);
                int lastY2 = scaleRight.getScaledSampleValue(sample, height);
                int lastX = 0;
                if (this.config.isShowBandmap()) {
                    Color col = this.config.getColorBandmap();
                    int x = 1;
                    while (x < numSamples) {
                        sample = samples[x];
                        long frq = sample.getFrequency();
                        for (VNAFrequencyPair pair : this.bandMap.getList()) {
                            if (!pair.isWithinPair(frq)) continue;
                            g.setColor(col);
                            g.drawLine(x, 1, x, height - 2);
                            break;
                        }
                        ++x;
                    }
                }
                if ((refBlock = this.datapool.getReferenceData()) != null) {
                    long startFreq = samples[0].getFrequency();
                    long stopFreq = samples[numSamples - 1].getFrequency();
                    refBlock.prepare(samples, startFreq, stopFreq);
                    VNAReferenceDataHelper.paint(g, scaleLeft, scaleRight, numSamples, height, refBlock.getResizedSamples());
                }
                int x = 1;
                while (x < numSamples) {
                    sample = samples[x];
                    sample.setDiagramX(x);
                    int rY1 = scaleLeft.getScaledSampleValue(sample, height);
                    int rY2 = scaleRight.getScaledSampleValue(sample, height);
                    g.setColor(colLeft);
                    g.drawLine(lastX, lastY1, x, rY1);
                    g.setColor(colRight);
                    g.drawLine(lastX, lastY2, x, rY2);
                    lastX = x;
                    lastY1 = rY1;
                    lastY2 = rY2;
                    int[] polyX = new int[]{x, x - 5, x + 5};
                    VNAMarker[] vNAMarkerArray = markers;
                    int n = markers.length;
                    int n2 = 0;
                    while (n2 < n) {
                        VNAMarker marker = vNAMarkerArray[n2];
                        if (marker.isVisible() && x == marker.getDiagramX()) {
                            marker.update(sample);
                            g.setColor(marker.getMarkerColor());
                            if (this.config.isMarkerModeLine()) {
                                g.drawLine(x, 1, x, height - 2);
                                if (x > width - 20) {
                                    g.drawString(marker.getShortName(), x - 15, 20);
                                } else {
                                    g.drawString(marker.getShortName(), x + 2, 20);
                                }
                            } else {
                                int[] polyY;
                                if (rY1 > 20) {
                                    polyY = new int[]{rY1, rY1 - 7, rY1 - 7};
                                    g.drawString(marker.getShortName(), x - 3, rY1 - 7);
                                    g.drawPolygon(polyX, polyY, 3);
                                } else {
                                    polyY = new int[]{rY1, rY1 + 7, rY1 + 7};
                                    g.drawString(marker.getShortName(), x - 3, rY1 + 20);
                                    g.drawPolygon(polyX, polyY, 3);
                                }
                                if (rY2 > 20) {
                                    polyY = new int[]{rY2, rY2 - 7, rY2 - 7};
                                    g.drawString(marker.getShortName(), x - 3, rY2 - 7);
                                    g.drawPolygon(polyX, polyY, 3);
                                } else {
                                    polyY = new int[]{rY2, rY2 + 7, rY2 + 7};
                                    g.drawString(marker.getShortName(), x - 3, rY2 + 20);
                                    g.drawPolygon(polyX, polyY, 3);
                                }
                            }
                        }
                        ++n2;
                    }
                    if (this.lastMouseX == x) {
                        this.mainFrame.getMarkerPanel().getMouseMarker().update(sample);
                    }
                    int[] ticks = scaleLeft.getTickCoordinates();
                    if ((x & 7) == 1) {
                        g.setColor(colDiagramLine);
                        int t = 0;
                        while (t < ticks.length) {
                            g.drawLine(x, ticks[t], x, ticks[t]);
                            ++t;
                        }
                    }
                    ++x;
                }
                if (markers[0].isVisible() && markers[1].isVisible()) {
                    VNACalibratedSample s1 = this.mainFrame.getMarkerPanel().getMarker(0).getSample();
                    VNACalibratedSample s2 = this.mainFrame.getMarkerPanel().getMarker(1).getSample();
                    this.mainFrame.getMarkerPanel().getDeltaMarker().update(VNACalibratedSampleHelper.delta(s1, s2));
                } else {
                    this.mainFrame.getMarkerPanel().getDeltaMarker().update(null);
                }
            }
        } else {
            IVNADriver drv = this.datapool.getDriver();
            if (drv != null) {
                this.setFont(this.font);
                if (drv.isScanSupported(width, null, null)) {
                    g.setColor(Color.GREEN);
                } else {
                    g.setColor(Color.RED);
                }
                g.drawString("Diagramm-width=" + width + " -Height=" + height, 50, height / 2);
            }
        }
    }
}

