/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.gui.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import krause.common.exception.ProcessingException;
import krause.util.ras.logging.TraceHelper;
import krause.vna.background.VNABackgroundJob;
import krause.vna.config.VNAConfig;
import krause.vna.data.IVNADataConsumer;
import krause.vna.data.VNAApplicationState;
import krause.vna.data.VNADataPool;
import krause.vna.data.VNASampleBlock;
import krause.vna.data.calibrated.VNACalibratedSampleBlock;
import krause.vna.data.calibrated.VNACalibrationBlock;
import krause.vna.data.calibrated.VNACalibrationContext;
import krause.vna.data.helper.VNASampleBlockHelper;
import krause.vna.data.observer.VNAApplicationStateObserver;
import krause.vna.device.IVNADriverMathHelper;
import krause.vna.device.VNADeviceInfoBlock;
import krause.vna.export.CSVExporter;
import krause.vna.export.JpegExporter;
import krause.vna.export.PDFExporter;
import krause.vna.export.SnPExporter;
import krause.vna.export.VNAExporter;
import krause.vna.export.XLSExporter;
import krause.vna.export.XMLExporter;
import krause.vna.export.ZPlotsExporter;
import krause.vna.gui.VNAMainFrame;
import krause.vna.gui.format.VNAFormatFactory;
import krause.vna.gui.panels.VNAImagePanel;
import krause.vna.gui.panels.VNAScaleSelectPanel;
import krause.vna.gui.panels.marker.VNAMarker;
import krause.vna.gui.scale.VNAFrequencyScale;
import krause.vna.gui.scale.VNAGenericScale;
import krause.vna.gui.scale.VNAMeasurementScale;
import krause.vna.gui.scale.VNAScaleSymbols;
import krause.vna.resources.VNAMessages;

public class VNADiagramPanel
extends JPanel
implements IVNADataConsumer,
VNAApplicationStateObserver {
    private VNAMainFrame mainFrame;
    private VNAFrequencyScale frequencyScale = null;
    private VNAMeasurementScale scaleLeft = null;
    private VNAMeasurementScale scaleRight = null;
    private VNAImagePanel imagePanel = null;
    private VNAScaleSelectPanel scaleSelectPanel = null;
    private VNAConfig config = VNAConfig.getSingleton();
    private VNADataPool datapool = VNADataPool.getSingleton();

    public VNADiagramPanel(VNAMainFrame pMainFrame) {
        this.setBorder(new EtchedBorder(1, null, null));
        TraceHelper.entry(this, "VNADiagramPanel");
        this.mainFrame = pMainFrame;
        this.setLayout(new BorderLayout());
        this.imagePanel = new VNAImagePanel(this.mainFrame);
        this.add((Component)this.imagePanel, "Center");
        this.scaleLeft = new VNAMeasurementScale(VNAScaleSymbols.MAP_SCALE_TYPES.get((Object)VNAScaleSymbols.SCALE_TYPE.SCALE_RETURNLOSS), true, this.mainFrame.getJFrame());
        this.add((Component)this.scaleLeft, "West");
        this.scaleRight = new VNAMeasurementScale(VNAScaleSymbols.MAP_SCALE_TYPES.get((Object)VNAScaleSymbols.SCALE_TYPE.SCALE_RETURNPHASE), false, this.mainFrame.getJFrame());
        this.add((Component)this.scaleRight, "East");
        this.frequencyScale = new VNAFrequencyScale(this.scaleLeft, this.scaleRight);
        this.add((Component)this.frequencyScale, "Last");
        this.scaleSelectPanel = new VNAScaleSelectPanel(this.mainFrame, this.scaleLeft, this.scaleRight);
        this.add((Component)this.scaleSelectPanel, "First");
        TraceHelper.exit(this, "VNADiagramPanel");
    }

    public void setupColors() {
        this.scaleSelectPanel.setupColors();
        this.scaleLeft.setupColors();
        this.scaleRight.setupColors();
        this.imagePanel.repaint();
    }

    public VNAFrequencyScale getScaleFrequency() {
        return this.frequencyScale;
    }

    public VNAMeasurementScale getScaleLeft() {
        return this.scaleLeft;
    }

    public VNAMeasurementScale getScaleRight() {
        return this.scaleRight;
    }

    public VNAImagePanel getImagePanel() {
        return this.imagePanel;
    }

    @Override
    public void consumeDataBlock(List<VNABackgroundJob> jobs) {
        TraceHelper.entry(this, "consumeDataBlock");
        ArrayList<VNASampleBlock> blocks = new ArrayList<VNASampleBlock>();
        VNASampleBlock data = null;
        if (jobs.size() > 1) {
            for (VNABackgroundJob job : jobs) {
                blocks.add(job.getResult());
            }
            data = VNASampleBlockHelper.calculateAverageSampleBlock(blocks);
        } else if (jobs.size() == 1) {
            data = jobs.get(0).getResult();
        }
        this.datapool.setRawData(data);
        this.processRawData();
        this.repaint();
        TraceHelper.exit(this, "consumeDataBlock");
    }

    public void processRawData() {
        IVNADriverMathHelper mathHelper;
        TraceHelper.entry(this, "processRawData");
        VNASampleBlock data = this.datapool.getRawData();
        if (data != null && (mathHelper = data.getMathHelper()) != null) {
            mathHelper.applyFilter(data.getSamples());
            VNACalibrationBlock calBlock = this.datapool.getResizedCalibrationBlock();
            if (calBlock != null) {
                VNACalibrationContext context = mathHelper.createCalibrationContextForCalibratedSamples(calBlock);
                context.setConversionTemperature(data.getDeviceTemperature());
                if (this.config.containsKey("PortExtension.cableVelocityFactor")) {
                    double vf = this.config.getDouble("PortExtension.cableVelocityFactor", 0.0);
                    context.setPexVf(vf);
                }
                if (this.config.containsKey("PortExtension.cableLength")) {
                    double len = this.config.getDouble("PortExtension.cableLength", 0.0);
                    context.setPexLength(len);
                }
                VNACalibratedSampleBlock calSamples = mathHelper.createCalibratedSamples(context, data);
                this.datapool.setCalibratedData(calSamples);
                this.updateMarkerPanel();
                if (this.config.isAutoscaleEnabled()) {
                    this.rescaleScalesToData();
                }
                this.handleAutoExport();
                long total = Runtime.getRuntime().totalMemory() / 0x100000L;
                long free = Runtime.getRuntime().freeMemory() / 0x100000L;
                String msg = "Mem: " + VNAFormatFactory.getFrequencyFormat().format(total) + " / " + VNAFormatFactory.getFrequencyFormat().format(free);
                this.scaleSelectPanel.getLabelDebug().setText(msg);
                if (this.scaleSelectPanel != null && this.scaleSelectPanel.getSmithDialog() != null) {
                    this.scaleSelectPanel.getSmithDialog().consumeCalibratedData(this.datapool.getCalibratedData());
                }
            }
        }
        this.repaint();
        TraceHelper.exit(this, "processRawData");
    }

    private void handleAutoExport() {
        TraceHelper.entry(this, "handleAutoExport");
        String filename = null;
        try {
            if (this.config.getAutoExportFormat() == 1) {
                filename = this.internalAutoExport(new CSVExporter(this.mainFrame));
            }
            if (this.config.getAutoExportFormat() == 2) {
                filename = this.internalAutoExport(new JpegExporter(this.mainFrame));
            }
            if (this.config.getAutoExportFormat() == 3) {
                filename = this.internalAutoExport(new PDFExporter(this.mainFrame));
            }
            if (this.config.getAutoExportFormat() == 4) {
                filename = this.internalAutoExport(new SnPExporter(this.mainFrame));
            }
            if (this.config.getAutoExportFormat() == 5) {
                filename = this.internalAutoExport(new XLSExporter(this.mainFrame));
            }
            if (this.config.getAutoExportFormat() == 6) {
                filename = this.internalAutoExport(new XMLExporter(this.mainFrame));
            }
            if (this.config.getAutoExportFormat() == 7) {
                filename = this.internalAutoExport(new ZPlotsExporter(this.mainFrame));
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.mainFrame.getJFrame(), MessageFormat.format(VNAMessages.getString("Message.Export.5"), e.getMessage()), VNAMessages.getString("Message.Export.6"), 0);
        }
        TraceHelper.exitWithRC((Object)this, "handleAutoExport", filename);
    }

    private String internalAutoExport(VNAExporter exporter) throws ProcessingException {
        TraceHelper.entry(this, "internalAutoExport");
        String fnp = String.valueOf(this.config.getAutoExportDirectory()) + System.getProperty("file.separator") + this.config.getAutoExportFilename();
        String filename = exporter.export(fnp, true);
        TraceHelper.exit(this, "internalAutoExport");
        return filename;
    }

    private void updateMarkerPanel() {
        TraceHelper.entry(this, "updateMarkerPanel");
        VNACalibratedSampleBlock cd = this.datapool.getCalibratedData();
        VNAMarker[] vNAMarkerArray = this.mainFrame.getMarkerPanel().getMarkers();
        int n = vNAMarkerArray.length;
        int n2 = 0;
        while (n2 < n) {
            VNAMarker mark = vNAMarkerArray[n2];
            if (mark.isVisible()) {
                mark.moveMarkerToData(cd);
            }
            ++n2;
        }
        TraceHelper.exit(this, "updateMarkerPanel");
    }

    public void rescaleScalesToData() {
        TraceHelper.entry(this, "rescaleScales");
        VNACalibratedSampleBlock currentData = this.datapool.getCalibratedData();
        if (currentData != null) {
            HashMap<VNAScaleSymbols.SCALE_TYPE, VNAGenericScale> mst = VNAScaleSymbols.MAP_SCALE_TYPES;
            for (VNAGenericScale aScale : mst.values()) {
                if (aScale.getType() == VNAScaleSymbols.SCALE_TYPE.SCALE_NONE) continue;
                aScale.setCurrentMinMaxValue(currentData.getMinMaxPair(aScale.getType()));
                aScale.rescale();
            }
        }
        TraceHelper.exit(this, "rescaleScales");
    }

    @Override
    public void changeState(VNAApplicationState.INNERSTATE oldState, VNAApplicationState.INNERSTATE newState) {
        if (newState == VNAApplicationState.INNERSTATE.DRIVERLOADED) {
            if (oldState == VNAApplicationState.INNERSTATE.DRIVERLOADED || oldState == VNAApplicationState.INNERSTATE.GUIINITIALIZED) {
                VNADeviceInfoBlock dib = this.datapool.getDriver().getDeviceInfoBlock();
                for (VNAGenericScale scale : VNAScaleSymbols.MAP_SCALE_TYPES.values()) {
                    scale.initScaleFromConfigOrDib(dib, this.config);
                }
                this.repaint();
            }
            if (oldState == VNAApplicationState.INNERSTATE.CALIBRATED) {
                this.datapool.setCalibratedData(new VNACalibratedSampleBlock(0));
                this.repaint();
            }
        } else if (newState != VNAApplicationState.INNERSTATE.CALIBRATED) {
        }
        this.scaleSelectPanel.changeState(oldState, newState);
    }

    public VNAScaleSelectPanel getScaleSelectPanel() {
        return this.scaleSelectPanel;
    }

    public void setScaleSelectPanel(VNAScaleSelectPanel scaleSelectPanel) {
        this.scaleSelectPanel = scaleSelectPanel;
    }

    public void clearScanData() {
        this.datapool.setRawData(null);
        this.datapool.setCalibratedData(null);
        this.repaint();
    }
}

