/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.gui.padcalc;

import java.util.ArrayList;
import java.util.List;
import krause.util.ras.logging.TraceHelper;
import krause.vna.gui.padcalc.VNAGenericPad;
import krause.vna.gui.padcalc.VNAPiPad;

public class VNAPadCalculator {
    private VNAGenericPad pad;

    public void calculatePad(double atten) {
        TraceHelper.entry(this, "calculatePad");
        if (this.pad instanceof VNAPiPad) {
            this.calculatePiPad(atten);
        } else {
            this.calculateTPad(atten);
        }
        TraceHelper.exit(this, "calculatePad");
    }

    private void calculateTPad(double atten) {
        TraceHelper.entry(this, "calculateTPad");
        this.calculatePiPad(atten);
        double r3 = this.pad.getR3() * this.pad.getR4() / (this.pad.getR3() + this.pad.getR4() + this.pad.getR5());
        double r4 = this.pad.getR3() * this.pad.getR5() / (this.pad.getR3() + this.pad.getR4() + this.pad.getR5());
        double r5 = this.pad.getR4() * this.pad.getR5() / (this.pad.getR3() + this.pad.getR4() + this.pad.getR5());
        this.pad.setR3(r3);
        this.pad.setR4(r4);
        this.pad.setR5(r5);
        TraceHelper.exit(this, "calculateTPad");
    }

    private void calculatePiPad(double atten) {
        TraceHelper.entry(this, "calculatePiPad");
        double a = Math.log(10.0) / 20.0;
        double z = Math.exp(a * atten);
        double m = this.pad.getR1() / this.pad.getR2();
        double r3 = this.pad.getR1() * (z * z - 1.0) / (z * z - 2.0 * z * Math.sqrt(m) + 1.0);
        double r4 = this.pad.getR1() * (z * z - 1.0) / (2.0 * z * Math.sqrt(m));
        double r5 = this.pad.getR2() * (z * z - 1.0) / (z * z - 2.0 * z / Math.sqrt(m) + 1.0);
        this.pad.setR3(r3);
        this.pad.setR4(r4);
        this.pad.setR5(r5);
        TraceHelper.exit(this, "calculatePiPad");
    }

    public List<Double> calculateSeriesCircuit(double[] fullSeries, double resistanceX, int maxParts, double percentPrecision) {
        ArrayList<Double> rc = new ArrayList<Double>();
        double minVal = resistanceX * (1.0 - percentPrecision);
        double maxVal = resistanceX * (1.0 + percentPrecision);
        int indexFound = -1;
        int i = 0;
        while (i < fullSeries.length) {
            double val = fullSeries[i];
            if (minVal <= val && val <= maxVal) {
                indexFound = i;
                break;
            }
            ++i;
        }
        if (indexFound != -1) {
            rc.add(new Double(fullSeries[indexFound]));
        } else {
            int minIdx = -1;
            int i2 = 0;
            while (i2 < fullSeries.length) {
                double val = fullSeries[i2];
                if (val >= minVal) {
                    minIdx = i2 - 1;
                    break;
                }
                ++i2;
            }
            if (minIdx != -1) {
                double firstRes = fullSeries[minIdx];
                rc.add(new Double(firstRes));
                double newRes = resistanceX - firstRes;
                if (maxParts > 1) {
                    List<Double> newSub = this.calculateSeriesCircuit(fullSeries, newRes, maxParts - 1, percentPrecision);
                    rc.addAll(newSub);
                }
            }
        }
        return rc;
    }

    public double[] createFullSeries(double[] orgSeries, int decades) {
        int orgLen = orgSeries.length;
        int newLen = orgLen * decades;
        double[] rc = new double[newLen];
        int mult = 1;
        int i = 0;
        while (i < decades) {
            int offset = i * orgLen;
            int j = 0;
            while (j < orgLen) {
                double d;
                int idx = j + offset;
                rc[idx] = d = orgSeries[j] * (double)mult;
                ++j;
            }
            mult *= 10;
            ++i;
        }
        return rc;
    }

    public VNAGenericPad getPad() {
        return this.pad;
    }

    public void setPad(VNAGenericPad pad) {
        this.pad = pad;
    }

    public void reverseCalcPad(double atten) {
        TraceHelper.entry(this, "reverseCalcPad");
        if (this.pad instanceof VNAPiPad) {
            this.reverseCalculatePiPad(atten);
        } else {
            this.reverseCalculateTPad(atten);
        }
        TraceHelper.exit(this, "reverseCalcPad");
    }

    private void reverseCalculateTPad(double atten) {
        TraceHelper.entry(this, "reverseCalculateTPad");
        TraceHelper.exit(this, "reverseCalculateTPad");
    }

    private void reverseCalculatePiPad(double atten) {
        TraceHelper.entry(this, "reverseCalculatePiPad");
        VNAPiPad pp = (VNAPiPad)this.getPad();
        double a = Math.log(10.0) / 20.0;
        double z = Math.exp(a * atten);
        double m = pp.getR1() / pp.getR2();
        double r1 = pp.getR3() * (z * z - 2.0 * z * Math.sqrt(m) + 1.0) / (z * z - 1.0);
        double r2 = pp.getR5() * (z * z - 2.0 * z / Math.sqrt(m) + 1.0) / (z * z - 1.0);
        pp.setR1(r1);
        pp.setR2(r2);
        TraceHelper.exit(this, "reverseCalculatePiPad");
    }
}

