/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.gui.net;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import krause.common.TypedProperties;
import krause.common.gui.ILocationAwareDialog;
import krause.common.gui.KrauseDialog;
import krause.common.validation.IntegerValidator;
import krause.common.validation.ValidationResults;
import krause.common.validation.ValidationResultsDialog;
import krause.util.ras.logging.TraceHelper;
import krause.vna.config.VNAConfig;
import krause.vna.device.IVNADriver;
import krause.vna.device.VNADeviceInfoBlock;
import krause.vna.gui.VNAMainFrame;
import krause.vna.resources.VNAMessages;

public class VNANetworkDialog
extends KrauseDialog
implements ActionListener,
ILocationAwareDialog {
    private static final String CONFIG_PREFIX = "VNANetworkDialog";
    private TypedProperties config = VNAConfig.getSingleton();
    private IVNADriver driver;
    private JTextField txtAddress;
    private JTextField txtPort;
    private JTextField txtTimeout;
    private JButton btnCancel;
    private JButton btnOk;
    private JLabel lblTimeout;
    private JLabel lblPort;
    private JLabel lblIpaddress;

    public VNANetworkDialog(VNAMainFrame pMainFrame, IVNADriver pDriver) {
        super((Window)pMainFrame.getJFrame(), true);
        this.driver = pDriver;
        this.setTitle(VNAMessages.getString("VNANetworkDialog.title"));
        this.setDefaultCloseOperation(0);
        JPanel panel = new JPanel();
        this.getContentPane().add((Component)panel, "South");
        this.btnCancel = new JButton(VNAMessages.getString("Button.Cancel"));
        this.btnCancel.addActionListener(this);
        panel.add(this.btnCancel);
        this.btnOk = new JButton(VNAMessages.getString("Button.OK"));
        this.btnOk.addActionListener(this);
        panel.add(this.btnOk);
        JPanel panel_1 = new JPanel();
        panel_1.setBorder(new BevelBorder(1, null, null, null, null));
        this.getContentPane().add((Component)panel_1, "North");
        panel_1.setLayout(new GridLayout(3, 2, 5, 5));
        this.lblTimeout = new JLabel(VNAMessages.getString("VNANetworkDialog.lblTimeout.text"));
        panel_1.add(this.lblTimeout);
        this.txtTimeout = new JTextField();
        this.txtTimeout.setHorizontalAlignment(4);
        panel_1.add(this.txtTimeout);
        this.txtTimeout.setColumns(10);
        this.lblPort = new JLabel(VNAMessages.getString("VNANetworkDialog.lblPort.text"));
        panel_1.add(this.lblPort);
        this.txtPort = new JTextField();
        this.txtPort.setHorizontalAlignment(4);
        panel_1.add(this.txtPort);
        this.txtPort.setColumns(10);
        this.lblIpaddress = new JLabel(VNAMessages.getString("VNANetworkDialog.lblIpaddress.text"));
        panel_1.add(this.lblIpaddress);
        this.txtAddress = new JTextField();
        panel_1.add(this.txtAddress);
        this.txtAddress.setColumns(10);
        this.doInit();
    }

    @Override
    public void dispose() {
        TraceHelper.entry(this, "dispose");
        this.storeWindowPosition();
        this.storeWindowSize();
        super.dispose();
        TraceHelper.exit(this, "dispose");
    }

    @Override
    protected void doInit() {
        TraceHelper.entry(this, "doInit");
        VNADeviceInfoBlock dib = this.driver.getDeviceInfoBlock();
        this.txtAddress.setText(dib.getRemoteAddress());
        this.txtPort.setText("" + dib.getRemotePort());
        this.txtTimeout.setText("" + dib.getRemoteTimeout());
        this.addEscapeKey();
        TraceHelper.exit(this, "doInit");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TraceHelper.entry(this, "actionPerformed");
        TraceHelper.text(this, "actionPerformed", e.toString());
        if (e.getSource() == this.btnOk) {
            this.doOK();
        } else if (e.getSource() == this.btnCancel) {
            this.doCANCEL();
        }
        TraceHelper.exit(this, "actionPerformed");
    }

    private void doOK() {
        TraceHelper.entry(this, "doOK");
        ValidationResults results = new ValidationResults();
        VNADeviceInfoBlock dib = this.driver.getDeviceInfoBlock();
        int timeout = IntegerValidator.parse(this.txtTimeout.getText(), 100, 20000, VNAMessages.getString("VNANetworkDialog.lblIpaddress.text"), results);
        int port = IntegerValidator.parse(this.txtPort.getText(), 1024, 65536, VNAMessages.getString("VNANetworkDialog.lblPort.text"), results);
        if (results.isEmpty()) {
            dib.setRemoteAddress(this.txtAddress.getText());
            dib.setRemotePort(port);
            dib.setRemoteTimeout(timeout);
            dib.store(this.config, this.driver.getDriverConfigPrefix());
            this.dispose();
        } else {
            new ValidationResultsDialog(this.getOwner(), results, VNAMessages.getString("VNANetworkDialog.ErrorDialogHeader"));
        }
        TraceHelper.exit(this, "doOK");
    }

    @Override
    protected void doCANCEL() {
        TraceHelper.entry(this, "doCANCEL");
        this.dispose();
        TraceHelper.exit(this, "doCANCEL");
    }

    @Override
    public void showInPlace() {
        TraceHelper.entry(this, "showInPlace");
        this.restoreWindowPosition();
        this.pack();
        this.restoreWindowSize();
        this.setVisible(true);
        TraceHelper.exit(this, "showInPlace");
    }

    @Override
    public void restoreWindowPosition() {
        TraceHelper.entry(this, "restoreWindowPosition");
        this.config.restoreWindowPosition(CONFIG_PREFIX, this, new Point(10, 10));
        TraceHelper.exit(this, "restoreWindowPosition");
    }

    @Override
    public void restoreWindowSize() {
        TraceHelper.entry(this, "restoreWindowSize");
        this.config.restoreWindowSize(CONFIG_PREFIX, this, new Dimension(810, 345));
        TraceHelper.exit(this, "restoreWindowSize");
    }

    @Override
    public void storeWindowPosition() {
        TraceHelper.entry(this, "storeWindowPosition");
        this.config.storeWindowPosition(CONFIG_PREFIX, this);
        TraceHelper.exit(this, "storeWindowPosition");
    }

    @Override
    public void storeWindowSize() {
        TraceHelper.entry(this, "storeWindowSize");
        this.config.storeWindowSize(CONFIG_PREFIX, this);
        TraceHelper.exit(this, "storeWindowSize");
    }
}

