/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.gui.generator.table;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JTable;
import krause.util.ras.logging.ErrorLogHelper;
import krause.util.ras.logging.TraceHelper;
import krause.vna.gui.generator.table.VNAFrequencyTableModel;
import krause.vna.gui.util.tables.VNAFrequencyRenderer;

public class VNAFrequencyTable
extends JTable {
    public VNAFrequencyTable() {
        super(new VNAFrequencyTableModel());
        TraceHelper.entry(this, "VNAFrequencyTable");
        this.setDefaultRenderer(Long.class, new VNAFrequencyRenderer());
        this.setSelectionMode(0);
        TraceHelper.exit(this, "VNAFrequencyTable");
    }

    public void addFrequency(Long pair) {
        this.getModel().addElement(pair);
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public VNAFrequencyTableModel getModel() {
        return (VNAFrequencyTableModel)super.getModel();
    }

    public boolean load(String myFileName) {
        TraceHelper.entry(this, "load");
        boolean result = false;
        XMLDecoder dec = null;
        FileInputStream fis = null;
        TraceHelper.text(this, "save", "Trying to read from [" + myFileName + "]");
        try {
            try {
                fis = new FileInputStream(myFileName);
                dec = new XMLDecoder(fis);
                this.getModel().clear();
                while (true) {
                    this.getModel().addElement((Long)dec.readObject());
                }
            }
            catch (Exception e) {
                result = true;
                if (dec != null) {
                    dec.close();
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e2) {
                        ErrorLogHelper.exception(this, "load", e2);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            if (dec != null) {
                dec.close();
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    ErrorLogHelper.exception(this, "load", e);
                }
            }
            throw throwable;
        }
        if (this.getModel().getData().size() == 0) {
            this.loadDefaults();
        }
        TraceHelper.exitWithRC((Object)this, "load", result);
        return result;
    }

    public void loadDefaults() {
    }

    public boolean save(String myFileName) {
        boolean result;
        block18: {
            TraceHelper.entry(this, "save");
            result = false;
            TraceHelper.text(this, "save", "Trying to write to [" + myFileName + "]");
            XMLEncoder enc = null;
            FileOutputStream fos = null;
            try {
                try {
                    fos = new FileOutputStream(myFileName);
                    enc = new XMLEncoder(fos);
                    for (Long obj : this.getModel().getData()) {
                        enc.writeObject(obj);
                    }
                    result = true;
                }
                catch (Exception e) {
                    ErrorLogHelper.exception(this, "save", e);
                    ErrorLogHelper.text(this, "save", e.getMessage());
                    if (enc != null) {
                        enc.flush();
                        enc.close();
                    }
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException e2) {
                            ErrorLogHelper.exception(this, "save", e2);
                        }
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (enc != null) {
                    enc.flush();
                    enc.close();
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        ErrorLogHelper.exception(this, "save", e);
                    }
                }
                throw throwable;
            }
            if (enc != null) {
                enc.flush();
                enc.close();
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    ErrorLogHelper.exception(this, "save", e);
                }
            }
        }
        TraceHelper.exitWithRC((Object)this, "save", result);
        return result;
    }
}

