/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.gui.generator.digit;

import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.peer.MouseInfoPeer;
import java.util.HashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import krause.util.ras.logging.TraceHelper;
import krause.vna.gui.generator.digit.VNADigitTextField;

public class VNADigitTextFieldHandler
implements MouseWheelListener,
MouseListener,
MouseInfoPeer {
    private long minValue;
    private long maxValue;
    private long value;
    private long oldValue;
    private HashMap<Long, VNADigitTextField> fieldMap = new HashMap(11);
    protected EventListenerList listenerList = new EventListenerList();
    private transient ChangeEvent changeEvent;

    public VNADigitTextFieldHandler(long minVal, long maxVal) {
        this.minValue = minVal;
        this.maxValue = maxVal;
    }

    private void changeFrequencyByField(VNADigitTextField fld, int counts) {
        long locFreq = this.getValue();
        if ((locFreq += fld.getFactor() * (long)counts) > this.getMaxValue()) {
            Toolkit.getDefaultToolkit().beep();
        } else if (locFreq < this.getMinValue()) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            this.setOldValue(this.getValue());
            this.setValue(locFreq);
        }
        this.fireStateChanged();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        VNADigitTextField fld = (VNADigitTextField)e.getSource();
        int amt = e.getScrollAmount();
        if (e.getUnitsToScroll() != 0) {
            amt /= e.getUnitsToScroll();
        }
        this.changeFrequencyByField(fld, amt);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        TraceHelper.entry((Object)this, "mouseClicked", "" + e.getButton());
        TraceHelper.text(this, "mouseClicked", "" + e.getClickCount());
        VNADigitTextField fld = (VNADigitTextField)e.getSource();
        if (e.getClickCount() > 0) {
            if (e.getButton() == 1) {
                this.changeFrequencyByField(fld, 1);
            } else if (e.getButton() == 3) {
                this.changeFrequencyByField(fld, -1);
            }
        }
        TraceHelper.exit(this, "mouseClicked");
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public int fillPointWithCoords(Point point) {
        return 0;
    }

    @Override
    public boolean isWindowUnderMouse(Window w) {
        return false;
    }

    public VNADigitTextField registerField(VNADigitTextField textField) {
        this.fieldMap.put(new Long(textField.getFactor()), textField);
        textField.addMouseListener(this);
        textField.addMouseWheelListener(this);
        return textField;
    }

    public long getMinValue() {
        return this.minValue;
    }

    public void setMinValue(long minFreq) {
        this.minValue = minFreq;
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(long maxFreq) {
        this.maxValue = maxFreq;
    }

    public void setValue(long val) {
        if (val < this.minValue) {
            this.oldValue = this.value;
            this.value = this.minValue;
            Toolkit.getDefaultToolkit().beep();
        } else if (val > this.maxValue) {
            this.oldValue = this.value;
            this.value = this.maxValue;
            Toolkit.getDefaultToolkit().beep();
        } else {
            this.oldValue = this.value;
            this.value = val;
        }
        this.updateFields();
    }

    private void updateFields() {
        int decades = new Double(Math.log10((double)this.getMaxValue() * 1.0)).intValue() + 1;
        long j = 1L;
        long frq = this.getValue();
        int i = 0;
        while (i < decades) {
            long currDigit = frq / j % 10L;
            VNADigitTextField currField = this.fieldMap.get(new Long(j));
            currField.setValue(currDigit);
            j *= 10L;
            ++i;
        }
    }

    public long getValue() {
        return this.value;
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ChangeListener.class) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
            }
            i -= 2;
        }
    }

    public void setOldValue(long oldValue) {
        this.oldValue = oldValue;
    }

    public long getOldValue() {
        return this.oldValue;
    }
}

