/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.gui.format;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import krause.vna.gui.format.VNAResistenceBaseFormat;

public class VNAResistenceFormat
extends NumberFormat {
    public static final char OMEGA = '\u03a9';
    private NumberFormat baseFormat = new VNAResistenceBaseFormat();

    @Override
    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
        if (number < 1.0E-9) {
            return toAppendTo.append(this.baseFormat.format(number * 1.0E12)).append("p").append('\u03a9');
        }
        if (number < 1.0E-6) {
            return toAppendTo.append(this.baseFormat.format(number * 1.0E9)).append("n").append('\u03a9');
        }
        if (number < 0.001) {
            return toAppendTo.append(this.baseFormat.format(number * 1000000.0)).append("u").append('\u03a9');
        }
        if (number < 1.0) {
            return toAppendTo.append(this.baseFormat.format(number * 1000.0)).append("m").append('\u03a9');
        }
        if (number < 1000.0) {
            return toAppendTo.append(this.baseFormat.format(number / 1.0)).append("").append('\u03a9');
        }
        if (number < 1000000.0) {
            return toAppendTo.append(this.baseFormat.format(number / 1000.0)).append("k").append('\u03a9');
        }
        if (number < 1.0E9) {
            return toAppendTo.append(this.baseFormat.format(number / 1000000.0)).append("M").append('\u03a9');
        }
        return toAppendTo;
    }

    @Override
    public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
        return null;
    }

    @Override
    public Number parse(String source, ParsePosition parsePosition) {
        return this.baseFormat.parse(source, parsePosition);
    }
}

