/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.gui.format;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;

public class VNAInductivityFormat
extends NumberFormat {
    private NumberFormat iFormat = NumberFormat.getNumberInstance();

    public VNAInductivityFormat() {
        this.iFormat.setGroupingUsed(false);
        this.iFormat.setMaximumFractionDigits(2);
        this.iFormat.setMinimumFractionDigits(2);
        this.iFormat.setMaximumIntegerDigits(4);
        this.iFormat.setMinimumIntegerDigits(1);
    }

    @Override
    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
        if (number < 1.0E-9) {
            return toAppendTo.append(this.iFormat.format(number * 1.0E12)).append(" pH");
        }
        if (number < 1.0E-6) {
            return toAppendTo.append(this.iFormat.format(number * 1.0E9)).append(" nH");
        }
        if (number < 0.001) {
            return toAppendTo.append(this.iFormat.format(number * 1000000.0)).append(" uH");
        }
        if (number < 1.0) {
            return toAppendTo.append(this.iFormat.format(number * 1000.0)).append(" mH");
        }
        return toAppendTo;
    }

    @Override
    public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
        return null;
    }

    @Override
    public Number parse(String source, ParsePosition parsePosition) {
        return null;
    }
}

