/*
 * Decompiled with CFR 0.152.
 */
package krause.vna.gui.fft;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import krause.common.gui.KrauseDialog;
import krause.util.ras.logging.TraceHelper;
import krause.vna.background.VNABackgroundJob;
import krause.vna.background.VnaBackgroundTask;
import krause.vna.config.VNAConfig;
import krause.vna.data.IVNADataConsumer;
import krause.vna.data.VNADataPool;
import krause.vna.data.VNAFrequencyRange;
import krause.vna.data.VNASampleBlock;
import krause.vna.data.VNAScanMode;
import krause.vna.data.calibrated.VNACalibratedSample;
import krause.vna.data.calibrated.VNACalibratedSampleBlock;
import krause.vna.data.calibrated.VNACalibrationBlock;
import krause.vna.data.calibrated.VNACalibrationContext;
import krause.vna.data.fft.loni.FastFourierTransform;
import krause.vna.data.helper.VNACalibrationBlockHelper;
import krause.vna.device.IVNADriver;
import krause.vna.device.IVNADriverMathHelper;
import krause.vna.device.VNADeviceInfoBlock;
import krause.vna.export.JFSeries;
import krause.vna.gui.util.SwingUtil;
import krause.vna.resources.VNAMessages;
import net.miginfocom.swing.MigLayout;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;

public class VNAFFTDataDetailsDialog
extends KrauseDialog
implements IVNADataConsumer {
    private static final float STROKE_WIDTH = 1.0f;
    private final Font LABEL_FONT = new Font("SansSerif", 0, 10);
    private final Font TICK_FONT = new Font("SansSerif", 0, 10);
    private JFreeChart chart;
    private ChartPanel lblImage;
    private JButton btCancel;
    private JTextField txtTicks;
    private JTextField txtTickTime;
    private JTextField txtTickLen;
    private JTextField txtLength;
    private JButton btScan;
    private VNADataPool datapool = VNADataPool.getSingleton();
    private IVNADriver driver = this.datapool.getDriver();
    private VNADeviceInfoBlock dib = this.driver.getDeviceInfoBlock();
    private JLabel lblStatus;

    public VNAFFTDataDetailsDialog(Window wnd) {
        super(wnd, true);
        TraceHelper.entry(this, "VNAFFTDataDetailsDialog");
        this.setTitle(VNAMessages.getString("FFT.title"));
        this.setProperties(VNAConfig.getSingleton());
        this.setConfigurationPrefix("VNAFFTDataDetailsDialog");
        this.setDefaultCloseOperation(0);
        this.setPreferredSize(new Dimension(689, 602));
        this.getContentPane().setLayout((LayoutManager)new MigLayout("", "grow", "[grow,fill][][]"));
        this.chart = ChartFactory.createXYLineChart((String)"", (String)"Distance", null, null, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        this.lblImage = new ChartPanel(this.chart, true);
        this.lblImage.setBorder((Border)new TitledBorder(null, "", 4, 2, null, null));
        this.lblImage.setIgnoreRepaint(true);
        this.lblImage.setPreferredSize(new Dimension(640, 480));
        this.lblImage.setLayout((LayoutManager)new FlowLayout(1, 5, 5));
        this.getContentPane().add((Component)this.lblImage, "span 4, wrap,grow");
        this.getContentPane().add((Component)new JLabel(VNAMessages.getString("FFT.SampleTime")), "");
        this.txtTickTime = new JTextField(10);
        this.txtTickTime.setEditable(false);
        this.txtTickTime.setHorizontalAlignment(4);
        this.getContentPane().add((Component)this.txtTickTime, "");
        this.getContentPane().add((Component)new JLabel(VNAMessages.getString("FFT.SampleLen")), "");
        this.txtTickLen = new JTextField(10);
        this.txtTickLen.setEditable(false);
        this.txtTickLen.setHorizontalAlignment(4);
        this.getContentPane().add((Component)this.txtTickLen, "wrap");
        this.getContentPane().add((Component)new JLabel("Peak at:"), "");
        this.txtTicks = new JTextField(10);
        this.txtTicks.setEditable(false);
        this.txtTicks.setHorizontalAlignment(4);
        this.getContentPane().add((Component)this.txtTicks, "");
        this.getContentPane().add((Component)new JLabel("Total length:"), "");
        this.txtLength = new JTextField(10);
        this.txtLength.setEditable(false);
        this.txtLength.setHorizontalAlignment(4);
        this.getContentPane().add((Component)this.txtLength, "wrap");
        this.lblStatus = new JLabel("Ready ...");
        this.getContentPane().add((Component)this.lblStatus, "span 2,grow");
        this.btCancel = SwingUtil.createJButton("Button.Cancel", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VNAFFTDataDetailsDialog.this.doCANCEL();
            }
        });
        this.btCancel.setActionCommand("Cancel");
        this.getContentPane().add((Component)this.btCancel, "center");
        this.btScan = SwingUtil.createJButton("Button.START", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VNAFFTDataDetailsDialog.this.doSTART();
            }
        });
        this.getContentPane().add((Component)this.btScan, "center, wrap");
        this.getRootPane().setDefaultButton(this.btCancel);
        this.doInit();
        TraceHelper.exit(this, "VNAFFTDataDetailsDialog");
    }

    protected void doSTART() {
        TraceHelper.entry(this, "doSTART");
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.btCancel.setEnabled(false);
        this.btScan.setEnabled(false);
        VNABackgroundJob job = new VNABackgroundJob();
        job.setNumberOfSamples(1024);
        job.setSpeedup(1);
        job.setFrequencyRange(new VNAFrequencyRange(this.dib.getMinFrequency(), this.dib.getMaxFrequency()));
        job.setScanMode(VNAScanMode.MODE_REFLECTION);
        VnaBackgroundTask backgroundTask = new VnaBackgroundTask(this.datapool.getDriver());
        backgroundTask.addJob(job);
        backgroundTask.addDataConsumer(this);
        backgroundTask.setStatusLabel(this.lblStatus);
        backgroundTask.execute();
        TraceHelper.exit(this, "doSTART");
    }

    private JFreeChart createChart(double[] real, double[] imag, double oneTickLen) {
        TraceHelper.entry(this, "createChart");
        JFSeries series1 = new JFSeries();
        XYSeries xySeries1 = new XYSeries((Comparable)((Object)"Real"));
        int i = 0;
        while (i < real.length) {
            xySeries1.add((double)i * oneTickLen, real[i]);
            ++i;
        }
        series1.setSeries(xySeries1);
        JFSeries series2 = new JFSeries();
        XYSeries xySeries2 = new XYSeries((Comparable)((Object)"Imag"));
        int i2 = 0;
        while (i2 < imag.length) {
            xySeries2.add((double)i2 * oneTickLen, imag[i2]);
            ++i2;
        }
        series2.setSeries(xySeries2);
        JFreeChart chart = ChartFactory.createXYLineChart(null, (String)"length (m)", null, null, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        chart.setAntiAlias(false);
        XYPlot plot = chart.getXYPlot();
        NumberAxis rangeAxis1 = new NumberAxis(series1.getDataset().getSeries(0).getKey().toString());
        rangeAxis1.setLabelFont(this.LABEL_FONT);
        rangeAxis1.setTickLabelFont(this.TICK_FONT);
        rangeAxis1.setLabelPaint((Paint)Color.RED);
        NumberAxis rangeAxis2 = new NumberAxis(series2.getDataset().getSeries(0).getKey().toString());
        rangeAxis2.setLabelFont(this.LABEL_FONT);
        rangeAxis2.setTickLabelFont(this.TICK_FONT);
        rangeAxis2.setLabelPaint((Paint)Color.BLUE);
        plot.setRangeAxis(0, (ValueAxis)rangeAxis1);
        plot.setRangeAxis(1, (ValueAxis)rangeAxis2);
        plot.setDataset(0, (XYDataset)series1.getDataset());
        plot.setDataset(1, (XYDataset)series2.getDataset());
        plot.mapDatasetToRangeAxis(0, 0);
        chart.setBackgroundPaint((Paint)Color.white);
        plot = chart.getXYPlot();
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setDomainGridlinePaint((Paint)Color.darkGray);
        plot.setRangeGridlinePaint((Paint)Color.darkGray);
        plot.setRenderer(0, (XYItemRenderer)new XYLineAndShapeRenderer(true, false));
        plot.setRenderer(1, (XYItemRenderer)new XYLineAndShapeRenderer(true, false));
        plot.getRenderer(0).setSeriesPaint(0, (Paint)Color.RED);
        plot.getRenderer(1).setSeriesPaint(0, (Paint)Color.BLUE);
        plot.getRenderer(0).setSeriesStroke(0, (Stroke)new BasicStroke(1.0f));
        plot.getRenderer(1).setSeriesStroke(0, (Stroke)new BasicStroke(1.0f));
        plot.getDomainAxis().setLabelFont(this.LABEL_FONT);
        plot.getDomainAxis().setTickLabelFont(this.TICK_FONT);
        TraceHelper.exit(this, "createChart");
        return chart;
    }

    @Override
    protected void doCANCEL() {
        TraceHelper.entry(this, "doExit");
        this.setVisible(false);
        this.dispose();
        TraceHelper.exit(this, "doExit");
    }

    @Override
    protected void doInit() {
        TraceHelper.entry(this, "doInit");
        this.addEscapeKey();
        this.doShow();
        TraceHelper.exit(this, "doInit");
    }

    private void calculate(VNACalibratedSample[] samples) {
        TraceHelper.entry(this, "calculate");
        int len = samples.length;
        double[] real = new double[len];
        double[] imag = new double[len];
        int i = 0;
        while (i < len) {
            real[i] = samples[i].getRHO().getReal();
            imag[i] = samples[i].getRHO().getImaginary();
            ++i;
        }
        FastFourierTransform.fastFT(real, imag, false);
        long startFreq = samples[0].getFrequency();
        long stopFreq = samples[samples.length - 1].getFrequency();
        double oneTickTime = 1.0 / (double)(stopFreq - startFreq) / 2.0;
        double oneTickLen = 1.98E8 * oneTickTime;
        this.chart = this.createChart(imag, real, oneTickLen);
        this.lblImage.setChart(this.chart);
        TraceHelper.exit(this, "calculate");
    }

    @Override
    public void consumeDataBlock(List<VNABackgroundJob> jobs) {
        VNACalibrationBlock mainCalibrationBlock;
        IVNADriverMathHelper mathHelper;
        TraceHelper.entry(this, "consumeDataBlock");
        VNASampleBlock rawData = jobs.get(0).getResult();
        if (rawData != null && (mathHelper = rawData.getMathHelper()) != null && (mainCalibrationBlock = this.datapool.getMainCalibrationBlock()) != null) {
            VNACalibrationBlock resizedCalibrationBlock = VNACalibrationBlockHelper.createResizedCalibrationBlock(mainCalibrationBlock, this.dib.getMinFrequency(), this.dib.getMaxFrequency(), rawData.getNumberOfSteps());
            VNACalibrationContext context = mathHelper.createCalibrationContextForCalibratedSamples(resizedCalibrationBlock);
            context.setConversionTemperature(rawData.getDeviceTemperature());
            if (rawData.getScanMode().isReflectionMode()) {
                VNACalibratedSampleBlock samples = mathHelper.createCalibratedSamples(context, rawData);
                this.calculate(samples.getCalibratedSamples());
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.btCancel.setEnabled(true);
        this.btScan.setEnabled(true);
        TraceHelper.exit(this, "consumeDataBlock");
    }
}

